/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.squirrel_sql.client.IApplicationArguments;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ApplicationArguments
implements IApplicationArguments {
    private static volatile ApplicationArguments s_instance;
    private final Options _options = new Options();
    private CommandLine _cmdLine;
    private String[] _rawArgs;
    private String _squirrelHome = null;
    private String _userSettingsDir = null;
    private String _loggingConfigFile = null;
    private List<String> _pluginList = null;
    private Integer _shutdownTimerSeconds = null;

    private ApplicationArguments(String[] args) throws ParseException {
        String pluginList;
        this.createOptions();
        this._rawArgs = args;
        GnuParser parser = new GnuParser();
        try {
            this._cmdLine = parser.parse(this._options, args);
        }
        catch (ParseException ex) {
            System.err.println("Parsing failed. Reason: " + ex.getMessage());
            this.printHelp();
            throw ex;
        }
        if (this._cmdLine.hasOption(IOptions.SQUIRREL_HOME[0])) {
            this._squirrelHome = this._cmdLine.getOptionValue(IOptions.SQUIRREL_HOME[0]);
        }
        if (this._cmdLine.hasOption(IOptions.USER_SETTINGS_DIR[0])) {
            this._userSettingsDir = this._cmdLine.getOptionValue(IOptions.USER_SETTINGS_DIR[0]);
        }
        if (this._cmdLine.hasOption(IOptions.LOG_FILE[0])) {
            this._loggingConfigFile = this._cmdLine.getOptionValue(IOptions.LOG_FILE[0]);
        }
        if (this._cmdLine.hasOption(IOptions.PLUGIN_LIST[0]) && (pluginList = this._cmdLine.getOptionValue(IOptions.PLUGIN_LIST[0])) != null && !pluginList.isEmpty()) {
            String[] pluginArr = pluginList.split(",");
            this._pluginList = new ArrayList<String>(Arrays.asList(pluginArr));
            this._pluginList = Collections.unmodifiableList(this._pluginList);
        }
        if (this._cmdLine.hasOption(IOptions.SHUTDOWN_TIMEOUT_SECONDS[0])) {
            this._shutdownTimerSeconds = Integer.parseInt(this._cmdLine.getOptionValue(IOptions.SHUTDOWN_TIMEOUT_SECONDS[0]));
        }
    }

    public static synchronized boolean initialize(String[] args) {
        if (s_instance == null) {
            try {
                s_instance = new ApplicationArguments(args);
            }
            catch (ParseException ex) {
                return false;
            }
        } else {
            System.out.println("ApplicationArguments.initialize() called twice");
        }
        return true;
    }

    public static ApplicationArguments getInstance() {
        if (s_instance == null) {
            try {
                s_instance = new ApplicationArguments(new String[0]);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return s_instance;
    }

    @Override
    public String getSquirrelHomeDirectory() {
        return this._squirrelHome;
    }

    @Override
    public String getUserSettingsDirectoryOverride() {
        return this._userSettingsDir;
    }

    @Override
    public boolean getShowSplashScreen() {
        return !this._cmdLine.hasOption(IOptions.NO_SPLASH[0]);
    }

    @Override
    public boolean getShowHelp() {
        return this._cmdLine.hasOption(IOptions.HELP[0]);
    }

    @Override
    public String getLoggingConfigFileName() {
        return this._loggingConfigFile;
    }

    @Override
    public boolean getLoadPlugins() {
        return !this._cmdLine.hasOption(IOptions.NO_PLUGINS[0]);
    }

    @Override
    public boolean useDefaultMetalTheme() {
        return this._cmdLine.hasOption(IOptions.USE_DEFAULT_METAL_THEME[0]);
    }

    @Override
    public boolean useNativeLAF() {
        return this._cmdLine.hasOption(IOptions.USE_NATIVE_LAF[0]);
    }

    @Override
    public String[] getRawArguments() {
        return this._rawArgs;
    }

    @Override
    public boolean getUserInterfaceDebugEnabled() {
        return this._cmdLine.hasOption(IOptions.UI_DEBUG[0]);
    }

    @Override
    public List<String> getPluginList() {
        return this._pluginList;
    }

    public Integer getShutdownTimerSeconds() {
        return this._shutdownTimerSeconds;
    }

    void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("squirrel-sql", this._options);
    }

    private void createOptions() {
        Option opt = this.createAnOption(IOptions.NO_SPLASH);
        this._options.addOption(opt);
        opt = this.createAnOption(IOptions.HELP);
        this._options.addOption(opt);
        opt = this.createAnOption(IOptions.NO_PLUGINS);
        this._options.addOption(opt);
        opt = this.createAnOption(IOptions.USE_DEFAULT_METAL_THEME);
        this._options.addOption(opt);
        opt = this.createAnOption(IOptions.USE_NATIVE_LAF);
        this._options.addOption(opt);
        opt = this.createAnOptionWithArgument(IOptions.SQUIRREL_HOME);
        this._options.addOption(opt);
        opt = this.createAnOptionWithArgument(IOptions.USER_SETTINGS_DIR);
        this._options.addOption(opt);
        opt = this.createAnOptionWithArgument(IOptions.LOG_FILE);
        this._options.addOption(opt);
        opt = this.createAnOption(IOptions.UI_DEBUG);
        this._options.addOption(opt);
        opt = this.createAnOptionWithArgument(IOptions.PLUGIN_LIST);
        this._options.addOption(opt);
        opt = this.createAnOptionWithArgument(IOptions.SHUTDOWN_TIMEOUT_SECONDS);
        this._options.addOption(opt);
    }

    private Option createAnOption(String[] argInfo) {
        Option opt = new Option(argInfo[0], argInfo[2]);
        if (!ApplicationArguments.isStringEmpty(argInfo[1])) {
            opt.setLongOpt(argInfo[1]);
        }
        return opt;
    }

    private Option createAnOptionWithArgument(String[] argInfo) {
        OptionBuilder.withArgName(argInfo[0]);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription(argInfo[2]);
        Option opt = OptionBuilder.create(argInfo[0]);
        if (!ApplicationArguments.isStringEmpty(argInfo[1])) {
            opt.setLongOpt(argInfo[1]);
        }
        return opt;
    }

    private static boolean isStringEmpty(String str) {
        return str == null || str.length() == 0;
    }

    static final void reset() {
        s_instance = null;
    }

    public static interface IOptions {
        public static final String[] HELP = new String[]{"h", "help", "Display Help and exit"};
        public static final String[] SQUIRREL_HOME = new String[]{"home", "squirrel-home", "SQuirreL home directory"};
        public static final String[] LOG_FILE = new String[]{"l", "log-config-file", "Logging configuration file"};
        public static final String[] USE_DEFAULT_METAL_THEME = new String[]{"m", "use-default-metal-theme", "Use default metal theme"};
        public static final String[] USE_NATIVE_LAF = new String[]{"n", "native-laf", "Use native look and feel"};
        public static final String[] NO_PLUGINS = new String[]{"nop", "no-plugins", "Don't load plugins"};
        public static final String[] NO_SPLASH = new String[]{"nos", "no-splash", "Don't display splash screen"};
        public static final String[] USER_SETTINGS_DIR = new String[]{"userdir", "user-settings-dir", "User settings directory"};
        public static final String[] UI_DEBUG = new String[]{"uidebug", "user-interface-debugging", "Provides tool-tips and highlighting of UI components for easy identification"};
        public static final String[] PLUGIN_LIST = new String[]{"pluginlist", "plugin-classpath-list", "Specify a comma-delimited list of plugins to load from the CLASSPATH"};
        public static final String[] SHUTDOWN_TIMEOUT_SECONDS = new String[]{"s", "shutdown-timeout-seconds", "Specify the number of seconds to allow the application to run before exiting the VM"};
    }
}

