/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.HtmlViewerPanel;
import net.sourceforge.squirrel_sql.client.gui.HtmlViewerPanelListenerEvent;
import net.sourceforge.squirrel_sql.client.gui.HtmlViewerPanelToolBar;
import net.sourceforge.squirrel_sql.client.gui.IHtmlViewerPanelListener;
import net.sourceforge.squirrel_sql.client.plugin.PluginInfo;
import net.sourceforge.squirrel_sql.client.resources.SquirrelResources;
import net.sourceforge.squirrel_sql.client.util.ApplicationFileWrappers;
import net.sourceforge.squirrel_sql.client.util.ApplicationFileWrappersImpl;
import net.sourceforge.squirrel_sql.fw.gui.StatusBar;
import net.sourceforge.squirrel_sql.fw.util.BaseException;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactory;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactoryImpl;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import org.apache.commons.lang.StringUtils;

public class HelpViewerWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final ILogger s_log = LoggerController.createLogger(HelpViewerWindow.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(HelpViewerWindow.class);
    private final IApplication _app;
    private JTree _tree;
    private HtmlViewerPanel _detailPnl;
    private StatusBar _statusBar = new StatusBar();
    private URL _homeURL;
    private final Map<String, DefaultMutableTreeNode> _nodes = new HashMap<String, DefaultMutableTreeNode>();
    private FileWrapperFactory fileWrapperFactory = new FileWrapperFactoryImpl();
    private ApplicationFileWrappers applicationFiles = new ApplicationFileWrappersImpl();

    public HelpViewerWindow(IApplication app) throws IllegalArgumentException, BaseException {
        super(s_stringMgr.getString("HelpViewerWindow.title"));
        if (app == null) {
            throw new IllegalArgumentException("IApplication == null");
        }
        this._app = app;
        try {
            this.createGUI();
        }
        catch (IOException ex) {
            throw new BaseException(ex);
        }
    }

    public void setFileWrapperFactory(FileWrapperFactory fileWrapperFactory) {
        Utilities.checkNull("setFileWrapperFactory", "fileWrapperFactory", fileWrapperFactory);
        this.fileWrapperFactory = fileWrapperFactory;
    }

    public void setApplicationFiles(ApplicationFileWrappers applicationFiles) {
        Utilities.checkNull("setApplicationFiles", "applicationFiles", applicationFiles);
        this.applicationFiles = applicationFiles;
    }

    private void setSelectedDocument(URL url) {
        try {
            this._detailPnl.gotoURL(url);
            this._statusBar.setText(s_stringMgr.getString("HelpViewerWindow.pageloaded"));
        }
        catch (IOException ex) {
            s_log.error(s_stringMgr.getString("HelpViewerWindow.error.displaydocument"), ex);
            this._statusBar.setText(ex.toString());
        }
    }

    private void selectTreeNodeForURL(URL url) {
        DefaultTreeModel model;
        TreePath path;
        DefaultMutableTreeNode node;
        String key = url.toString();
        int idx = key.lastIndexOf(35);
        if (idx > -1) {
            key = key.substring(0, idx);
        }
        if ((node = this._nodes.get(key)) != null && (path = new TreePath((model = (DefaultTreeModel)this._tree.getModel()).getPathToRoot(node))) != null) {
            this._tree.expandPath(path);
            this._tree.scrollPathToVisible(path);
            this._tree.setSelectionPath(path);
        }
    }

    private void createGUI() throws IOException {
        this.setDefaultCloseOperation(2);
        SquirrelResources rsrc = this._app.getResources();
        ImageIcon icon = rsrc.getIcon("View");
        if (icon != null) {
            this.setIconImage(icon.getImage());
        }
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setBorder(BorderFactory.createEmptyBorder());
        splitPane.setOneTouchExpandable(true);
        splitPane.setContinuousLayout(true);
        splitPane.add((Component)this.createContentsTree(), "left");
        splitPane.add((Component)this.createDetailsPanel(), "right");
        contentPane.add((Component)splitPane, "Center");
        splitPane.setDividerLocation(200);
        contentPane.add((Component)new HtmlViewerPanelToolBar(this._app, this._detailPnl), "North");
        Font fn = this._app.getFontInfoStore().getStatusBarFontInfo().createFont();
        this._statusBar.setFont(fn);
        contentPane.add((Component)this._statusBar, "South");
        this.pack();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HelpViewerWindow.this._detailPnl.setHomeURL(HelpViewerWindow.this._homeURL);
                HelpViewerWindow.this._tree.expandRow(0);
                HelpViewerWindow.this._tree.expandRow(2);
                if (HelpViewerWindow.this._app.getSquirrelPreferences().isFirstRun()) {
                    HelpViewerWindow.this._tree.setSelectionRow(1);
                } else {
                    HelpViewerWindow.this._tree.setSelectionRow(3);
                }
                HelpViewerWindow.this._tree.setRootVisible(false);
            }
        });
        this._detailPnl.addListener(new IHtmlViewerPanelListener(){

            @Override
            public void currentURLHasChanged(HtmlViewerPanelListenerEvent evt) {
                HelpViewerWindow.this.selectTreeNodeForURL(evt.getHtmlViewerPanel().getURL());
            }

            @Override
            public void homeURLHasChanged(HtmlViewerPanelListenerEvent evt) {
            }
        });
    }

    private JScrollPane createContentsTree() throws IOException {
        String msg;
        DocumentNode dn;
        FolderNode root = new FolderNode(s_stringMgr.getString("HelpViewerWindow.help"));
        this._tree = new JTree(new DefaultTreeModel(root));
        this._tree.setShowsRootHandles(true);
        this._tree.addTreeSelectionListener(new ObjectTreeSelectionListener());
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        SquirrelResources rsrc = this._app.getResources();
        renderer.setLeafIcon(rsrc.getIcon("HelpTopic"));
        renderer.setOpenIcon(rsrc.getIcon("HelpTocOpen"));
        renderer.setClosedIcon(rsrc.getIcon("HelpTocClosed"));
        this._tree.setCellRenderer(renderer);
        FileWrapper file = this.applicationFiles.getWelcomeFile();
        try {
            DocumentNode dn2 = new DocumentNode(s_stringMgr.getString("HelpViewerWindow.welcome"), file);
            root.add(dn2);
            this._nodes.put(dn2.getURL().toString(), dn2);
        }
        catch (MalformedURLException ex) {
            String msg2 = s_stringMgr.getString("HelpViewerWindow.error.loadwelcomefile", file.getAbsolutePath());
            s_log.error(msg2, ex);
        }
        FolderNode helpRoot = new FolderNode(s_stringMgr.getString("HelpViewerWindow.help"));
        root.add(helpRoot);
        this._nodes.put(helpRoot.getURL().toString(), helpRoot);
        FolderNode licenceRoot = new FolderNode(s_stringMgr.getString("HelpViewerWindow.licences"));
        root.add(licenceRoot);
        this._nodes.put(licenceRoot.getURL().toString(), licenceRoot);
        FolderNode changeLogRoot = new FolderNode(s_stringMgr.getString("HelpViewerWindow.changelogs"));
        root.add(changeLogRoot);
        this._nodes.put(changeLogRoot.getURL().toString(), changeLogRoot);
        file = this.applicationFiles.getQuickStartGuideFile();
        try {
            dn = new DocumentNode(s_stringMgr.getString("HelpViewerWindow.squirrel"), file);
            helpRoot.add(dn);
            this._homeURL = dn.getURL();
            this._nodes.put(this._homeURL.toString(), dn);
        }
        catch (MalformedURLException ex) {
            msg = s_stringMgr.getString("HelpViewerWindow.error.loadhelpfile", file.getAbsolutePath());
            s_log.error(msg, ex);
        }
        file = this.applicationFiles.getLicenceFile();
        try {
            dn = new DocumentNode(s_stringMgr.getString("HelpViewerWindow.squirrel"), file);
            licenceRoot.add(dn);
            this._nodes.put(dn.getURL().toString(), dn);
        }
        catch (MalformedURLException ex) {
            msg = s_stringMgr.getString("HelpViewerWindow.error.loadlicencefile", file.getAbsolutePath());
            s_log.error(msg, ex);
        }
        file = this.applicationFiles.getChangeLogFile();
        try {
            dn = new DocumentNode(s_stringMgr.getString("HelpViewerWindow.squirrel"), file);
            changeLogRoot.add(dn);
            this._nodes.put(dn.getURL().toString(), dn);
        }
        catch (MalformedURLException ex) {
            msg = s_stringMgr.getString("HelpViewerWindow.error.loadchangelogfile", file.getAbsolutePath());
            s_log.error(msg, ex);
        }
        PluginInfo[] pi = this._app.getPluginManager().getPluginInformation();
        for (int i = 0; i < pi.length; ++i) {
            try {
                String msg3;
                DocumentNode dn3;
                String fn;
                FileWrapper dir = pi[i].getPlugin().getPluginAppSettingsFolder();
                String title = pi[i].getDescriptiveName();
                try {
                    fn = pi[i].getHelpFileName();
                    if (fn != null && fn.length() > 0) {
                        dn3 = new DocumentNode(title, this.fileWrapperFactory.create(dir, fn));
                        helpRoot.add(dn3);
                        this._nodes.put(dn3.getURL().toString(), dn3);
                    }
                }
                catch (IOException ex) {
                    msg3 = s_stringMgr.getString("HelpViewerWindow.error.loadpluginhelp", pi[i].getDescriptiveName());
                    s_log.error(msg3, ex);
                }
                try {
                    fn = pi[i].getLicenceFileName();
                    if (fn != null && fn.length() > 0) {
                        dn3 = new DocumentNode(title, this.fileWrapperFactory.create(dir, fn));
                        licenceRoot.add(dn3);
                        this._nodes.put(dn3.getURL().toString(), dn3);
                    }
                }
                catch (IOException ex) {
                    msg3 = s_stringMgr.getString("HelpViewerWindow.error.loadpluginlicence", pi[i].getDescriptiveName());
                    s_log.error(msg3, ex);
                }
                try {
                    fn = pi[i].getChangeLogFileName();
                    if (fn == null || fn.length() <= 0) continue;
                    dn3 = new DocumentNode(title, this.fileWrapperFactory.create(dir, fn));
                    changeLogRoot.add(dn3);
                    this._nodes.put(dn3.getURL().toString(), dn3);
                }
                catch (IOException ex) {
                    msg3 = s_stringMgr.getString("HelpViewerWindow.error.loadchangelog", pi[i].getDescriptiveName());
                    s_log.error(msg3, ex);
                }
                continue;
            }
            catch (IOException ex) {
                String msg4 = s_stringMgr.getString("HelpViewerWindow.error.loadpluginsettings", pi[i].getDescriptiveName());
                s_log.error(msg4, ex);
            }
        }
        file = this.applicationFiles.getFAQFile();
        try {
            DocumentNode dn4 = new DocumentNode(s_stringMgr.getString("HelpViewerWindow.faq"), file);
            root.add(dn4);
            this._nodes.put(dn4.getURL().toString(), dn4);
        }
        catch (MalformedURLException ex) {
            String msg5 = s_stringMgr.getString("HelpViewerWindow.error.loadfaqfile", file.getAbsolutePath());
            s_log.error(msg5, ex);
        }
        helpRoot.generateContentsFile();
        licenceRoot.generateContentsFile();
        changeLogRoot.generateContentsFile();
        JScrollPane sp = new JScrollPane(this._tree);
        sp.setPreferredSize(new Dimension(200, 200));
        return sp;
    }

    HtmlViewerPanel createDetailsPanel() {
        this._detailPnl = new HtmlViewerPanel(null);
        return this._detailPnl;
    }

    private final class ObjectTreeSelectionListener
    implements TreeSelectionListener {
        private ObjectTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent evt) {
            Object lastComp;
            TreePath path = evt.getNewLeadSelectionPath();
            if (path != null && (lastComp = path.getLastPathComponent()) instanceof DocumentNode) {
                HelpViewerWindow.this.setSelectedDocument(((DocumentNode)lastComp).getURL());
            }
        }
    }

    private class FolderNode
    extends DocumentNode {
        private static final long serialVersionUID = 1L;
        private final List<String> _docTitles;
        private final List<URL> _docURLs;
        private final FileWrapper _contentsFile;

        FolderNode(String title) throws IOException {
            super(title, true);
            this._docTitles = new ArrayList<String>();
            this._docURLs = new ArrayList<URL>();
            this._contentsFile = HelpViewerWindow.this.fileWrapperFactory.createTempFile("sqschelp", "html");
            this._contentsFile.deleteOnExit();
            this.setFile(this._contentsFile);
        }

        @Override
        public void add(MutableTreeNode node) {
            DocumentNode dn;
            URL docURL;
            super.add(node);
            if (node instanceof DocumentNode && (docURL = (dn = (DocumentNode)node).getURL()) != null) {
                String docTitle = dn.toString();
                if (StringUtils.isEmpty(docTitle)) {
                    docTitle = docURL.toExternalForm();
                }
                this._docTitles.add(docTitle);
                this._docURLs.add(docURL);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void generateContentsFile() {
            try {
                PrintWriter pw = new PrintWriter(this._contentsFile.getFileWriter());
                try {
                    StringBuffer buf = new StringBuffer(50);
                    buf.append("<HTML><BODY><H1>").append(this.toString()).append("</H1>");
                    pw.println(buf.toString());
                    int limit = this._docTitles.size();
                    for (int i = 0; i < limit; ++i) {
                        URL docUrl = this._docURLs.get(i);
                        buf = new StringBuffer(50);
                        buf.append("<A HREF=\"").append(docUrl).append("\">").append(this._docTitles.get(i)).append("</A><BR>");
                        pw.println(buf.toString());
                    }
                    pw.println("</BODY></HTML");
                }
                finally {
                    pw.close();
                }
            }
            catch (IOException ex) {
                String msg = s_stringMgr.getString("HelpViewerWindow.error.congen");
                s_log.error(msg, ex);
                HelpViewerWindow.this._statusBar.setText(msg);
            }
        }
    }

    private class DocumentNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        private URL _url;

        DocumentNode(String title, FileWrapper file) throws MalformedURLException {
            super(title, false);
            this.setFile(file);
        }

        DocumentNode(String title, boolean allowsChildren) {
            super(title, allowsChildren);
        }

        URL getURL() {
            return this._url;
        }

        void setFile(FileWrapper file) throws MalformedURLException {
            this._url = file.toURI().toURL();
        }
    }
}

