/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.builders;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.JTabbedPane;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;

class SquirrelTabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = 3663370280049413647L;
    private SquirrelPreferences _prefs;
    private PropsListener _prefsListener;

    SquirrelTabbedPane(SquirrelPreferences prefs, IApplication app) {
        if (prefs == null) {
            throw new IllegalArgumentException("SquirrelPreferences == null");
        }
        this._prefs = prefs;
        int tabLayoutPolicy = this._prefs.getUseScrollableTabbedPanes() ? 1 : 0;
        this.setTabLayoutPolicy(tabLayoutPolicy);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._prefsListener = new PropsListener(this._prefs, this);
        this._prefs.addPropertyChangeListener(this._prefsListener);
        this._prefsListener.propertiesHaveChanged(null);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this._prefsListener != null) {
            this._prefs.removePropertyChangeListener(this._prefsListener);
            this._prefsListener = null;
        }
    }

    private static final class PropsListener
    implements PropertyChangeListener {
        private SquirrelPreferences _prefs;
        private WeakReference<SquirrelTabbedPane> _refSquirrelTabbedPane;

        public PropsListener(SquirrelPreferences prefs, SquirrelTabbedPane squirrelTabbedPane) {
            this._prefs = prefs;
            this._refSquirrelTabbedPane = new WeakReference<SquirrelTabbedPane>(squirrelTabbedPane);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.propertiesHaveChanged(evt.getPropertyName());
        }

        void propertiesHaveChanged(String propName) {
            SquirrelTabbedPane squirrelTabbedPane = (SquirrelTabbedPane)this._refSquirrelTabbedPane.get();
            if (null == squirrelTabbedPane) {
                return;
            }
            if (propName == null || propName.equals("getUseScrollableTabbedPanes")) {
                int tabLayoutPolicy = this._prefs.getUseScrollableTabbedPanes() ? 1 : 0;
                squirrelTabbedPane.setTabLayoutPolicy(tabLayoutPolicy);
            }
        }
    }

    private static interface IAppPrefPropertynames
    extends SquirrelPreferences.IPropertyNames {
    }
}

