/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.ApplicationListener;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.db.BaseListInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.db.IAliasesList;
import net.sourceforge.squirrel_sql.client.gui.db.IBaseList;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetAdapter;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEvent;
import net.sourceforge.squirrel_sql.client.mainframe.action.AliasPropertiesAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CollapseAllAliasFolderAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ConnectToAliasAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ConnectToAliasCommand;
import net.sourceforge.squirrel_sql.client.mainframe.action.CopyAliasAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CopyToPasteAliasFolderAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CreateAliasAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CutAliasFolderAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.DeleteAliasAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ExpandAllAliasFolderAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ModifyAliasAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.NewAliasFolderAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.PasteAliasFolderAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.SortAliasesAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ToggleTreeViewAction;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.fw.gui.BasePopupMenu;
import net.sourceforge.squirrel_sql.fw.gui.IToggleAction;
import net.sourceforge.squirrel_sql.fw.gui.ToolBar;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.fw.util.Resources;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class AliasesListInternalFrame
extends BaseListInternalFrame {
    private static final String PREF_KEY_VIEW_ALIASES_AS_TREE = "Squirrel.viewAliasesAsTree";
    private static final long serialVersionUID = 1L;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AliasesListInternalFrame.class);
    private IApplication _app;
    private UserInterfaceFactory _uiFactory;

    public AliasesListInternalFrame(IApplication app, IAliasesList list) {
        super(new UserInterfaceFactory(app, list), app);
        this._app = app;
        this._uiFactory = (UserInterfaceFactory)this.getUserInterfaceFactory();
        this.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if ("closed".equals(evt.getPropertyName()) && Boolean.TRUE.equals(evt.getNewValue())) {
                    AliasesListInternalFrame.this.nowVisible(true);
                    throw new PropertyVetoException(s_stringMgr.getString("AliasesListInternalFrame.error.ctrlF4key"), evt);
                }
            }
        });
        this.addWidgetListener(new WidgetAdapter(){

            @Override
            public void widgetOpened(WidgetEvent evt) {
                AliasesListInternalFrame.this.nowVisible(true);
            }

            @Override
            public void widgetClosing(WidgetEvent evt) {
                AliasesListInternalFrame.this.nowVisible(false);
            }

            @Override
            public void widgetClosed(WidgetEvent evt) {
                AliasesListInternalFrame.this.nowVisible(false);
            }
        });
        this._app.getSquirrelPreferences().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propName;
                String string = propName = evt != null ? evt.getPropertyName() : null;
                if (propName == null || propName.equals("showAliasesToolBar")) {
                    boolean show = AliasesListInternalFrame.this._app.getSquirrelPreferences().getShowAliasesToolBar();
                    if (show) {
                        AliasesListInternalFrame.this._uiFactory.createToolBar();
                    } else {
                        AliasesListInternalFrame.this._uiFactory._tb = null;
                    }
                    AliasesListInternalFrame.this.setToolBar(AliasesListInternalFrame.this._uiFactory.getToolBar());
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AliasesListInternalFrame.this._uiFactory._aliasesList.requestFocus();
            }
        });
    }

    public IAliasesList getAliasesList() {
        return this._uiFactory._aliasesList;
    }

    public void nowVisible(final boolean b) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AliasesListInternalFrame.this._app.getMainFrame().setEnabledAliasesMenu(b);
                AliasesListInternalFrame.this._uiFactory._aliasesList.requestFocus();
            }
        });
    }

    public void enableDisableActions() {
        this._uiFactory.enableDisableActions();
    }

    public boolean isEmpty() {
        return this._uiFactory._aliasesList.isEmpty();
    }

    private static final class UserInterfaceFactory
    implements BaseListInternalFrame.IUserInterfaceFactory {
        private IApplication _app;
        private final IAliasesList _aliasesList;
        private ToolBar _tb;
        private BasePopupMenu _pm = new BasePopupMenu();

        UserInterfaceFactory(IApplication app, IAliasesList list) throws IllegalArgumentException {
            if (app == null) {
                throw new IllegalArgumentException("IApplication == null");
            }
            if (list == null) {
                throw new IllegalArgumentException("AliasesList == null");
            }
            this._app = app;
            this._aliasesList = list;
            if (this._app.getSquirrelPreferences().getShowAliasesToolBar()) {
                this.createToolBar();
            }
            final ActionCollection actions = this._app.getActionCollection();
            this._pm.add(actions.get(ConnectToAliasAction.class));
            this._pm.addSeparator();
            this._pm.add(actions.get(CreateAliasAction.class));
            this._pm.add(actions.get(ModifyAliasAction.class));
            this._pm.add(actions.get(CopyAliasAction.class));
            this._pm.add(actions.get(DeleteAliasAction.class));
            this._pm.addSeparator();
            this._pm.add(actions.get(AliasPropertiesAction.class));
            this._pm.addSeparator();
            this._pm.add(actions.get(SortAliasesAction.class));
            this._pm.addSeparator();
            this.addToMenuAsCheckBoxMenuItem(this._app.getResources(), actions.get(ToggleTreeViewAction.class), this._pm);
            this._pm.add(actions.get(NewAliasFolderAction.class));
            this._pm.add(actions.get(CopyToPasteAliasFolderAction.class));
            this._pm.add(actions.get(CutAliasFolderAction.class));
            this._pm.add(actions.get(PasteAliasFolderAction.class));
            this._pm.add(actions.get(CollapseAllAliasFolderAction.class));
            this._pm.add(actions.get(ExpandAllAliasFolderAction.class));
            app.addApplicationListener(new ApplicationListener(){

                @Override
                public void saveApplicationState() {
                    UserInterfaceFactory.this.onSaveApplicationState();
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ToggleTreeViewAction actViewAsTree = (ToggleTreeViewAction)actions.get(ToggleTreeViewAction.class);
                    actViewAsTree.getToggleComponentHolder().setSelected(Preferences.userRoot().getBoolean(AliasesListInternalFrame.PREF_KEY_VIEW_ALIASES_AS_TREE, false));
                    actViewAsTree.actionPerformed(new ActionEvent(this, 1, "actionPerformed"));
                    UserInterfaceFactory.this.enableDisableActions();
                }
            });
        }

        private void onSaveApplicationState() {
            IToggleAction actViewAsTree = (IToggleAction)this._app.getActionCollection().get(ToggleTreeViewAction.class);
            Preferences.userRoot().putBoolean(AliasesListInternalFrame.PREF_KEY_VIEW_ALIASES_AS_TREE, actViewAsTree.getToggleComponentHolder().isSelected());
        }

        private JCheckBoxMenuItem addToMenuAsCheckBoxMenuItem(Resources rsrc, Action action, JPopupMenu menu) {
            JCheckBoxMenuItem mnu = rsrc.addToMenuAsCheckBoxMenuItem(action, menu);
            if (action instanceof IToggleAction) {
                ((IToggleAction)action).getToggleComponentHolder().addToggleableComponent(mnu);
            }
            return mnu;
        }

        @Override
        public ToolBar getToolBar() {
            return this._tb;
        }

        @Override
        public BasePopupMenu getPopupMenu() {
            return this._pm;
        }

        @Override
        public IBaseList getList() {
            return this._aliasesList;
        }

        @Override
        public String getWindowTitle() {
            return s_stringMgr.getString("AliasesListInternalFrame.windowtitle");
        }

        @Override
        public ICommand getDoubleClickCommand(MouseEvent evt) {
            ConnectToAliasCommand cmd = null;
            SQLAlias alias = this._aliasesList.getSelectedAlias(evt);
            if (alias != null) {
                cmd = new ConnectToAliasCommand(this._app, alias);
            }
            return cmd;
        }

        public void enableDisableActions() {
            ActionCollection actions = this._app.getActionCollection();
            ToggleTreeViewAction actViewAsTree = (ToggleTreeViewAction)actions.get(ToggleTreeViewAction.class);
            boolean viewAsTree = actViewAsTree.getToggleComponentHolder().isSelected();
            actions.get(NewAliasFolderAction.class).setEnabled(viewAsTree);
            actions.get(CopyToPasteAliasFolderAction.class).setEnabled(viewAsTree);
            actions.get(CutAliasFolderAction.class).setEnabled(viewAsTree);
            actions.get(PasteAliasFolderAction.class).setEnabled(viewAsTree);
            actions.get(CollapseAllAliasFolderAction.class).setEnabled(viewAsTree);
            actions.get(ExpandAllAliasFolderAction.class).setEnabled(viewAsTree);
        }

        private void createToolBar() {
            this._tb = new ToolBar();
            this._tb.setUseRolloverButtons(true);
            this._tb.setFloatable(false);
            if (this._app.getDesktopStyle().isInternalFrameStyle()) {
                JLabel lbl = new JLabel(this.getWindowTitle(), 0);
                lbl.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
                this._tb.add((Component)lbl, 0);
            }
            ActionCollection actions = this._app.getActionCollection();
            this._tb.add(actions.get(ConnectToAliasAction.class));
            this._tb.addSeparator();
            this._tb.add(actions.get(CreateAliasAction.class));
            this._tb.add(actions.get(ModifyAliasAction.class));
            this._tb.add(actions.get(CopyAliasAction.class));
            this._tb.add(actions.get(DeleteAliasAction.class));
            this._tb.addSeparator();
            this._tb.add(actions.get(AliasPropertiesAction.class));
            this._tb.addSeparator();
            this._tb.add(actions.get(SortAliasesAction.class));
            this._tb.addSeparator();
            this._tb.addToggleAction((IToggleAction)actions.get(ToggleTreeViewAction.class));
            this._tb.add(actions.get(NewAliasFolderAction.class));
            this._tb.add(actions.get(CopyToPasteAliasFolderAction.class));
            this._tb.add(actions.get(CutAliasFolderAction.class));
            this._tb.add(actions.get(PasteAliasFolderAction.class));
            this._tb.add(actions.get(CollapseAllAliasFolderAction.class));
            this._tb.add(actions.get(ExpandAllAliasFolderAction.class));
        }

        @Override
        public SquirrelPreferences getPreferences() {
            return this._app.getSquirrelPreferences();
        }
    }
}

