/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.awt.BorderLayout;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.db.AliasesList;
import net.sourceforge.squirrel_sql.client.gui.db.AliasesListModel;
import net.sourceforge.squirrel_sql.client.gui.db.BaseList;
import net.sourceforge.squirrel_sql.client.gui.db.IAliasesList;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.fw.gui.Dialogs;
import net.sourceforge.squirrel_sql.fw.gui.ModifiedDefaultListCellRenderer;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class JListAliasesListImpl
extends BaseList
implements IAliasesList {
    private static final String PREF_KEY_SELECTED_ALIAS_INDEX = "Squirrel.selAliasIndex";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AliasesList.class);
    private IApplication _app;
    private final AliasesListModel _model;

    public JListAliasesListImpl(IApplication app, AliasesListModel aliasesListModel) {
        super(aliasesListModel, app);
        this._app = app;
        this._model = aliasesListModel;
        this.getList().setLayout(new BorderLayout());
        this.getList().setCellRenderer(new ModifiedDefaultListCellRenderer());
        this._model.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent evt) {
            }

            @Override
            public void intervalAdded(ListDataEvent evt) {
                final int idx = evt.getIndex0();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JListAliasesListImpl.this.getList().clearSelection();
                        JListAliasesListImpl.this.getList().setSelectedIndex(idx);
                    }
                });
            }

            @Override
            public void intervalRemoved(ListDataEvent evt) {
                final int idx = evt.getIndex0();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JListAliasesListImpl.this.getList().clearSelection();
                        int modelSize = JListAliasesListImpl.this.getList().getModel().getSize();
                        if (idx < modelSize) {
                            JListAliasesListImpl.this.getList().setSelectedIndex(idx);
                        } else if (modelSize > 0) {
                            JListAliasesListImpl.this.getList().setSelectedIndex(modelSize - 1);
                        }
                    }
                });
            }
        });
    }

    @Override
    public SQLAlias getSelectedAlias(MouseEvent evt) {
        return (SQLAlias)this.getList().getSelectedValue();
    }

    @Override
    public void sortAliases() {
        final SQLAlias selectedAlias = this.getSelectedAlias(null);
        this._model.sortAliases();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null != selectedAlias) {
                    JListAliasesListImpl.this.getList().setSelectedValue(selectedAlias, true);
                }
            }
        });
    }

    @Override
    public void requestFocus() {
        this.getList().requestFocus();
    }

    @Override
    public void deleteSelected() {
        SQLAlias toDel = (SQLAlias)this.getList().getSelectedValue();
        if (null != toDel && Dialogs.showYesNo(this._app.getMainFrame(), s_stringMgr.getString("JListAliasesListImpl.confirmDelete", toDel.getName()))) {
            this._model.remove(this.getList().getSelectedIndex());
            this._app.getDataCache().removeAlias(toDel);
        }
    }

    @Override
    public void modifySelected() {
        if (null != this.getList().getSelectedValue()) {
            this._app.getWindowManager().showModifyAliasInternalFrame((ISQLAlias)this.getList().getSelectedValue());
        }
    }

    @Override
    public boolean isEmpty() {
        return 0 == this._model.getSize();
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        int idx = this.getList().locationToIndex(evt.getPoint());
        String tip = idx != -1 ? ((ISQLAlias)this.getList().getModel().getElementAt(idx)).getName() : this.getToolTipText();
        return tip;
    }

    public String getToolTipText() {
        return s_stringMgr.getString("AliasesList.tooltip");
    }

    @Override
    public String getSelIndexPrefKey() {
        return PREF_KEY_SELECTED_ALIAS_INDEX;
    }
}

