/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JButton;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.TabWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.DockTabDesktopPane;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.TabHandleEvent;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.TabHandleListener;

public class TabHandle {
    private JButton _closeButton;
    private TabWidget _tabWidget;
    private DockTabDesktopPane _dockTabDesktopPane;
    private boolean _isSelected;
    private ArrayList<TabHandleListener> _tabHandleListeners = new ArrayList();
    private boolean _fireClosingProceedingOrDone;

    public TabHandle(TabWidget tabWidget, DockTabDesktopPane dockTabDesktopPane) {
        this._tabWidget = tabWidget;
        this._dockTabDesktopPane = dockTabDesktopPane;
    }

    public TabWidget getWidget() {
        return this._tabWidget;
    }

    public void addTabHandleListener(TabHandleListener l) {
        this._tabHandleListeners.add(l);
    }

    public void removeTabHandleListener(TabHandleListener l) {
        this._tabHandleListeners.remove(l);
    }

    public void fireClosing(ActionEvent e) {
        TabHandleListener[] clone;
        this._fireClosingProceedingOrDone = true;
        for (TabHandleListener listener : clone = this._tabHandleListeners.toArray(new TabHandleListener[this._tabHandleListeners.size()])) {
            listener.tabClosing(new TabHandleEvent(this, e));
        }
    }

    public void fireClosed(ActionEvent e) {
        TabHandleListener[] clone;
        for (TabHandleListener listener : clone = this._tabHandleListeners.toArray(new TabHandleListener[this._tabHandleListeners.size()])) {
            listener.tabClosed(new TabHandleEvent(this, e));
        }
    }

    public void fireAdded() {
        TabHandleListener[] clone;
        for (TabHandleListener listener : clone = this._tabHandleListeners.toArray(new TabHandleListener[this._tabHandleListeners.size()])) {
            listener.tabAdded(new TabHandleEvent(this, null));
        }
    }

    public void fireDeselected(ActionEvent e) {
        TabHandleListener[] clone;
        for (TabHandleListener listener : clone = this._tabHandleListeners.toArray(new TabHandleListener[this._tabHandleListeners.size()])) {
            listener.tabDeselected(new TabHandleEvent(this, null));
        }
    }

    public void fireSelected(ActionEvent e) {
        TabHandleListener[] clone;
        for (TabHandleListener listener : clone = this._tabHandleListeners.toArray(new TabHandleListener[this._tabHandleListeners.size()])) {
            listener.tabSelected(new TabHandleEvent(this, null));
        }
    }

    public boolean isSelected() {
        return this._isSelected;
    }

    public void setSelected(boolean b) {
        TabHandleListener[] clone;
        if (this._isSelected == b) {
            return;
        }
        this._isSelected = b;
        for (TabHandleListener listener : clone = this._tabHandleListeners.toArray(new TabHandleListener[this._tabHandleListeners.size()])) {
            if (this._isSelected) {
                listener.tabSelected(new TabHandleEvent(this, null));
                continue;
            }
            listener.tabDeselected(new TabHandleEvent(this, null));
        }
    }

    public void setTitle(String title) {
        this._dockTabDesktopPane.setTabTitle(this, title);
    }

    public String getTitle() {
        return this._dockTabDesktopPane.getTabTitle(this);
    }

    public void setIcon(Icon frameIcon) {
        this._dockTabDesktopPane.setTabIcon(this, frameIcon);
    }

    public void removeTab(DockTabDesktopPane.TabClosingMode tabClosingMode) {
        this._dockTabDesktopPane.removeTab(this, null, tabClosingMode);
    }

    public void select() {
        this._dockTabDesktopPane.selectTab(this);
    }

    public boolean isFireClosingProceedingOrDone() {
        return this._fireClosingProceedingOrDone;
    }
}

