/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class FileEditorDropTargetListener
extends DropTargetAdapter
implements DropTargetListener {
    private static final ILogger s_log = LoggerController.createLogger(FileEditorDropTargetListener.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(FileEditorDropTargetListener.class);
    private ISession _session;

    public FileEditorDropTargetListener(ISession session) {
        this._session = session;
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            DropTargetContext context = dtde.getDropTargetContext();
            dtde.acceptDrop(3);
            Transferable t = dtde.getTransferable();
            File fileToOpen = null;
            fileToOpen = t.isDataFlavorSupported(DataFlavor.javaFileListFlavor) ? this.handleJavaFileListFlavor(t) : (t.isDataFlavorSupported(DataFlavor.stringFlavor) ? this.handleStringFlavor(t) : this.handleUriListFlavor(t));
            if (fileToOpen != null) {
                if (s_log.isInfoEnabled()) {
                    s_log.info("drop: path=" + fileToOpen.getAbsolutePath());
                }
                ISQLPanelAPI api = this._session.getSQLPanelAPIOfActiveSessionWindow();
                api.fileOpen(fileToOpen);
            }
            context.dropComplete(true);
        }
        catch (Exception e) {
            s_log.error("drop: Unexpected exception " + e.getMessage(), e);
        }
    }

    private File handleUriListFlavor(Transferable transferable) throws ClassNotFoundException {
        DataFlavor uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
        File result = null;
        try {
            if (transferable.isDataFlavorSupported(uriListFlavor)) {
                String data = (String)transferable.getTransferData(uriListFlavor);
                List<File> fileList = this.textURIListToFileList(data);
                result = fileList.get(0);
            } else {
                s_log.error("handleUriListFlavor: no support for text/uri-list data flavor");
            }
        }
        catch (Exception e) {
            s_log.error("handleUriListFlavor: unexpected excption - " + e.getMessage(), e);
        }
        return result;
    }

    private File handleStringFlavor(Transferable t) throws UnsupportedFlavorException, IOException {
        File result = null;
        String transferData = (String)t.getTransferData(DataFlavor.stringFlavor);
        if (transferData != null) {
            if (transferData.startsWith("file://")) {
                try {
                    StringTokenizer st = new StringTokenizer(transferData);
                    if (st.countTokens() > 1) {
                        this._session.showErrorMessage(i18n.ONE_FILE_DROP_MESSAGE);
                    } else if (st.hasMoreTokens()) {
                        String fileUrlStr = st.nextToken();
                        URI uri = new URI(fileUrlStr);
                        result = new File(uri);
                    }
                }
                catch (URISyntaxException e) {
                    s_log.error("handleUriListString: encountered an invalid URI: " + transferData, e);
                }
            } else {
                result = new File(transferData);
            }
        }
        return result;
    }

    private File handleJavaFileListFlavor(Transferable t) throws UnsupportedFlavorException, IOException {
        File result = null;
        List transferData = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
        if (transferData == null || transferData.size() == 0) {
            s_log.error("Transferable.getTransferData returned a null/empty list");
            this._session.showErrorMessage(i18n.INTERNAL_ERROR_MESSAGE);
        } else if (transferData.size() > 1) {
            this._session.showErrorMessage(i18n.ONE_FILE_DROP_MESSAGE);
        } else {
            result = (File)transferData.get(0);
            if (s_log.isInfoEnabled()) {
                s_log.info("drop: path=" + result.getAbsolutePath());
            }
        }
        return result;
    }

    private List<File> textURIListToFileList(String data) {
        ArrayList<File> list = new ArrayList<File>(1);
        StringTokenizer st = new StringTokenizer(data, "\r\n");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.startsWith("#")) continue;
            try {
                URI uri = new URI(s);
                File file = new File(uri);
                list.add(file);
            }
            catch (URISyntaxException e) {
            }
            catch (IllegalArgumentException e) {}
        }
        return list;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private static interface i18n {
        public static final String ONE_FILE_DROP_MESSAGE = FileEditorDropTargetListener.access$000().getString("FileEditorDropTargetListener.oneFileDropMessage");
        public static final String INTERNAL_ERROR_MESSAGE = FileEditorDropTargetListener.access$000().getString("FileEditorDropTargetListener.internalErrorMessage");
    }
}

