/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.mainframe;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Version;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DesktopContainerFactory;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DockWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.IDesktopContainer;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.IWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.TabWidget;
import net.sourceforge.squirrel_sql.client.gui.mainframe.MainFrameMenuBar;
import net.sourceforge.squirrel_sql.client.gui.mainframe.MainFrameStatusBar;
import net.sourceforge.squirrel_sql.client.gui.mainframe.MainFrameToolBar;
import net.sourceforge.squirrel_sql.client.gui.mainframe.MainFrameWindowState;
import net.sourceforge.squirrel_sql.client.gui.mainframe.SplitPnResizeHandler;
import net.sourceforge.squirrel_sql.client.gui.mainframe.SquirrelDesktopManager;
import net.sourceforge.squirrel_sql.client.gui.mainframe.WidgetUtils;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.client.resources.SquirrelResources;
import net.sourceforge.squirrel_sql.client.session.MessagePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IMainFrame;
import net.sourceforge.squirrel_sql.fw.gui.Dialogs;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class MainFrame
extends JFrame
implements IMainFrame {
    private final ILogger s_log = LoggerController.createLogger(MainFrame.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MainFrame.class);
    private final IApplication _app;
    private MainFrameToolBar _toolBar;
    private MainFrameStatusBar _statusBar;
    private MessagePanel _msgPnl;
    private boolean _statusBarVisible = false;
    private IDesktopContainer _desktop;
    private JSplitPane _splitPn;
    private SplitPnResizeHandler _splitPnResizeHandler;

    public MainFrame(IApplication app) {
        super(Version.getVersion());
        if (app == null) {
            throw new IllegalArgumentException("Null IApplication passed");
        }
        this._app = app;
        this._desktop = DesktopContainerFactory.createDesktopContainer(this._app);
        this.createUserInterface();
        this.preferencesHaveChanged(null);
        this._app.getSquirrelPreferences().addPropertyChangeListener(new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MainFrame mainFrame = MainFrame.this;
                synchronized (mainFrame) {
                    MainFrame.this.preferencesHaveChanged(evt);
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IDesktopContainer comp = MainFrame.this.getDesktopContainer();
                comp.setPreferredSize(comp.getRequiredSize());
                comp.revalidate();
            }
        });
    }

    @Override
    public void dispose() {
        boolean shouldDispose = true;
        if (!this._app.shutdown(true)) {
            String msg = s_stringMgr.getString("MainFrame.errorOnClose");
            shouldDispose = Dialogs.showYesNo(this._app.getMainFrame(), msg);
        }
        if (shouldDispose) {
            this.closeAllToolWindows();
            super.dispose();
            System.exit(0);
        }
    }

    @Override
    public void pack() {
    }

    public IApplication getApplication() {
        return this._app;
    }

    public IDesktopContainer getDesktopContainer() {
        return this._desktop;
    }

    public void addWidget(DialogWidget widget) {
        this._desktop.addWidget(widget);
    }

    public void addWidget(DockWidget widget) {
        this._desktop.addWidget(widget);
    }

    public void addWidget(TabWidget widget) {
        this._desktop.addWidget(widget);
    }

    public JMenu getSessionMenu() {
        return ((MainFrameMenuBar)this.getJMenuBar()).getSessionMenu();
    }

    public void addToMenu(int menuId, JMenu menu) {
        if (menu == null) {
            throw new IllegalArgumentException("Null JMenu passed");
        }
        ((MainFrameMenuBar)this.getJMenuBar()).addToMenu(menuId, menu);
    }

    public void addToMenu(int menuId, Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Null BaseAction passed");
        }
        ((MainFrameMenuBar)this.getJMenuBar()).addToMenu(menuId, action);
    }

    public void addToStatusBar(JComponent comp) {
        if (comp == null) {
            throw new IllegalArgumentException("JComponent == null");
        }
        this._statusBar.addJComponent(comp);
    }

    public void removeFromStatusBar(JComponent comp) {
        if (comp == null) {
            throw new IllegalArgumentException("JComponent == null");
        }
        this._statusBar.remove(comp);
    }

    public MessagePanel getMessagePanel() {
        return this._msgPnl;
    }

    private void preferencesHaveChanged(PropertyChangeEvent evt) {
        boolean show;
        String propName = evt != null ? evt.getPropertyName() : null;
        SquirrelPreferences prefs = this._app.getSquirrelPreferences();
        if (propName == null || propName.equals("showContentsWhenDragging")) {
            if (prefs.getShowContentsWhenDragging()) {
                this.getDesktopContainer().putClientProperty("JDesktopPane.dragMode", null);
            } else {
                this.getDesktopContainer().putClientProperty("JDesktopPane.dragMode", "outline");
            }
        }
        if (propName == null || propName.equals("showMainStatusBar")) {
            show = prefs.getShowMainStatusBar();
            if (!show && this._statusBarVisible) {
                this.getContentPane().remove(this._statusBar);
                this._statusBarVisible = false;
            } else if (show && !this._statusBarVisible) {
                this.getContentPane().add((Component)this._statusBar, "South");
                this._statusBarVisible = true;
            }
        }
        if (propName == null || propName.equals("showMainToolBar")) {
            show = prefs.getShowMainToolBar();
            if (!show && this._toolBar != null) {
                this.getContentPane().remove(this._toolBar);
                this._toolBar = null;
            } else if (show && this._toolBar == null) {
                this._toolBar = new MainFrameToolBar(this._app);
                this.getContentPane().add((Component)this._toolBar, "North");
            }
        }
    }

    private void closeAllToolWindows() {
        IWidget[] frames = WidgetUtils.getOpenToolWindows(this.getDesktopContainer().getAllWidgets());
        for (int i = 0; i < frames.length; ++i) {
            frames[i].dispose();
        }
    }

    private void createUserInterface() {
        this.setVisible(false);
        this.setDefaultCloseOperation(0);
        SquirrelResources rsrc = this._app.getResources();
        this.getDesktopContainer().setDesktopManager(new SquirrelDesktopManager(this._app));
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        JScrollPane sp = new JScrollPane(this.getDesktopContainer().getComponent());
        sp.setBorder(BorderFactory.createEmptyBorder());
        this._msgPnl = new MessagePanel(){

            @Override
            public void setSize(int width, int height) {
                super.setSize(width, height);
                if (0 < width && 0 < height) {
                    MainFrame.this._splitPnResizeHandler.resizeSplitOnStartup();
                }
            }
        };
        this._msgPnl.setName(MessagePanel.class.toString());
        this._msgPnl.setEditable(false);
        this._splitPn = new JSplitPane(0);
        this._splitPn.add(sp);
        this._splitPn.add(new JScrollPane(this._msgPnl));
        this._splitPn.setResizeWeight(1.0);
        this._splitPn.setOneTouchExpandable(true);
        this._splitPnResizeHandler = new SplitPnResizeHandler(this._splitPn, this._msgPnl);
        content.add((Component)this._splitPn, "Center");
        this._statusBar = new MainFrameStatusBar(this._app);
        Font fn = this._app.getFontInfoStore().getStatusBarFontInfo().createFont();
        this._statusBar.setFont(fn);
        this.setJMenuBar(new MainFrameMenuBar(this._app, this.getDesktopContainer(), this._app.getActionCollection()));
        this.setupFromPreferences();
        ImageIcon icon = rsrc.getIcon("AppIcon");
        if (icon != null) {
            this.setIconImage(icon.getImage());
        } else {
            this.s_log.error("Missing icon for mainframe");
        }
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(18, 8, false), "repaint");
        this.validate();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MainFrame.this.dispose();
            }
        });
    }

    private void setupFromPreferences() {
        SquirrelPreferences prefs = this._app.getSquirrelPreferences();
        MainFrameWindowState ws = prefs.getMainFrameWindowState();
        this.setBounds(ws.getBounds().createRectangle());
        if (!GUIUtils.isWithinParent(this)) {
            this.setLocation(new Point(10, 10));
        }
        this.setExtendedState(ws.getFrameExtendedState());
    }

    public JMenu getWindowsMenu() {
        return ((MainFrameMenuBar)this.getJMenuBar()).getWindowsMenu();
    }

    public void setEnabledAliasesMenu(boolean b) {
        MainFrameMenuBar mainFrameMenuBar = (MainFrameMenuBar)this.getJMenuBar();
        mainFrameMenuBar.setEnabledAliasesMenu(b);
    }

    public void setEnabledDriversMenu(boolean b) {
        MainFrameMenuBar mainFrameMenuBar = (MainFrameMenuBar)this.getJMenuBar();
        mainFrameMenuBar.setEnabledDriversMenu(b);
    }

    public void addToToolBar(Action act) {
        this._toolBar.add(act);
    }

    public static interface IMenuIDs
    extends MainFrameMenuBar.IMenuIDs {
    }
}

