/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.session;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.squirrel_sql.client.gui.builders.UIFactory;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IMainPanelTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ObjectTreeTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreePanel;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class MainPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MainPanel.class);
    private static final ILogger s_log = LoggerController.createLogger(MainPanel.class);
    private transient ISession _session;
    private final JTabbedPane _tabPnl = UIFactory.getInstance().createTabbedPane();
    private transient PropertyChangeListener _propsListener;
    private transient ChangeListener _tabPnlListener;
    private List<IMainPanelTab> _tabs = new ArrayList<IMainPanelTab>();
    private static final String PREFS_KEY_SELECTED_TAB_IX = "squirrelSql_mainPanel_sel_tab_ix";

    MainPanel(ISession session) {
        super(new BorderLayout());
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        this._session = session;
        this.addMainPanelTab(new ObjectTreeTab(), 79);
        this.addMainPanelTab(new SQLTab(this._session), 81);
        this.add((Component)this._tabPnl, "Center");
        this.propertiesHaveChanged(null);
        this._tabs.get(this.getTabbedPane().getSelectedIndex()).select();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this._propsListener == null) {
            this._propsListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    MainPanel.this.propertiesHaveChanged(evt.getPropertyName());
                }
            };
            this._session.getProperties().addPropertyChangeListener(this._propsListener);
        }
        this._tabPnlListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MainPanel.this.performStateChanged();
            }
        };
        this._tabPnl.addChangeListener(this._tabPnlListener);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this._propsListener != null) {
            this._session.getProperties().removePropertyChangeListener(this._propsListener);
            this._propsListener = null;
        }
        if (this._tabPnlListener != null) {
            this._tabPnl.removeChangeListener(this._tabPnlListener);
            this._tabPnlListener = null;
        }
    }

    public int addMainPanelTab(IMainPanelTab tab) {
        return this.addMainPanelTab(tab, null);
    }

    public int addMainPanelTab(IMainPanelTab tab, Integer mnemonic) {
        int prefIx;
        if (tab == null) {
            throw new IllegalArgumentException("Null IMainPanelTab passed");
        }
        tab.setSession(this._session);
        int idx = this.getTabIndex(tab);
        if (idx != -1) {
            this._tabPnl.removeTabAt(idx);
            this._tabs.set(idx, tab);
        } else {
            idx = this._tabPnl.getTabCount();
            this._tabs.add(tab);
        }
        this._tabPnl.insertTab(tab.getTitle(), null, tab.getComponent(), tab.getHint(), idx);
        if (null != tab.getTabComponent()) {
            this._tabPnl.setTabComponentAt(idx, tab.getTabComponent());
        }
        if (idx == (prefIx = Preferences.userRoot().getInt(PREFS_KEY_SELECTED_TAB_IX, 0))) {
            this._tabPnl.setSelectedIndex(prefIx);
        }
        if (null != mnemonic) {
            this._tabPnl.setMnemonicAt(idx, mnemonic);
        }
        return idx;
    }

    public void insertMainPanelTab(IMainPanelTab tab, int idx, boolean selectInsertedTab) {
        if (tab == null) {
            throw new IllegalArgumentException("Null IMainPanelTab passed");
        }
        tab.setSession(this._session);
        int checkIdx = this.getTabIndex(tab);
        if (checkIdx != -1) {
            throw new IllegalArgumentException("A tab with the same title already exists at index " + checkIdx);
        }
        this._tabs.add(idx, tab);
        this._tabPnl.insertTab(tab.getTitle(), null, tab.getComponent(), tab.getHint(), idx);
        if (null != tab.getTabComponent()) {
            this._tabPnl.setTabComponentAt(idx, tab.getTabComponent());
        }
        if (selectInsertedTab) {
            this._tabPnl.setSelectedIndex(idx);
        }
    }

    private int getTabIndex(IMainPanelTab tab) {
        int checkIdx = null == tab.getTabComponent() ? this._tabPnl.indexOfTab(tab.getTitle()) : this._tabPnl.indexOfTabComponent(tab.getTabComponent());
        return checkIdx;
    }

    public int removeMainPanelTab(IMainPanelTab tab) {
        if (tab == null) {
            throw new IllegalArgumentException("Null IMainPanelTab passed");
        }
        int idx = this.getTabIndex(tab);
        if (idx == -1) {
            return idx;
        }
        this._tabs.remove(idx);
        this._tabPnl.removeTabAt(idx);
        return idx;
    }

    private void updateState() {
        this._session.getApplication().getActionCollection().activationChanged(this._session.getSessionInternalFrame());
    }

    void sessionClosing(ISession session) {
        Iterator<IMainPanelTab> it = this._tabs.iterator();
        while (it.hasNext()) {
            try {
                it.next().sessionClosing(session);
            }
            catch (Throwable th) {
                String msg = s_stringMgr.getString("MainPanel.error.sessionclose");
                this._session.getApplication().showErrorDialog(msg, th);
                s_log.error(msg, th);
            }
        }
    }

    public void sessionWindowClosing() {
        this.getSQLPanel().sessionWindowClosing();
        this.getObjectTreePanel().sessionWindowClosing();
        int selIx = this._tabPnl.getSelectedIndex();
        if (selIx == 0 || selIx == 1) {
            Preferences.userRoot().putInt(PREFS_KEY_SELECTED_TAB_IX, selIx);
        }
    }

    private void propertiesHaveChanged(String propertyName) {
        SessionProperties props = this._session.getProperties();
        if (propertyName == null || propertyName.equals("mainTabPlacement")) {
            this._tabPnl.setTabPlacement(props.getMainTabPlacement());
        }
    }

    private void performStateChanged() {
        this._tabPnl.requestFocusInWindow();
        this.updateState();
        int idx = this._tabPnl.getSelectedIndex();
        if (idx != -1) {
            this._tabs.get(idx).select();
        }
    }

    ObjectTreePanel getObjectTreePanel() {
        ObjectTreeTab tab = (ObjectTreeTab)this._tabs.get(0);
        return (ObjectTreePanel)tab.getComponent();
    }

    SQLPanel getSQLPanel() {
        return ((SQLTab)this._tabs.get(1)).getSQLPanel();
    }

    JTabbedPane getTabbedPane() {
        return this._tabPnl;
    }

    public static interface ITabIndexes {
        public static final int OBJECT_TREE_TAB = 0;
        public static final int SQL_TAB = 1;
    }
}

