/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.session;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.SessionTabWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetAdapter;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEvent;
import net.sourceforge.squirrel_sql.client.gui.session.RowColumnLabel;
import net.sourceforge.squirrel_sql.client.session.ISQLInternalFrame;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.ExecuteSqlAction;
import net.sourceforge.squirrel_sql.client.session.action.FileAppendAction;
import net.sourceforge.squirrel_sql.client.session.action.FileCloseAction;
import net.sourceforge.squirrel_sql.client.session.action.FileNewAction;
import net.sourceforge.squirrel_sql.client.session.action.FileOpenAction;
import net.sourceforge.squirrel_sql.client.session.action.FilePrintAction;
import net.sourceforge.squirrel_sql.client.session.action.FileSaveAction;
import net.sourceforge.squirrel_sql.client.session.action.FileSaveAsAction;
import net.sourceforge.squirrel_sql.client.session.action.NextSqlAction;
import net.sourceforge.squirrel_sql.client.session.action.PreviousSqlAction;
import net.sourceforge.squirrel_sql.client.session.action.SQLFilterAction;
import net.sourceforge.squirrel_sql.client.session.action.SelectSqlAction;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLPanel;
import net.sourceforge.squirrel_sql.fw.gui.StatusBar;
import net.sourceforge.squirrel_sql.fw.gui.ToolBar;

public class SQLInternalFrame
extends SessionTabWidget
implements ISQLInternalFrame {
    private final IApplication _app;
    private SQLPanel _sqlPanel;
    private SQLToolBar _toolBar;
    private StatusBar _statusBar = new StatusBar();

    public SQLInternalFrame(ISession session) {
        super(session.getTitle(), true, true, true, true, session);
        this._app = session.getApplication();
        this.setVisible(false);
        this.createGUI(session);
    }

    public SQLPanel getSQLPanel() {
        return this._sqlPanel;
    }

    @Override
    public ISQLPanelAPI getSQLPanelAPI() {
        return this._sqlPanel.getSQLPanelAPI();
    }

    private void createGUI(ISession session) {
        this.setVisible(false);
        IApplication app = session.getApplication();
        ImageIcon icon = app.getResources().getIcon(this.getClass(), "frameIcon");
        if (icon != null) {
            this.setFrameIcon(icon);
        }
        this.addWidgetListener(new WidgetAdapter(){

            @Override
            public void widgetActivated(WidgetEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SQLInternalFrame.this._sqlPanel.getSQLEntryPanel().getTextComponent().requestFocus();
                    }
                });
            }

            @Override
            public void widgetClosing(WidgetEvent e) {
                SQLInternalFrame.this._sqlPanel.sessionWindowClosing();
            }
        });
        this._sqlPanel = new SQLPanel(this.getSession(), false);
        this._sqlPanel.setVisible(true);
        this._toolBar = new SQLToolBar(this.getSession(), this._sqlPanel.getSQLPanelAPI());
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)this._toolBar, "North");
        contentPanel.add((Component)this._sqlPanel, "Center");
        Font fn = app.getFontInfoStore().getStatusBarFontInfo().createFont();
        this._statusBar.setFont(fn);
        contentPanel.add((Component)this._statusBar, "South");
        RowColumnLabel lblRowCol = new RowColumnLabel(this._sqlPanel.getSQLEntryPanel());
        this._statusBar.addJComponent(lblRowCol);
        this.setContentPane(contentPanel);
        this.validate();
    }

    public void requestFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SQLInternalFrame.this._sqlPanel.getSQLEntryPanel().requestFocus();
            }
        });
    }

    public void addSeparatorToToolbar() {
        if (null != this._toolBar) {
            this._toolBar.addSeparator();
        }
    }

    public void addToToolbar(Action action) {
        if (null != this._toolBar) {
            this._toolBar.add(action);
        }
    }

    public void addToToolsPopUp(String selectionString, Action action) {
        this.getSQLPanelAPI().addToToolsPopUp(selectionString, action);
    }

    @Override
    public boolean hasSQLPanelAPI() {
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void moveToFront() {
        super.moveToFront();
        this._sqlPanel.getSQLEntryPanel().requestFocus();
    }

    private class SQLToolBar
    extends ToolBar {
        SQLToolBar(ISession session, ISQLPanelAPI panel) {
            this.createGUI(session, panel);
        }

        private void createGUI(ISession session, ISQLPanelAPI panel) {
            ActionCollection actions = session.getApplication().getActionCollection();
            this.setUseRolloverButtons(true);
            this.setFloatable(false);
            this.add(actions.get(ExecuteSqlAction.class));
            this.addSeparator();
            this.add(actions.get(FileNewAction.class));
            this.add(actions.get(FileOpenAction.class));
            this.add(actions.get(FileAppendAction.class));
            this.add(actions.get(FileSaveAction.class));
            this.add(actions.get(FileSaveAsAction.class));
            this.add(actions.get(FilePrintAction.class));
            this.add(actions.get(FileCloseAction.class));
            this.addSeparator();
            this.add(actions.get(PreviousSqlAction.class));
            this.add(actions.get(NextSqlAction.class));
            this.add(actions.get(SelectSqlAction.class));
            this.addSeparator();
            this.add(actions.get(SQLFilterAction.class));
            actions.get(SQLFilterAction.class).setEnabled(true);
        }
    }
}

