/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.mainframe.action;

import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverManager;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverPropertyCollection;
import net.sourceforge.squirrel_sql.fw.sql.WrappedSQLException;
import net.sourceforge.squirrel_sql.fw.util.BaseException;
import net.sourceforge.squirrel_sql.fw.util.ICommand;

public class OpenConnectionCommand
implements ICommand {
    private IApplication _app;
    private ISQLAlias _sqlAlias;
    private final String _userName;
    private final String _password;
    private final SQLDriverPropertyCollection _props;
    private SQLConnection _conn;

    public OpenConnectionCommand(IApplication app, ISQLAlias sqlAlias, String userName, String password, SQLDriverPropertyCollection props) {
        if (app == null) {
            throw new IllegalArgumentException("Null IApplication passed");
        }
        if (sqlAlias == null) {
            throw new IllegalArgumentException("Null ISQLAlias passed");
        }
        this._app = app;
        this._sqlAlias = sqlAlias;
        this._userName = userName;
        this._password = password;
        this._props = props;
    }

    @Override
    public void execute() throws BaseException {
        this._conn = null;
        IIdentifier driverID = this._sqlAlias.getDriverIdentifier();
        ISQLDriver sqlDriver = this._app.getDataCache().getDriver(driverID);
        SQLDriverManager mgr = this._app.getSQLDriverManager();
        try {
            this._conn = mgr.getConnection(sqlDriver, this._sqlAlias, this._userName, this._password, this._props);
        }
        catch (SQLException ex) {
            throw new WrappedSQLException(ex);
        }
        catch (Throwable th) {
            throw new BaseException(th);
        }
    }

    public SQLConnection getSQLConnection() {
        return this._conn;
    }
}

