/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.plugin;

import java.io.File;
import java.io.IOException;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Version;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.db.aliasproperties.IAliasPropertiesPanelController;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.preferences.IGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.client.preferences.INewSessionPropertiesPanel;
import net.sourceforge.squirrel_sql.client.util.ApplicationFileWrappers;
import net.sourceforge.squirrel_sql.client.util.ApplicationFileWrappersImpl;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactory;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactoryImpl;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public abstract class DefaultPlugin
implements IPlugin {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DefaultPlugin.class);
    protected IApplication _app;
    protected ApplicationFileWrappers applicationFiles = new ApplicationFileWrappersImpl();
    protected FileWrapperFactory fileWrapperFactory = new FileWrapperFactoryImpl();

    @Override
    public void load(IApplication app) throws PluginException {
        if (app == null) {
            throw new IllegalArgumentException("Null IApplication passed");
        }
        this._app = app;
    }

    @Override
    public void initialize() throws PluginException {
    }

    @Override
    public void unload() {
    }

    @Override
    public String getContributors() {
        return "";
    }

    @Override
    public String getWebSite() {
        return Version.getWebSite();
    }

    @Override
    public String getHelpFileName() {
        return null;
    }

    @Override
    public String getChangeLogFileName() {
        return null;
    }

    @Override
    public String getLicenceFileName() {
        return null;
    }

    public IApplication getApplication() {
        return this._app;
    }

    @Override
    public synchronized FileWrapper getPluginAppSettingsFolder() throws IllegalStateException, IOException {
        String pluginAppFolderProp = System.getProperty("pluginAppFolder");
        if (pluginAppFolderProp != null) {
            return this.fileWrapperFactory.create(pluginAppFolderProp);
        }
        String internalName = this.getInternalName();
        if (internalName == null || internalName.trim().length() == 0) {
            throw new IllegalStateException("IPlugin doesn't have a valid internal name");
        }
        FileWrapper pluginDir = this.applicationFiles.getPluginsDirectory();
        FileWrapper file = this.fileWrapperFactory.create(pluginDir, internalName);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.isDirectory()) {
            throw new IOException(s_stringMgr.getString("DefaultPlugin.error.cannotcreate", file.getAbsolutePath()));
        }
        return file;
    }

    @Override
    public synchronized String getPluginJarFilePath() throws IllegalStateException {
        String internalName = this.getInternalName();
        FileWrapper pluginDir = this.applicationFiles.getPluginsDirectory();
        if (internalName == null || internalName.trim().length() == 0) {
            throw new IllegalStateException("IPlugin doesn't have a valid internal name");
        }
        FileWrapper resultFile = this.fileWrapperFactory.create(pluginDir, internalName + ".jar");
        return resultFile.getAbsolutePath();
    }

    @Override
    public synchronized FileWrapper getPluginUserSettingsFolder() throws IllegalStateException, IOException {
        String internalName = this.getInternalName();
        if (internalName == null || internalName.trim().length() == 0) {
            throw new IllegalStateException("IPlugin doesn't have a valid internal name");
        }
        String name = new ApplicationFiles().getPluginsUserSettingsDirectory() + File.separator + internalName + File.separator;
        FileWrapper file = this.fileWrapperFactory.create(name);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.isDirectory()) {
            throw new IOException(s_stringMgr.getString("DefaultPlugin.error.cannotcreate", name));
        }
        return file;
    }

    @Override
    public IGlobalPreferencesPanel[] getGlobalPreferencePanels() {
        return null;
    }

    @Override
    public IAliasPropertiesPanelController[] getAliasPropertiesPanelControllers(SQLAlias alias) {
        return null;
    }

    @Override
    public void aliasCopied(SQLAlias source, SQLAlias target) {
    }

    @Override
    public void aliasRemoved(SQLAlias alias) {
    }

    @Override
    public INewSessionPropertiesPanel[] getNewSessionPropertiesPanels() {
        return null;
    }

    @Override
    public Object getExternalService() {
        return null;
    }

    @Override
    public void setApplicationFiles(ApplicationFileWrappers applicationFiles) {
        Utilities.checkNull("setApplicationFiles", "applicationFiles", applicationFiles);
        this.applicationFiles = applicationFiles;
    }

    @Override
    public void setFileWrapperFactory(FileWrapperFactory fileWrapperFactory) {
        Utilities.checkNull("setFileWrapperFactory", "fileWrapperFactory", fileWrapperFactory);
        this.fileWrapperFactory = fileWrapperFactory;
    }
}

