/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import java.sql.Statement;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class CancelStatementThread
extends Thread {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CancelStatementThread.class);
    private static final ILogger s_log = LoggerController.createLogger(CancelStatementThread.class);
    private Statement _stmt;
    private IMessageHandler _messageHandler;
    private boolean _threadFinished;
    private boolean _joinReturned;

    public CancelStatementThread(Statement stmt, IMessageHandler messageHandler) {
        this._stmt = stmt;
        this._messageHandler = messageHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryCancel() {
        try {
            this.start();
            this.join(1500L);
            CancelStatementThread cancelStatementThread = this;
            synchronized (cancelStatementThread) {
                this._joinReturned = true;
                if (!this._threadFinished) {
                    String msg = s_stringMgr.getString("CancelStatementThread.cancelTimedOut");
                    this._messageHandler.showErrorMessage(msg);
                    s_log.error(msg);
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String msg;
        boolean cancelSucceeded = false;
        boolean closeSucceeded = false;
        try {
            if (this._stmt != null) {
                this._stmt.cancel();
            }
            cancelSucceeded = true;
        }
        catch (Throwable t) {
            msg = s_stringMgr.getString("CancelStatementThread.cancelFailed", t);
            this._messageHandler.showErrorMessage(msg);
            s_log.error(msg, t);
        }
        try {
            Utilities.sleep(500L);
            if (this._stmt != null) {
                this._stmt.close();
            }
            closeSucceeded = true;
        }
        catch (Throwable t) {
            msg = s_stringMgr.getString("CancelStatementThread.closeFailed", t);
            this._messageHandler.showErrorMessage(msg);
            s_log.error(msg, t);
        }
        CancelStatementThread cancelStatementThread = this;
        synchronized (cancelStatementThread) {
            if (cancelSucceeded && closeSucceeded) {
                if (this._joinReturned) {
                    msg = s_stringMgr.getString("CancelStatementThread.cancelSucceededLate");
                    this._messageHandler.showMessage(msg);
                } else {
                    msg = s_stringMgr.getString("CancelStatementThread.cancelSucceeded");
                    this._messageHandler.showMessage(msg);
                }
            }
            this._threadFinished = true;
        }
    }
}

