/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.squirrel_sql.client.session.SQLExecutionInfo;

public class EditableSqlCheck {
    private static final int ALLOWS_EDITING_FALSE = 0;
    private static final int ALLOWS_EDITING_TRUE = 1;
    private static final int ALLOWS_EDITING_UNKNOWN = 2;
    private String _tableNameFromSQL = null;

    public EditableSqlCheck(SQLExecutionInfo exInfo) {
        if (null == exInfo || null == exInfo.getSQL()) {
            return;
        }
        this._tableNameFromSQL = this.getTableFromSQLIntern(exInfo.getSQL());
    }

    private String getTableFromSQLIntern(String sql) {
        Pattern patternBeforeTable = Pattern.compile("SELECT\\s+[A-Z0-9_\\*\\.',\\s]*\\s+FROM\\s+([A-Z0-9_\\.]+)");
        sql = sql.toUpperCase().trim();
        Matcher matcher = patternBeforeTable.matcher(sql = sql.replaceAll("\\`", ""));
        if (!matcher.find()) {
            return null;
        }
        String table = matcher.group(1);
        String behindTable = sql.substring(matcher.end(1)).trim();
        int ret = this.behindTableAllowsEditing(behindTable);
        if (2 == ret) {
            Pattern patternBehindTable = behindTable.startsWith("AS") && 2 < behindTable.length() && Character.isWhitespace(behindTable.charAt(2)) ? Pattern.compile("AS\\s+([A-Z0-9_]+)\\s+") : Pattern.compile("([A-Z0-9_]+)\\s+|[A-Z0-9_]+$");
            matcher = patternBehindTable.matcher(behindTable);
            if (!matcher.find()) {
                return null;
            }
            String alias = matcher.group(0);
            String behindAlias = behindTable.substring(matcher.end(0)).trim();
            ret = this.behindTableAllowsEditing(behindAlias);
            if (1 == ret) {
                return table;
            }
            return null;
        }
        if (1 == ret) {
            return table;
        }
        return null;
    }

    private int behindTableAllowsEditing(String behindTable) {
        if (0 == behindTable.length()) {
            return 1;
        }
        if (behindTable.startsWith("WHERE") || behindTable.startsWith("ORDER") || behindTable.startsWith("GROUP")) {
            return 1;
        }
        if (behindTable.startsWith(",") || behindTable.startsWith("INNER") || behindTable.startsWith("LEFT") || behindTable.startsWith("RIGHT") || behindTable.startsWith("OUTER") || behindTable.startsWith(",")) {
            return 0;
        }
        return 2;
    }

    public boolean allowsEditing() {
        return null != this._tableNameFromSQL;
    }

    public String getTableNameFromSQL() {
        return this._tableNameFromSQL;
    }
}

