/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import java.util.ArrayList;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SessionInternalFrame;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.schemainfo.FilterMatcher;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ObjectTreeSearch {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ObjectTreeSearch.class);

    public synchronized void viewObjectInObjectTree(String objectName, ISession session) {
        ObjectCandidates candidates = this.getObjectCandidates(objectName);
        if (candidates.size() == 0) {
            return;
        }
        if (!(session.getActiveSessionWindow() instanceof SessionInternalFrame) && !(session.getActiveSessionWindow() instanceof ObjectTreeInternalFrame)) {
            return;
        }
        IObjectTreeAPI objectTree = session.getObjectTreeAPIOfActiveSessionWindow();
        boolean success = false;
        while (candidates.hasNext()) {
            ArrayList<String> catSchemObj = candidates.next();
            success = objectTree.selectInObjectTree(catSchemObj.get(0), catSchemObj.get(1), new FilterMatcher(catSchemObj.get(2), null));
            if (!success) continue;
            session.selectMainTab(0);
            break;
        }
        if (!success) {
            String msg = s_stringMgr.getString("ObjectTreeSearch.error.objectnotfound", candidates.getSearchString());
            JOptionPane.showMessageDialog(session.getApplication().getMainFrame(), msg);
        }
    }

    private ObjectCandidates getObjectCandidates(String objectName) {
        ObjectCandidates ret = new ObjectCandidates(objectName);
        String[] splits = objectName.split("\\.");
        for (int i = splits.length - 1; i >= 0; --i) {
            String object = null;
            String schema = null;
            String catalog = null;
            object = this.removeQuotes(splits[i]);
            if (i + 1 < splits.length) {
                schema = splits[i + 1];
            }
            if (i + 2 < splits.length) {
                catalog = splits[i + 2];
            }
            if (catalog == null && schema == null && "".equals(object)) continue;
            ret.add(catalog, schema, object);
        }
        return ret;
    }

    private String removeQuotes(String objectName) {
        String ret = objectName.trim();
        while (ret.startsWith("\"") || ret.startsWith("/")) {
            ret = ret.substring(1);
        }
        while (ret.endsWith("\"") || ret.endsWith("/")) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    private static class ObjectCandidates {
        ArrayList<ArrayList<String>> _candidates = new ArrayList();
        int _curIndex = 0;
        private String _searchString;

        public ObjectCandidates(String searchString) {
            this._searchString = searchString;
        }

        public boolean hasNext() {
            return this._curIndex < this._candidates.size();
        }

        public ArrayList<String> next() {
            return this._candidates.get(this._curIndex++);
        }

        public String getSearchString() {
            return this._searchString;
        }

        public void add(String catalog, String schema, String object) {
            ArrayList<String> candidate = new ArrayList<String>(3);
            candidate.add(catalog);
            candidate.add(schema);
            candidate.add(object);
            this._candidates.add(candidate);
        }

        public int size() {
            return this._candidates.size();
        }
    }
}

