/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import java.util.Calendar;
import java.util.Date;

public class SQLExecutionInfo {
    private int _idx;
    private Date _sqlExecutionStart;
    private Date _resultsProcessingStart;
    private Date _resultsProcessingEnd;
    private String _sql;
    private final int _maxRows;
    private Integer _numberResultRowsRead;

    public SQLExecutionInfo(int idx, String sql, int maxRows) {
        if (sql == null) {
            throw new IllegalArgumentException("SQL script == null");
        }
        this._idx = idx;
        this._sql = sql;
        this._maxRows = maxRows;
        this._sqlExecutionStart = Calendar.getInstance().getTime();
    }

    public void sqlExecutionComplete() {
        this._resultsProcessingStart = Calendar.getInstance().getTime();
    }

    public void resultsProcessingComplete() {
        this._resultsProcessingEnd = Calendar.getInstance().getTime();
    }

    public int getQueryIndex() {
        return this._idx;
    }

    public String getSQL() {
        return this._sql;
    }

    public Date getSQLExecutionStartTime() {
        return this._sqlExecutionStart;
    }

    public void setSQLExecutionStartTime(Date value) {
        if (value == null) {
            throw new IllegalArgumentException("SQL Execution start time == null");
        }
        this._sqlExecutionStart = value;
    }

    public long getSQLExecutionElapsedMillis() {
        long results = 0L;
        if (this._resultsProcessingStart != null) {
            results = this._resultsProcessingStart.getTime() - this._sqlExecutionStart.getTime();
        }
        return results;
    }

    public long getResultsProcessingElapsedMillis() {
        long results = 0L;
        if (this._resultsProcessingEnd != null && this._resultsProcessingStart != null) {
            results = this._resultsProcessingEnd.getTime() - this._resultsProcessingStart.getTime();
        }
        return results;
    }

    public long getTotalElapsedMillis() {
        return this.getSQLExecutionElapsedMillis() + this.getResultsProcessingElapsedMillis();
    }

    public int getMaxRows() {
        return this._maxRows;
    }

    public void setNumberResultRowsRead(int numberResultRowsRead) {
        this._numberResultRowsRead = numberResultRowsRead;
    }

    public Integer getNumberResultRowsRead() {
        return this._numberResultRowsRead;
    }
}

