/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import java.io.File;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.SessionTabWidget;
import net.sourceforge.squirrel_sql.client.gui.mainframe.MainFrame;
import net.sourceforge.squirrel_sql.client.gui.session.ToolsPopupController;
import net.sourceforge.squirrel_sql.client.preferences.PreferenceType;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.client.resources.SquirrelResources;
import net.sourceforge.squirrel_sql.client.session.FileManager;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.CloseAllSQLResultTabsAction;
import net.sourceforge.squirrel_sql.client.session.action.CloseAllSQLResultTabsButCurrentAction;
import net.sourceforge.squirrel_sql.client.session.action.CloseCurrentSQLResultTabAction;
import net.sourceforge.squirrel_sql.client.session.action.ExecuteSqlAction;
import net.sourceforge.squirrel_sql.client.session.action.FileAppendAction;
import net.sourceforge.squirrel_sql.client.session.action.FileCloseAction;
import net.sourceforge.squirrel_sql.client.session.action.FileNewAction;
import net.sourceforge.squirrel_sql.client.session.action.FileOpenAction;
import net.sourceforge.squirrel_sql.client.session.action.FilePrintAction;
import net.sourceforge.squirrel_sql.client.session.action.FileSaveAction;
import net.sourceforge.squirrel_sql.client.session.action.FileSaveAsAction;
import net.sourceforge.squirrel_sql.client.session.action.GotoNextResultsTabAction;
import net.sourceforge.squirrel_sql.client.session.action.GotoPreviousResultsTabAction;
import net.sourceforge.squirrel_sql.client.session.action.NextSqlAction;
import net.sourceforge.squirrel_sql.client.session.action.OpenSqlHistoryAction;
import net.sourceforge.squirrel_sql.client.session.action.PreviousSqlAction;
import net.sourceforge.squirrel_sql.client.session.action.SelectSqlAction;
import net.sourceforge.squirrel_sql.client.session.action.ToggleCurrentSQLResultTabStickyAction;
import net.sourceforge.squirrel_sql.client.session.action.ToolsPopupAction;
import net.sourceforge.squirrel_sql.client.session.action.ViewObjectAtCursorInObjectTreeAction;
import net.sourceforge.squirrel_sql.client.session.event.ISQLExecutionListener;
import net.sourceforge.squirrel_sql.client.session.event.ISQLPanelListener;
import net.sourceforge.squirrel_sql.client.session.event.ISQLResultExecuterTabListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ISQLResultExecuter;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLHistoryItem;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SqlPanelListener;
import net.sourceforge.squirrel_sql.client.util.PrintUtilities;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class SQLPanelAPI
implements ISQLPanelAPI {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLPanelAPI.class);
    private SQLPanel _panel;
    private ToolsPopupController _toolsPopupController;
    private FileManager _fileManager = new FileManager(this);
    private boolean fileOpened = false;
    private boolean fileSaved = false;
    private boolean unsavedEdits = false;

    public SQLPanelAPI(SQLPanel panel) {
        if (panel == null) {
            throw new IllegalArgumentException("SQLPanel == null");
        }
        this._panel = panel;
        this._panel.getSQLEntryPanel().addUndoableEditListener(new SQLEntryUndoListener());
        this.initToolsPopUp();
        this.createStandardEntryAreaMenuItems();
    }

    private void initToolsPopUp() {
        this._toolsPopupController = new ToolsPopupController(this.getSession(), this._panel.getSQLEntryPanel());
        ActionCollection ac = this.getSession().getApplication().getActionCollection();
        this._toolsPopupController.addAction("undo", this._panel.getUndoAction());
        this._toolsPopupController.addAction("redo", this._panel.getRedoAction());
        this._toolsPopupController.addAction("runsql", ac.get(ExecuteSqlAction.class));
        this._toolsPopupController.addAction("fileopen", ac.get(FileOpenAction.class));
        this._toolsPopupController.addAction("filesave", ac.get(FileSaveAction.class));
        this._toolsPopupController.addAction("filesaveas", ac.get(FileSaveAsAction.class));
        this._toolsPopupController.addAction("filenew", ac.get(FileNewAction.class));
        this._toolsPopupController.addAction("fileappend", ac.get(FileAppendAction.class));
        this._toolsPopupController.addAction("fileprint", ac.get(FilePrintAction.class));
        this._toolsPopupController.addAction("fileclose", ac.get(FileCloseAction.class));
        this._toolsPopupController.addAction("tabnext", ac.get(GotoNextResultsTabAction.class));
        this._toolsPopupController.addAction("tabprevious", ac.get(GotoPreviousResultsTabAction.class));
        this._toolsPopupController.addAction("tabcloseall", ac.get(CloseAllSQLResultTabsAction.class));
        this._toolsPopupController.addAction("tabcloseallbutcur", ac.get(CloseAllSQLResultTabsButCurrentAction.class));
        this._toolsPopupController.addAction("tabclosecur", ac.get(CloseCurrentSQLResultTabAction.class));
        this._toolsPopupController.addAction("tabsticky", ac.get(ToggleCurrentSQLResultTabStickyAction.class));
        this._toolsPopupController.addAction("sqlprevious", ac.get(PreviousSqlAction.class));
        this._toolsPopupController.addAction("sqlnext", ac.get(NextSqlAction.class));
        this._toolsPopupController.addAction("sqlselect", ac.get(SelectSqlAction.class));
        this._toolsPopupController.addAction("sqlhist", ac.get(OpenSqlHistoryAction.class));
        if (this._panel.isInMainSessionWindow()) {
            this._toolsPopupController.addAction("viewinobjecttree", ac.get(ViewObjectAtCursorInObjectTreeAction.class));
        }
    }

    private void createStandardEntryAreaMenuItems() {
        SquirrelResources resources = this.getSession().getApplication().getResources();
        Action toolsPopupAction = this._panel.getSession().getApplication().getActionCollection().get(ToolsPopupAction.class);
        JMenuItem item = this.getSQLEntryPanel().addToSQLEntryAreaMenu(toolsPopupAction);
        resources.configureMenuItem(toolsPopupAction, item);
        if (this._panel.isInMainSessionWindow()) {
            Action vioAction = this._panel.getSession().getApplication().getActionCollection().get(ViewObjectAtCursorInObjectTreeAction.class);
            item = this.getSQLEntryPanel().addToSQLEntryAreaMenu(vioAction);
            resources.configureMenuItem(vioAction, item);
        }
    }

    @Override
    public void addToToolsPopUp(String selectionString, Action action) {
        this._toolsPopupController.addAction(selectionString, action);
    }

    @Override
    public boolean fileSave() {
        if (this._fileManager.save()) {
            this.fileSaved = true;
            this.unsavedEdits = false;
            this.getActiveSessionTabWidget().setUnsavedEdits(false);
            ActionCollection actions = this.getSession().getApplication().getActionCollection();
            actions.enableAction(FileSaveAction.class, false);
            return true;
        }
        return false;
    }

    private SessionTabWidget getActiveSessionTabWidget() {
        return (SessionTabWidget)this.getSession().getActiveSessionWindow();
    }

    @Override
    public void fileAppend() {
        if (this._fileManager.open(true)) {
            this.fileOpened = true;
            this.fileSaved = false;
            this.unsavedEdits = false;
            ActionCollection actions = this.getSession().getApplication().getActionCollection();
            actions.enableAction(FileSaveAction.class, true);
        }
    }

    @Override
    public void fileClose() {
        if (this.unsavedEdits) {
            this.showConfirmSaveDialog();
        }
        this.setEntireSQLScript("");
        this.getActiveSessionTabWidget().setSqlFile(null);
        this.fileOpened = false;
        this.fileSaved = false;
        this.unsavedEdits = false;
        ActionCollection actions = this.getSession().getApplication().getActionCollection();
        actions.enableAction(FileSaveAction.class, true);
        this._fileManager.clearCurrentFile();
    }

    @Override
    public void fileNew() {
        this.fileClose();
    }

    @Override
    public void fileSaveAs() {
        if (this._fileManager.saveAs()) {
            this.fileSaved = true;
            this.unsavedEdits = false;
            this.getActiveSessionTabWidget().setUnsavedEdits(false);
            ActionCollection actions = this.getSession().getApplication().getActionCollection();
            actions.enableAction(FileSaveAction.class, false);
        }
    }

    @Override
    public void fileOpen() {
        if (this.unsavedEdits) {
            this.showConfirmSaveDialog();
        }
        if (this._fileManager.open(false)) {
            this.fileOpened = true;
            this.fileSaved = false;
            this.unsavedEdits = false;
            ActionCollection actions = this.getSession().getApplication().getActionCollection();
            actions.enableAction(FileSaveAction.class, false);
        }
    }

    @Override
    public void fileOpen(File f) {
        if (this.unsavedEdits) {
            this.showConfirmSaveDialog();
        }
        if (this._fileManager.open(f)) {
            this.fileOpened = true;
            this.fileSaved = false;
            this.unsavedEdits = false;
            ActionCollection actions = this.getSession().getApplication().getActionCollection();
            actions.enableAction(FileSaveAction.class, false);
        }
    }

    @Override
    public void filePrint() {
        if (this._panel == null) {
            throw new IllegalStateException("_panel is null");
        }
        ISQLEntryPanel panel = this._panel.getSQLEntryPanel();
        if (panel == null) {
            throw new IllegalStateException("_panel.getSQLEntryPanel() is null");
        }
        PrintUtilities.printComponent(panel.getTextComponent());
    }

    @Override
    public void showToolsPopup() {
        this._toolsPopupController.showToolsPopup();
    }

    @Override
    public void addExecutor(ISQLResultExecuter exec) {
        this._panel.addExecutor(exec);
    }

    @Override
    public void removeExecutor(ISQLResultExecuter exec) {
        this._panel.removeExecutor(exec);
    }

    @Override
    public synchronized void addSQLExecutionListener(ISQLExecutionListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("null ISQLExecutionListener passed");
        }
        this._panel.addSQLExecutionListener(lis);
    }

    @Override
    public synchronized void removeSQLExecutionListener(ISQLExecutionListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("null ISQLExecutionListener passed");
        }
        this._panel.removeSQLExecutionListener(lis);
    }

    @Override
    public void addExecuterTabListener(ISQLResultExecuterTabListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("ISQLResultExecuterTabListener == null");
        }
        this._panel.addExecuterTabListener(lis);
    }

    @Override
    public void removeExecuterTabListener(ISQLResultExecuterTabListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("ISQLResultExecuterTabListener == null");
        }
        this._panel.removeExecuterTabListener(lis);
    }

    @Override
    public synchronized void addSQLPanelListener(ISQLPanelListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("ISQLPanelListener == null");
        }
        this._panel.addSQLPanelListener(lis);
    }

    @Override
    public synchronized void removeSQLPanelListener(ISQLPanelListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("ISQLPanelListener == null");
        }
        this._panel.removeSQLPanelListener(lis);
    }

    @Override
    public ISQLEntryPanel getSQLEntryPanel() {
        return this._panel.getSQLEntryPanel();
    }

    @Override
    public ISQLResultExecuter getSQLResultExecuter() {
        return this._panel.getSQLExecPanel();
    }

    @Override
    public synchronized String getEntireSQLScript() {
        return this._panel.getSQLEntryPanel().getText();
    }

    @Override
    public String getSelectedSQLScript() {
        return this._panel.getSQLEntryPanel().getSelectedText();
    }

    @Override
    public synchronized String getSQLScriptToBeExecuted() {
        return this._panel.getSQLEntryPanel().getSQLToBeExecuted();
    }

    @Override
    public synchronized void appendSQLScript(String sqlScript) {
        this._panel.getSQLEntryPanel().appendText(sqlScript);
    }

    @Override
    public synchronized void appendSQLScript(String sqlScript, boolean select) {
        this._panel.getSQLEntryPanel().appendText(sqlScript, select);
    }

    @Override
    public synchronized void setEntireSQLScript(String sqlScript) {
        this._panel.getSQLEntryPanel().setText(sqlScript);
    }

    @Override
    public synchronized void setEntireSQLScript(String sqlScript, boolean select) {
        this._panel.getSQLEntryPanel().setText(sqlScript, select);
    }

    @Override
    public synchronized void replaceSelectedSQLScript(String sqlScript, boolean select) {
        if (sqlScript == null) {
            sqlScript = "";
        }
        ISQLEntryPanel pnl = this._panel.getSQLEntryPanel();
        int selStart = -1;
        if (select) {
            selStart = pnl.getSelectionStart();
        }
        pnl.replaceSelection(sqlScript);
        if (select) {
            int selEnd;
            int entireLen = this.getEntireSQLScript().length();
            if (selStart == -1) {
                selStart = 0;
            }
            if ((selEnd = selStart + sqlScript.length() - 1) > entireLen - 1) {
                selEnd = entireLen - 1;
            }
            if (selStart <= selEnd) {
                pnl.setSelectionStart(selStart);
                pnl.setSelectionEnd(selEnd);
            }
        }
    }

    @Override
    public synchronized int getSQLScriptSelectionStart() {
        return this._panel.getSQLEntryPanel().getSelectionStart();
    }

    @Override
    public synchronized int getSQLScriptSelectionEnd() {
        return this._panel.getSQLEntryPanel().getSelectionEnd();
    }

    @Override
    public synchronized void setSQLScriptSelectionStart(int start) {
        this._panel.getSQLEntryPanel().setSelectionStart(start);
    }

    @Override
    public synchronized void setSQLScriptSelectionEnd(int end) {
        this._panel.getSQLEntryPanel().setSelectionEnd(end);
    }

    @Override
    public void executeCurrentSQL() {
        this._panel.runCurrentExecuter();
    }

    @Override
    public void closeAllSQLResultTabs() {
        this._panel.getSQLExecPanel().closeAllSQLResultTabs();
    }

    @Override
    public void closeAllButCurrentResultTabs() {
        this._panel.getSQLExecPanel().closeAllButCurrentResultTabs();
    }

    @Override
    public void closeCurrentResultTab() {
        this._panel.getSQLExecPanel().closeCurrentResultTab();
    }

    @Override
    public void toggleCurrentSQLResultTabSticky() {
        this._panel.getSQLExecPanel().toggleCurrentSQLResultTabSticky();
    }

    @Override
    public void closeAllSQLResultFrames() {
        this._panel.getSQLExecPanel().closeAllSQLResultFrames();
    }

    @Override
    public synchronized void gotoNextResultsTab() {
        this._panel.getSQLExecPanel().gotoNextResultsTab();
    }

    @Override
    public void gotoPreviousResultsTab() {
        this._panel.getSQLExecPanel().gotoPreviousResultsTab();
    }

    @Override
    public synchronized void addSQLToHistory(String sql) {
        if (sql == null) {
            throw new IllegalArgumentException("sql == null");
        }
        ISession session = this._panel.getSession();
        SQLHistoryItem shi = new SQLHistoryItem(sql, session.getAlias().getName());
        if (session.getProperties().getSQLShareHistory()) {
            session.getApplication().getSQLHistory().add(shi);
            session.getApplication().savePreferences(PreferenceType.SQLHISTORY);
        }
        this._panel.addSQLToHistory(shi);
    }

    @Override
    public void addToSQLEntryAreaMenu(JMenu menu) {
        if (menu == null) {
            throw new IllegalArgumentException("Menu == null");
        }
        this._panel.addToSQLEntryAreaMenu(menu);
    }

    @Override
    public JMenuItem addToSQLEntryAreaMenu(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Action == null");
        }
        return this._panel.addToSQLEntryAreaMenu(action);
    }

    @Override
    public ISession getSession() {
        return this._panel.getSession();
    }

    @Override
    public boolean isInMainSessionWindow() {
        return this._panel.isInMainSessionWindow();
    }

    @Override
    public boolean confirmClose() {
        if (this.unsavedEdits) {
            return this.showConfirmSaveDialog();
        }
        return true;
    }

    @Override
    public void addSqlPanelListener(SqlPanelListener sqlPanelListener) {
        this._panel.addSqlPanelListener(sqlPanelListener);
    }

    @Override
    public ArrayList<SQLHistoryItem> getSQLHistoryItems() {
        return this._panel.getSQLHistoryItems();
    }

    private boolean showConfirmSaveDialog() {
        File file = this._fileManager.getFile();
        String filename = s_stringMgr.getString("SQLPanelAPI.untitledLabel");
        if (file != null) {
            filename = file.getAbsolutePath();
        }
        String msg = s_stringMgr.getString("SQLPanelAPI.unsavedchanges", filename);
        String title = s_stringMgr.getString("SQLPanelAPI.unsavedchangestitle", ": " + this._panel.getSession().getAlias().getName());
        MainFrame f = this.getSession().getApplication().getMainFrame();
        int option = JOptionPane.showConfirmDialog(f, msg, title, 0);
        if (option == 0) {
            return this.fileSave();
        }
        return true;
    }

    private class SQLEntryUndoListener
    implements UndoableEditListener {
        private SQLEntryUndoListener() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            IApplication app = SQLPanelAPI.this.getSession().getApplication();
            SquirrelPreferences prefs = app.getSquirrelPreferences();
            if (SQLPanelAPI.this.fileOpened || SQLPanelAPI.this.fileSaved) {
                if (prefs.getWarnForUnsavedFileEdits()) {
                    SQLPanelAPI.this.unsavedEdits = true;
                }
                SQLPanelAPI.this.getActiveSessionTabWidget().setUnsavedEdits(true);
                ActionCollection actions = SQLPanelAPI.this.getSession().getApplication().getActionCollection();
                actions.enableAction(FileSaveAction.class, true);
            } else if (prefs.getWarnForUnsavedBufferEdits()) {
                SQLPanelAPI.this.unsavedEdits = true;
            }
        }
    }
}

