/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action;

import java.awt.event.ActionEvent;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.CloseSessionCommand;
import net.sourceforge.squirrel_sql.client.session.action.DumpSessionAction;
import net.sourceforge.squirrel_sql.client.session.action.ISessionAction;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class CloseSessionAction
extends SquirrelAction
implements ISessionAction {
    private static final ILogger s_log = LoggerController.createLogger(DumpSessionAction.class);
    private ISession _session;

    public CloseSessionAction(IApplication app) {
        super(app);
    }

    @Override
    public void setSession(ISession session) {
        this._session = session;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this._session != null) {
            try {
                new CloseSessionCommand(this._session).execute();
            }
            catch (Throwable ex) {
                String msg = "Error occured closing session";
                this._session.showErrorMessage("Error occured closing session: " + ex);
                s_log.error("Error occured closing session", ex);
            }
        }
    }
}

