/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.CancelPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.CancelPanelListener;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

class CancelPanelCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CancelPanelCtrl.class);
    private CancelPanel _panel;
    private int _queryCount;
    private int _currentQueryIndex = 0;
    private CancelPanelListener _listener;

    CancelPanelCtrl(CancelPanelListener listener) {
        this._listener = listener;
        this._panel = new CancelPanel();
        this._panel.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CancelPanelCtrl.this.onCancel();
            }
        });
    }

    void incCurrentQueryIndex() {
        ++this._currentQueryIndex;
    }

    void setSQL(final String sql) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String label = s_stringMgr.getString("SQLResultExecuterPanel.currentSQLLabel", String.valueOf(CancelPanelCtrl.this._currentQueryIndex), String.valueOf(CancelPanelCtrl.this._queryCount), sql);
                ((CancelPanelCtrl)CancelPanelCtrl.this)._panel.sqlLbl.setText(label);
            }
        };
        GUIUtils.processOnSwingEventThread(runnable);
    }

    void setStatusLabel(final String text) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ((CancelPanelCtrl)CancelPanelCtrl.this)._panel.currentStatusLbl.setText(text);
            }
        };
        GUIUtils.processOnSwingEventThread(runnable);
    }

    void setQueryCount(int value) {
        this._queryCount = value;
        this._currentQueryIndex = 0;
    }

    int getTotalCount() {
        return this._queryCount;
    }

    int getCurrentQueryIndex() {
        return this._currentQueryIndex;
    }

    private void onCancel() {
        this._listener.cancelRequested();
    }

    CancelPanel getPanel() {
        return this._panel;
    }
}

