/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.SessionDialogWidget;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecutionInfo;
import net.sourceforge.squirrel_sql.client.session.action.ReturnResultTabAction;
import net.sourceforge.squirrel_sql.client.session.event.ISQLExecutionListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.CancelPanelCtrl;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ErrorPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IResultTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ISQLExecutionHandlerListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ResultFrameListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ResultTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ResultTabFactory;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLExecutionHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetMetaDataDataSet;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ResultFrame
extends SessionDialogWidget {
    private static ILogger s_log = LoggerController.createLogger(ResultFrame.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ResultFrame.class);
    private ISession _session;
    private IResultTab _tab;
    private ResultTabFactory _resultTabFactory;
    private ResultFrameListener _resultFrameListener;
    private JButton _btnReturnToTab;
    private JCheckBox _chkOnTop;
    private JButton _btnReRun;
    private JPanel _centerPanel;

    public ResultFrame(ISession session, IResultTab tab, ResultTabFactory resultTabFactory, ResultFrameListener resultFrameListener, boolean checkStayOnTop, boolean isOnRerun) {
        super(ResultFrame.getFrameTitle(session, tab), true, true, true, true, session);
        this._session = session;
        this._tab = tab;
        this._resultTabFactory = resultTabFactory;
        this._resultFrameListener = resultFrameListener;
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout());
        IApplication app = session.getApplication();
        this.getContentPane().add((Component)this.createButtonPanel(session, app, checkStayOnTop), "North");
        this._centerPanel = new JPanel(new GridLayout(1, 1));
        this.getContentPane().add((Component)this._centerPanel, "Center");
        this._centerPanel.add(this._tab.getOutputComponent());
        this._chkOnTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultFrame.this.onStayOnTopChanged();
            }
        });
        this._btnReRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultFrame.this.onRerun();
            }
        });
        if (!isOnRerun) {
            this.showFrame(this, false);
        }
    }

    private void onRerun() {
        this._btnReturnToTab.setEnabled(false);
        this._btnReRun.setEnabled(false);
        this._centerPanel.removeAll();
        new SQLExecutionHandler(this._tab, this._session, this._tab.getSqlString(), this.createSQLExecutionHandlerListener(), new ISQLExecutionListener[0]);
    }

    private ISQLExecutionHandlerListener createSQLExecutionHandlerListener() {
        return new ISQLExecutionHandlerListener(){

            @Override
            public void addResultsTab(SQLExecutionInfo info, ResultSetDataSet rsds, ResultSetMetaDataDataSet rsmdds, IDataSetUpdateableTableModel creator, IResultTab resultTabToReplace) {
                ResultFrame.this.onAddResultsTab(info, rsds, rsmdds, creator, resultTabToReplace);
            }

            @Override
            public void removeCancelPanel(CancelPanelCtrl cancelPanelCtrl, IResultTab resultTabToReplace) {
                ResultFrame.this.onRemoveCancelPanel(cancelPanelCtrl, resultTabToReplace);
            }

            @Override
            public void setCancelPanel(CancelPanelCtrl cancelPanelCtrl) {
                ResultFrame.this.onSetCancelPanel(cancelPanelCtrl);
            }

            @Override
            public void displayErrors(ArrayList<String> sqlExecErrorMsgs, String lastExecutedStatement) {
                ResultFrame.this.onDisplayErrors(sqlExecErrorMsgs, lastExecutedStatement);
            }
        };
    }

    private void onDisplayErrors(final ArrayList<String> sqlExecErrorMsgs, final String lastExecutedStatement) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ResultFrame.this._centerPanel.removeAll();
                ErrorPanel errorPanel = ResultFrame.this._resultTabFactory.createErrorPanel(sqlExecErrorMsgs, lastExecutedStatement);
                errorPanel.hideCloseButton();
                ResultFrame.this._centerPanel.add(errorPanel);
                ResultFrame.this._btnReRun.setEnabled(true);
            }
        });
    }

    private void onSetCancelPanel(final CancelPanelCtrl cancelPanelCtrl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ResultFrame.this._centerPanel.removeAll();
                ResultFrame.this._centerPanel.add((Component)cancelPanelCtrl.getPanel(), "Center");
            }
        });
    }

    private void onRemoveCancelPanel(CancelPanelCtrl cancelPanelCtrl, IResultTab resultTabToReplace) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ResultFrame.this._centerPanel.removeAll();
            }
        });
    }

    private void onAddResultsTab(final SQLExecutionInfo info, final ResultSetDataSet rsds, final ResultSetMetaDataDataSet rsmdds, final IDataSetUpdateableTableModel creator, IResultTab resultTabToReplace) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ResultFrame.this._centerPanel.removeAll();
                    ResultTab tab = ResultFrame.this._resultTabFactory.createResultTab(info, creator, rsds, rsmdds);
                    ResultFrame frame = new ResultFrame(ResultFrame.this._session, tab, ResultFrame.this._resultTabFactory, ResultFrame.this._resultFrameListener, ResultFrame.this._chkOnTop.isSelected(), true);
                    ResultFrame.this.showFrame(frame, true);
                    ResultFrame.this.setVisible(false);
                    ResultFrame.this.dispose();
                    ResultFrame.this._resultFrameListener.frameReplaced(ResultFrame.this, frame);
                }
                catch (Throwable t) {
                    ResultFrame.this._session.showErrorMessage(t);
                }
            }
        });
    }

    private void showFrame(ResultFrame frame, boolean isOnRerun) {
        this._session.getApplication().getMainFrame().addWidget(frame);
        if (isOnRerun) {
            frame.setBounds(this.getBounds());
        } else {
            frame.pack();
            DialogWidget.centerWithinDesktop(frame);
        }
        frame.setVisible(true);
        frame.toFront();
        frame.requestFocus();
    }

    private JPanel createButtonPanel(ISession session, IApplication app, boolean checkStayOnTop) {
        JPanel pnlButtons = new JPanel(new GridBagLayout());
        this._btnReturnToTab = new JButton(new ReturnResultTabAction(app, this));
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0);
        pnlButtons.add((Component)this._btnReturnToTab, gbc);
        this._chkOnTop = new JCheckBox(s_stringMgr.getString("resultFrame.stayOnTop"));
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0);
        pnlButtons.add((Component)this._chkOnTop, gbc);
        this._chkOnTop.setSelected(checkStayOnTop);
        this.initLayer();
        this._chkOnTop.setVisible(session.getApplication().getDesktopStyle().supportsLayers());
        gbc = new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0);
        pnlButtons.add((Component)new JPanel(), gbc);
        ImageIcon icon = session.getApplication().getResources().getIcon("rerun");
        this._btnReRun = new JButton(icon);
        this._btnReRun.setToolTipText(s_stringMgr.getString("ResultFrame.rerun"));
        gbc = new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0);
        pnlButtons.add((Component)this._btnReRun, gbc);
        return pnlButtons;
    }

    private void onStayOnTopChanged() {
        this.initLayer();
        this.toFront();
    }

    private void initLayer() {
        if (this._chkOnTop.isSelected()) {
            this.setLayer((int)JLayeredPane.PALETTE_LAYER);
        } else {
            this.setLayer((int)JLayeredPane.DEFAULT_LAYER);
        }
    }

    @Override
    public void dispose() {
        if (this._tab != null) {
            this._tab.closeTab();
            this._tab = null;
        }
        super.dispose();
    }

    public void returnToTabbedPane() {
        s_log.debug("ResultFrame.returnToTabbedPane()");
        this.getContentPane().remove(this._tab.getOutputComponent());
        this._tab.returnToTabbedPane();
        this._tab = null;
        this.dispose();
    }

    private static String getFrameTitle(ISession session, IResultTab tab) throws IllegalArgumentException {
        if (tab == null) {
            throw new IllegalArgumentException("Null ResultTab passed");
        }
        if (session == null) {
            throw new IllegalArgumentException("Null ISession passed");
        }
        return session.getTitle() + " - " + tab.getViewableSqlString();
    }

    public IResultTab getTab() {
        return this._tab;
    }
}

