/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.gui.builders.UIFactory;
import net.sourceforge.squirrel_sql.client.session.EditableSqlCheck;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecutionInfo;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IResultTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ResultTabListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLResultExecuterPanelFacade;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.OverwiewCtrl;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.BaseDataSetViewerDestination;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetUpdateableTableModelListener;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetViewer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetMetaDataDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.TableState;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.id.IHasIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class ResultTab
extends JPanel
implements IHasIdentifier,
IResultTab {
    private static final long serialVersionUID = 1L;
    private IIdentifier _id;
    private transient ISession _session;
    private transient SQLExecutionInfo _exInfo;
    private transient IDataSetViewer _resultSetOutput;
    private transient IDataSetViewer _metaDataOutput;
    private JScrollPane _resultSetSp = new JScrollPane();
    private JScrollPane _metaDataSp = new JScrollPane();
    private JTabbedPane _tp;
    private SQLResultExecuterPanelFacade _sqlResultExecuterPanelFacade;
    private JLabel _currentSqlLbl = new JLabel();
    private String _sql;
    private QueryInfoPanel _queryInfoPanel = new QueryInfoPanel();
    private PropertyChangeListener _propsListener;
    private boolean _allowEditing;
    private transient IDataSetUpdateableTableModel _creator;
    private transient ResultSetDataSet _rsds;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ResultTab.class);
    private ResultTabListener _resultTabListener;

    public ResultTab(ISession session, SQLResultExecuterPanelFacade sqlResultExecuterPanelFacade, IIdentifier id, SQLExecutionInfo exInfo, IDataSetUpdateableTableModel creator, ResultTabListener resultTabListener) throws IllegalArgumentException {
        this._resultTabListener = resultTabListener;
        if (session == null) {
            throw new IllegalArgumentException("Null ISession passed");
        }
        if (sqlResultExecuterPanelFacade == null) {
            throw new IllegalArgumentException("Null SQLPanel passed");
        }
        if (id == null) {
            throw new IllegalArgumentException("Null IIdentifier passed");
        }
        this._session = session;
        this._sqlResultExecuterPanelFacade = sqlResultExecuterPanelFacade;
        this._id = id;
        this.init(creator, exInfo);
        this.createGUI();
        this.propertiesHaveChanged(null);
    }

    private void init(IDataSetUpdateableTableModel creator, SQLExecutionInfo exInfo) {
        this._creator = creator;
        this._creator.addListener(new DataSetUpdateableTableModelListener(){

            @Override
            public void forceEditMode(boolean mode) {
                ResultTab.this.onForceEditMode(mode);
            }
        });
        this._allowEditing = new EditableSqlCheck(exInfo).allowsEditing();
        SessionProperties props = this._session.getProperties();
        this._resultSetOutput = this._allowEditing ? BaseDataSetViewerDestination.getInstance(props.getSQLResultsOutputClassName(), this._creator) : BaseDataSetViewerDestination.getInstance(props.getReadOnlySQLResultsOutputClassName(), null);
        this._resultSetSp.setViewportView(this._resultSetOutput.getComponent());
        this._resultSetSp.setRowHeader(null);
        if (this._session.getProperties().getShowResultsMetaData()) {
            this._metaDataOutput = BaseDataSetViewerDestination.getInstance(props.getMetaDataOutputClassName(), null);
            this._metaDataSp.setViewportView(this._metaDataOutput.getComponent());
            this._metaDataSp.setRowHeader(null);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this._propsListener == null) {
            this._propsListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ResultTab.this.propertiesHaveChanged(evt);
                }
            };
            this._session.getProperties().addPropertyChangeListener(this._propsListener);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this._propsListener != null) {
            this._session.getProperties().removePropertyChangeListener(this._propsListener);
            this._propsListener = null;
        }
    }

    @Override
    public void showResults(ResultSetDataSet rsds, ResultSetMetaDataDataSet mdds, SQLExecutionInfo exInfo) throws DataSetException {
        this._exInfo = exInfo;
        this._sql = StringUtilities.cleanString(exInfo.getSQL());
        this._resultSetOutput.show(rsds, null);
        this._rsds = rsds;
        int rowCount = this._resultSetOutput.getRowCount();
        int maxRows = this._exInfo.getMaxRows();
        String escapedSql = Utilities.escapeHtmlChars(this._sql);
        if (maxRows > 0 && rowCount >= maxRows) {
            String limitMsg = s_stringMgr.getString("ResultTab.limitMessage", rowCount);
            this._currentSqlLbl.setText("<html><pre>&nbsp;" + limitMsg + ";&nbsp;&nbsp;" + escapedSql + "</pre></html>");
        } else {
            String rowsMsg = s_stringMgr.getString("ResultTab.rowsMessage", rowCount);
            this._currentSqlLbl.setText("<html><pre>&nbsp;" + rowsMsg + ";&nbsp;&nbsp;" + escapedSql + "</pre></html>");
        }
        if (mdds != null && this._metaDataOutput != null) {
            this._metaDataOutput.show(mdds, null);
        }
        exInfo.resultsProcessingComplete();
        this._queryInfoPanel.load(rsds, rowCount, exInfo);
    }

    @Override
    public void clear() {
        if (this._metaDataOutput != null) {
            this._metaDataOutput.clear();
        }
        if (this._resultSetOutput != null) {
            this._resultSetOutput.clear();
        }
        this._exInfo = null;
        this._currentSqlLbl.setText("");
        this._sql = "";
    }

    @Override
    public String getSqlString() {
        return this._exInfo != null ? this._exInfo.getSQL() : null;
    }

    @Override
    public String getViewableSqlString() {
        return StringUtilities.cleanString(this.getSqlString());
    }

    @Override
    public String getTitle() {
        String title = this._sql;
        if (title.length() < 20) {
            return title;
        }
        return title.substring(0, 15);
    }

    @Override
    public void closeTab() {
        this.add((Component)this._tp, "Center");
        this._sqlResultExecuterPanelFacade.closeResultTab(this);
    }

    @Override
    public void returnToTabbedPane() {
        this.add((Component)this._tp, "Center");
        this._sqlResultExecuterPanelFacade.returnToTabbedPane(this);
    }

    @Override
    public Component getOutputComponent() {
        return this._tp;
    }

    @Override
    public void reRunSQL() {
        this._resultTabListener.rerunSQL(this._exInfo.getSQL(), this);
    }

    private void propertiesHaveChanged(PropertyChangeEvent evt) {
        SessionProperties props = this._session.getProperties();
        if (evt == null || evt.getPropertyName().equals("sqlResultsTabPlacement")) {
            this._tp.setTabPlacement(props.getSQLResultsTabPlacement());
        }
    }

    private void onForceEditMode(boolean editable) {
        try {
            if (editable) {
                if (this._allowEditing) {
                    this._resultSetOutput = BaseDataSetViewerDestination.getInstance(SessionProperties.IDataSetDestinations.EDITABLE_TABLE, this._creator);
                    this._resultSetSp.setViewportView(this._resultSetOutput.getComponent());
                    this._resultSetSp.setRowHeader(null);
                    this._rsds.resetCursor();
                    this._resultSetOutput.show(this._rsds, null);
                } else {
                    String msg = s_stringMgr.getString("ResultTab.cannotedit");
                    JOptionPane.showMessageDialog(this._session.getApplication().getMainFrame(), msg);
                }
            } else {
                SessionProperties props = this._session.getProperties();
                String readOnlyOutput = props.getReadOnlySQLResultsOutputClassName();
                this._resultSetOutput = BaseDataSetViewerDestination.getInstance(readOnlyOutput, this._creator);
                this._resultSetSp.setViewportView(this._resultSetOutput.getComponent());
                this._resultSetSp.setRowHeader(null);
                this._rsds.resetCursor();
                this._resultSetOutput.show(this._rsds, null);
            }
        }
        catch (DataSetException e) {
            throw new RuntimeException(e);
        }
    }

    private void createGUI() {
        this.setLayout(new BorderLayout());
        int sqlResultsTabPlacement = this._session.getProperties().getSQLResultsTabPlacement();
        this._tp = UIFactory.getInstance().createTabbedPane(sqlResultsTabPlacement);
        JPanel panel1 = new JPanel();
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridLayout(1, 3, 0, 0));
        panel2.add(new TabButton(new RerunAction(this._session.getApplication())));
        panel2.add(new TabButton(new CreateResultTabFrameAction(this._session.getApplication())));
        panel2.add(new TabButton(new CloseAction()));
        panel1.setLayout(new BorderLayout());
        panel1.add((Component)panel2, "East");
        panel1.add((Component)this._currentSqlLbl, "Center");
        this.add((Component)panel1, "North");
        this.add((Component)this._tp, "Center");
        this._resultSetSp.setBorder(BorderFactory.createEmptyBorder());
        String resultsTabTitle = s_stringMgr.getString("ResultTab.resultsTabTitle");
        this._tp.addTab(resultsTabTitle, this._resultSetSp);
        if (this._session.getProperties().getShowResultsMetaData()) {
            this._metaDataSp.setBorder(BorderFactory.createEmptyBorder());
            String metadataTabTitle = s_stringMgr.getString("ResultTab.metadataTabTitle");
            this._tp.addTab(metadataTabTitle, this._metaDataSp);
        }
        JScrollPane sp = new JScrollPane(this._queryInfoPanel);
        sp.setBorder(BorderFactory.createEmptyBorder());
        String infoTabTitle = s_stringMgr.getString("ResultTab.infoTabTitle");
        this._tp.addTab(infoTabTitle, sp);
        final int overViewIx = this._tp.getTabCount();
        final OverwiewCtrl ctrl = new OverwiewCtrl(this._session);
        this._tp.addTab(ctrl.getTitle(), ctrl.getPanel());
        this._tp.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (overViewIx == ResultTab.this._tp.getSelectedIndex()) {
                    ctrl.init(ResultTab.this._rsds);
                }
            }
        });
    }

    @Override
    public IIdentifier getIdentifier() {
        return this._id;
    }

    @Override
    public TableState getResultSortableTableState() {
        return this._resultSetOutput.getResultSortableTableState();
    }

    public void applyResultSortableTableState(TableState sortableTableState) {
        this._resultSetOutput.applyResultSortableTableState(sortableTableState);
    }

    private static class QueryInfoPanel
    extends JPanel {
        private MultipleLineLabel _queryLbl = new MultipleLineLabel();
        private JLabel _rowCountLbl = new JLabel();
        private JLabel _executedLbl = new JLabel();
        private JLabel _elapsedLbl = new JLabel();

        QueryInfoPanel() {
            this.createGUI();
        }

        void load(ResultSetDataSet rsds, int rowCount, SQLExecutionInfo exInfo) {
            this._queryLbl.setText(StringUtilities.cleanString(exInfo.getSQL()));
            this._rowCountLbl.setText(String.valueOf(rowCount));
            this._executedLbl.setText(exInfo.getSQLExecutionStartTime().toString());
            this._elapsedLbl.setText(this.formatElapsedTime(exInfo));
        }

        private String formatElapsedTime(SQLExecutionInfo exInfo) {
            NumberFormat nbrFmt = NumberFormat.getNumberInstance();
            double executionLength = (double)exInfo.getSQLExecutionElapsedMillis() / 1000.0;
            double outputLength = (double)exInfo.getResultsProcessingElapsedMillis() / 1000.0;
            String totalTime = nbrFmt.format(executionLength + outputLength);
            String queryTime = nbrFmt.format(executionLength);
            String outputTime = nbrFmt.format(outputLength);
            String elapsedTime = s_stringMgr.getString("ResultTab.elapsedTime", new String[]{totalTime, queryTime, outputTime});
            return elapsedTime;
        }

        private void createGUI() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.gridwidth = 1;
            gbc.weightx = 0.0;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(5, 10, 5, 10);
            gbc.fill = 2;
            String label = s_stringMgr.getString("ResultTab.executedLabel");
            this.add((Component)new JLabel(label, 4), gbc);
            ++gbc.gridy;
            label = s_stringMgr.getString("ResultTab.rowCountLabel");
            this.add((Component)new JLabel(label, 4), gbc);
            ++gbc.gridy;
            label = s_stringMgr.getString("ResultTab.statementLabel");
            this.add((Component)new JLabel(label, 4), gbc);
            ++gbc.gridy;
            label = s_stringMgr.getString("ResultTab.elapsedTimeLabel");
            this.add((Component)new JLabel(label, 4), gbc);
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbc.gridx = 1;
            gbc.gridy = 0;
            this.add((Component)this._executedLbl, gbc);
            ++gbc.gridy;
            this.add((Component)this._rowCountLbl, gbc);
            ++gbc.gridy;
            this.add((Component)this._queryLbl, gbc);
            ++gbc.gridy;
            this.add((Component)this._elapsedLbl, gbc);
        }
    }

    public class RerunAction
    extends SquirrelAction {
        RerunAction(IApplication app) {
            super(app, app.getResources());
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ResultTab.this.reRunSQL();
        }
    }

    private class CreateResultTabFrameAction
    extends SquirrelAction {
        CreateResultTabFrameAction(IApplication app) {
            super(app, app.getResources());
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ResultTab.this._sqlResultExecuterPanelFacade.createSQLResultFrame(ResultTab.this);
        }
    }

    private class CloseAction
    extends SquirrelAction {
        CloseAction() {
            super(ResultTab.this._session.getApplication(), ResultTab.this._session.getApplication().getResources());
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ResultTab.this.closeTab();
        }
    }

    private final class TabButton
    extends JButton {
        TabButton(Action action) {
            super(action);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorderPainted(false);
            this.setText("");
        }
    }
}

