/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.sql.ResultSet;
import java.sql.SQLWarning;
import java.text.NumberFormat;
import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.client.session.ISQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecuterTask;
import net.sourceforge.squirrel_sql.client.session.SQLExecutionInfo;
import net.sourceforge.squirrel_sql.client.session.event.ISQLExecutionListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.CancelPanelCtrl;
import net.sourceforge.squirrel_sql.client.session.mainpanel.CancelPanelListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IResultTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ISQLExecutionHandlerListener;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetMetaDataDataSet;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.sql.SQLExecutionException;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

class SQLExecutionHandler
implements ISQLExecuterHandler {
    private static final ILogger s_log = LoggerController.createLogger(SQLExecutionHandler.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLExecutionHandler.class);
    private CancelPanelCtrl _cancelPanelCtrl;
    private SQLExecuterTask _executer;
    private ISession _session;
    private ISQLExecutionHandlerListener _executionHandlerListener;
    private ResultSetDataSet rsds = null;
    private String sqlToBeExecuted = null;
    private SQLType sqlType = null;
    private IResultTab _resultTabToReplace;
    private boolean _largeScript = false;
    private double _scriptTotalTime = 0.0;
    private double _scriptQueryTime = 0.0;
    private double _scriptOutptutTime = 0.0;
    private int _scriptRowsInserted = 0;
    private int _scriptRowsSelected = 0;
    private int _scriptRowsUpdated = 0;
    private int _scriptRowsDeleted = 0;

    public SQLExecutionHandler(IResultTab resultTabToReplace, ISession session, String sql, ISQLExecutionHandlerListener executionHandlerListener, ISQLExecutionListener[] executionListeners) {
        this._session = session;
        this._executionHandlerListener = executionHandlerListener;
        this._executer = new SQLExecuterTask(this._session, sql, this, executionListeners);
        SquirrelPreferences prefs = this._session.getApplication().getSquirrelPreferences();
        if (prefs.getLargeScriptStmtCount() > 0 && this._executer.getQueryCount() > prefs.getLargeScriptStmtCount()) {
            this._executer.setExecutionListeners(new ISQLExecutionListener[0]);
            this.setLargeScript(true);
        }
        this._resultTabToReplace = resultTabToReplace;
        this._cancelPanelCtrl = new CancelPanelCtrl(new CancelPanelListener(){

            @Override
            public void cancelRequested() {
                SQLExecutionHandler.this.onCancelRequested();
            }
        });
        this._executionHandlerListener.setCancelPanel(this._cancelPanelCtrl);
        this._session.getApplication().getThreadPool().addTask(this._executer);
    }

    private void onCancelRequested() {
        try {
            if (this._executer != null) {
                this._executer.cancel();
            }
        }
        catch (Throwable th) {
            s_log.error("Error occured cancelling SQL", th);
        }
    }

    public void setLargeScript(boolean aBoolean) {
        this._largeScript = aBoolean;
    }

    private boolean shouldRenderSQL(int current, int total) {
        if (!this._largeScript) {
            return true;
        }
        boolean result = true;
        if (total > 200 && current > 100 && current % 10 != 0) {
            result = false;
        }
        if (total > 1000 && current > 500 && current % 50 != 0) {
            result = false;
        }
        if (total > 2000 && current > 1000 && current % 100 != 0) {
            result = false;
        }
        return result;
    }

    @Override
    public void sqlToBeExecuted(String sql) {
        String cleanSQL;
        this._cancelPanelCtrl.incCurrentQueryIndex();
        int currentStmtCount = this._cancelPanelCtrl.getCurrentQueryIndex();
        if (!this.shouldRenderSQL(currentStmtCount, this._cancelPanelCtrl.getTotalCount())) {
            return;
        }
        this.sqlToBeExecuted = cleanSQL = StringUtilities.cleanString(sql);
        this.sqlType = this.getSQLType(cleanSQL);
        this._cancelPanelCtrl.setSQL(this.sqlToBeExecuted);
        String status = s_stringMgr.getString("SQLResultExecuterPanel.execStatus");
        this._cancelPanelCtrl.setStatusLabel(status);
    }

    private SQLType getSQLType(String sql) {
        SQLType result = SQLType.UNKNOWN;
        if (sql.toLowerCase().startsWith("insert")) {
            result = SQLType.INSERT;
        }
        if (sql.toLowerCase().startsWith("update")) {
            result = SQLType.UPDATE;
        }
        if (sql.toLowerCase().startsWith("select")) {
            result = SQLType.SELECT;
        }
        if (sql.toLowerCase().startsWith("delete")) {
            result = SQLType.DELETE;
        }
        return result;
    }

    @Override
    public void sqlExecutionComplete(SQLExecutionInfo exInfo, int processedStatementCount, int statementCount) {
        double executionLength = (double)exInfo.getSQLExecutionElapsedMillis() / 1000.0;
        double outputLength = (double)exInfo.getResultsProcessingElapsedMillis() / 1000.0;
        double totalLength = executionLength + outputLength;
        Integer numberResultRowsRead = exInfo.getNumberResultRowsRead();
        if (this._largeScript) {
            this._scriptQueryTime += executionLength;
            this._scriptOutptutTime += outputLength;
            this._scriptTotalTime += totalLength;
            if (statementCount == processedStatementCount) {
                this.printScriptExecDetails(statementCount, this._scriptQueryTime, this._scriptOutptutTime, this._scriptTotalTime);
            }
        } else {
            this.printStatementExecTime(processedStatementCount, statementCount, numberResultRowsRead, executionLength, outputLength, totalLength);
        }
    }

    private void printScriptExecDetails(int statementCount, double executionLength, double outputLength, double totalLength) {
        NumberFormat nbrFmt = NumberFormat.getNumberInstance();
        Object[] args = new Object[]{statementCount, nbrFmt.format(totalLength), nbrFmt.format(executionLength), nbrFmt.format(outputLength)};
        String stats = s_stringMgr.getString("SQLResultExecuterPanel.scriptQueryStatistics", args);
        String[] counts = new String[]{Integer.toString(this._scriptRowsInserted), Integer.toString(this._scriptRowsSelected), Integer.toString(this._scriptRowsUpdated), Integer.toString(this._scriptRowsDeleted)};
        String msg = s_stringMgr.getString("SQLResultExecuterPanel.scriptStmtCounts", counts);
        this._session.showMessage(msg);
        this._session.showMessage(stats);
    }

    private void printStatementExecTime(int processedStatementCount, int statementCount, Integer numberResultRowsRead, double executionLength, double outputLength, double totalLength) {
        NumberFormat nbrFmt = NumberFormat.getNumberInstance();
        Object[] args = new Object[]{processedStatementCount, statementCount, numberResultRowsRead == null ? 0 : numberResultRowsRead, nbrFmt.format(totalLength), nbrFmt.format(executionLength), nbrFmt.format(outputLength)};
        String stats = s_stringMgr.getString("SQLResultExecuterPanel.queryStatistics", args);
        this._session.showMessage(stats);
    }

    @Override
    public void sqlExecutionCancelled() {
        if (this.rsds != null) {
            this.rsds.cancelProcessing();
        }
    }

    @Override
    public void sqlDataUpdated(int updateCount) {
        Integer count = updateCount;
        String msg = "";
        switch (this.sqlType) {
            case INSERT: {
                if (this._largeScript) {
                    ++this._scriptRowsInserted;
                    break;
                }
                msg = s_stringMgr.getString("SQLResultExecuterPanel.rowsInserted", count);
                break;
            }
            case SELECT: {
                if (this._largeScript) {
                    ++this._scriptRowsSelected;
                    break;
                }
                msg = s_stringMgr.getString("SQLResultExecuterPanel.rowsSelected", count);
                break;
            }
            case UPDATE: {
                if (this._largeScript) {
                    ++this._scriptRowsUpdated;
                    break;
                }
                msg = s_stringMgr.getString("SQLResultExecuterPanel.rowsUpdated", count);
                break;
            }
            case DELETE: {
                if (this._largeScript) {
                    ++this._scriptRowsDeleted;
                    break;
                }
                msg = s_stringMgr.getString("SQLResultExecuterPanel.rowsDeleted", count);
            }
        }
        if (this._largeScript) {
            return;
        }
        this._session.showMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sqlResultSetAvailable(ResultSet rs, SQLExecutionInfo info, IDataSetUpdateableTableModel model) throws DataSetException {
        String outputStatus = s_stringMgr.getString("SQLResultExecuterPanel.outputStatus");
        this._cancelPanelCtrl.setStatusLabel(outputStatus);
        this.rsds = new ResultSetDataSet();
        try {
            SessionProperties props = this._session.getProperties();
            ResultSetMetaDataDataSet rsmdds = null;
            if (props.getShowResultsMetaData()) {
                rsmdds = new ResultSetMetaDataDataSet(rs);
            }
            DialectType dialectType = DialectFactory.getDialectType(this._session.getMetaData());
            info.setNumberResultRowsRead(this.rsds.setContentsTabResultSet(rs, null, dialectType));
            this._executionHandlerListener.addResultsTab(info, this.rsds, rsmdds, model, this._resultTabToReplace);
        }
        finally {
            this.rsds = null;
        }
    }

    @Override
    public void sqlExecutionWarning(SQLWarning warn) {
        this._session.showMessage(warn);
    }

    @Override
    public void sqlStatementCount(int statementCount) {
        this._cancelPanelCtrl.setQueryCount(statementCount);
    }

    @Override
    public void sqlCloseExecutionHandler(ArrayList<String> sqlExecErrorMsgs, String lastExecutedStatement) {
        this._executionHandlerListener.removeCancelPanel(this._cancelPanelCtrl, this._resultTabToReplace);
        if (null != sqlExecErrorMsgs && 0 < sqlExecErrorMsgs.size() && this._session.getProperties().getShowSQLErrorsInTab()) {
            this._executionHandlerListener.displayErrors(sqlExecErrorMsgs, lastExecutedStatement);
        }
        this._executer = null;
    }

    @Override
    public String sqlExecutionException(Throwable th, String postErrorString) {
        SQLExecutionException ex = new SQLExecutionException(th, postErrorString);
        String message = this._session.formatException(ex);
        this._session.showErrorMessage(message);
        if (this._session.getProperties().getWriteSQLErrorsToLog()) {
            s_log.info(message);
        }
        return message;
    }

    private static enum SQLType {
        INSERT,
        SELECT,
        UPDATE,
        DELETE,
        UNKNOWN;

    }
}

