/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.plugin.IPluginManager;
import net.sourceforge.squirrel_sql.client.plugin.ISessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.SessionPluginInfo;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.DatabaseExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ProcedureTypeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.TableTypeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.UDTTypeExpander;
import net.sourceforge.squirrel_sql.client.session.schemainfo.FilterMatcher;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ObjectTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 1L;
    private static ILogger logger = LoggerController.createLogger(ObjectTreeModel.class);
    private Map<IIdentifier, List<INodeExpander>> _expanders = new HashMap<IIdentifier, List<INodeExpander>>();
    private final Set<DatabaseObjectType> _objectTypes = new TreeSet<DatabaseObjectType>(new DatabaseObjectTypeComparator());

    public ObjectTreeModel(final ISession session) {
        super(ObjectTreeModel.createRootNode(session), true);
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                final DatabaseExpander expander = new DatabaseExpander(session);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ObjectTreeModel.this.addExpander(DatabaseObjectType.CATALOG, expander);
                        ObjectTreeModel.this.addExpander(DatabaseObjectType.SCHEMA, expander);
                        boolean foundTableExp = false;
                        boolean foundProcExp = false;
                        boolean foundUDTExp = false;
                        boolean foundDatabaseExp = false;
                        IPluginManager pmgr = session.getApplication().getPluginManager();
                        Iterator<SessionPluginInfo> pluginItr = pmgr.getSessionPluginIterator();
                        while (pluginItr.hasNext()) {
                            INodeExpander databaseExp;
                            INodeExpander udtExp;
                            INodeExpander procExp;
                            ISessionPlugin p = pluginItr.next().getSessionPlugin();
                            INodeExpander tableExp = p.getDefaultNodeExpander(session, DatabaseObjectType.TABLE_TYPE_DBO);
                            if (tableExp != null) {
                                foundTableExp = true;
                                ObjectTreeModel.this.addExpander(DatabaseObjectType.TABLE_TYPE_DBO, tableExp);
                            }
                            if ((procExp = p.getDefaultNodeExpander(session, DatabaseObjectType.PROC_TYPE_DBO)) != null) {
                                foundProcExp = true;
                                ObjectTreeModel.this.addExpander(DatabaseObjectType.PROC_TYPE_DBO, procExp);
                            }
                            if ((udtExp = p.getDefaultNodeExpander(session, DatabaseObjectType.UDT_TYPE_DBO)) != null) {
                                foundUDTExp = true;
                                ObjectTreeModel.this.addExpander(DatabaseObjectType.UDT_TYPE_DBO, udtExp);
                            }
                            if ((databaseExp = p.getDefaultNodeExpander(session, DatabaseObjectType.DATABASE_TYPE_DBO)) == null) continue;
                            foundDatabaseExp = true;
                            ObjectTreeModel.this.addExpander(DatabaseObjectType.SESSION, databaseExp);
                        }
                        if (!foundTableExp) {
                            ObjectTreeModel.this.addExpander(DatabaseObjectType.TABLE_TYPE_DBO, new TableTypeExpander());
                        }
                        if (!foundProcExp) {
                            ObjectTreeModel.this.addExpander(DatabaseObjectType.PROC_TYPE_DBO, new ProcedureTypeExpander());
                        }
                        if (!foundUDTExp) {
                            ObjectTreeModel.this.addExpander(DatabaseObjectType.UDT_TYPE_DBO, new UDTTypeExpander());
                        }
                        if (!foundDatabaseExp) {
                            ObjectTreeModel.this.addExpander(DatabaseObjectType.SESSION, expander);
                        }
                        ObjectTreeModel.this.reload();
                    }
                });
            }
        });
    }

    public synchronized void addExpander(DatabaseObjectType dboType, INodeExpander expander) {
        if (dboType == null) {
            throw new IllegalArgumentException("Null DatabaseObjectType passed");
        }
        if (expander == null) {
            throw new IllegalArgumentException("Null INodeExpander passed");
        }
        this.getExpandersList(dboType).add(expander);
        this.addKnownDatabaseObjectType(dboType);
    }

    public synchronized INodeExpander[] getExpanders(DatabaseObjectType dboType) {
        if (dboType == null) {
            throw new IllegalArgumentException("Null DatabaseObjectType passed");
        }
        List<INodeExpander> list = this.getExpandersList(dboType);
        return list.toArray(new INodeExpander[list.size()]);
    }

    public synchronized DatabaseObjectType[] getDatabaseObjectTypes() {
        DatabaseObjectType[] ar = new DatabaseObjectType[this._objectTypes.size()];
        return this._objectTypes.toArray(ar);
    }

    synchronized void addKnownDatabaseObjectType(DatabaseObjectType dboType) {
        this._objectTypes.add(dboType);
    }

    ObjectTreeNode getRootObjectTreeNode() {
        return (ObjectTreeNode)this.getRoot();
    }

    private List<INodeExpander> getExpandersList(DatabaseObjectType dboType) {
        if (dboType == null) {
            throw new IllegalArgumentException("Null DatabaseObjectType passed");
        }
        IIdentifier key = dboType.getIdentifier();
        List<INodeExpander> list = this._expanders.get(key);
        if (list == null) {
            list = new ArrayList<INodeExpander>();
            this._expanders.put(key, list);
        }
        return list;
    }

    private static ObjectTreeNode createRootNode(ISession session) {
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        return new RootNode(session);
    }

    public TreePath getPathToDbInfo(String catalog, String schema, FilterMatcher objectMatcher, ObjectTreeNode startNode, boolean useExpanders) {
        if (this.dbObjectInfoEquals(catalog, schema, objectMatcher, startNode.getDatabaseObjectInfo())) {
            return new TreePath(startNode.getPath());
        }
        if (useExpanders && 0 == startNode.getChildCount()) {
            INodeExpander[] expanders = this.getExpanders(startNode.getDatabaseObjectType());
            for (int i = 0; i < expanders.length; ++i) {
                try {
                    List<ObjectTreeNode> children = expanders[i].createChildren(startNode.getSession(), startNode);
                    for (int j = 0; j < children.size(); ++j) {
                        ObjectTreeNode newChild = children.get(j);
                        if (0 == this.getExpanders(newChild.getDatabaseObjectType()).length) {
                            newChild.setAllowsChildren(false);
                        } else {
                            newChild.setAllowsChildren(true);
                        }
                        startNode.add(newChild);
                    }
                    continue;
                }
                catch (Exception e) {
                    String msg = "Error loading object type " + startNode.getDatabaseObjectType() + ". Error: " + e.toString() + ". See SQuirreL Logs for stackttrace.";
                    startNode.getSession().showErrorMessage(msg);
                    logger.error(msg, e);
                }
            }
        }
        for (int i = 0; i < startNode.getChildCount(); ++i) {
            TreePath ret = this.getPathToDbInfo(catalog, schema, objectMatcher, (ObjectTreeNode)startNode.getChildAt(i), useExpanders);
            if (null == ret) continue;
            return ret;
        }
        return null;
    }

    private boolean dbObjectInfoEquals(String catalog, String schema, FilterMatcher objectMatcher, IDatabaseObjectInfo doi) {
        if (null != catalog && !catalog.equalsIgnoreCase(doi.getCatalogName())) {
            return false;
        }
        if (null != schema && !schema.equalsIgnoreCase(doi.getSchemaName())) {
            return false;
        }
        return null == objectMatcher.getMetaDataMatchString() || false != objectMatcher.matches(doi.getSimpleName()) || false != objectMatcher.getMetaDataMatchString().equalsIgnoreCase(doi.getQualifiedName());
    }

    public boolean isRootNode(Object node) {
        return node instanceof RootNode;
    }

    private static final class DatabaseObjectTypeComparator
    implements Comparator<DatabaseObjectType>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private DatabaseObjectTypeComparator() {
        }

        @Override
        public int compare(DatabaseObjectType o1, DatabaseObjectType o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }

    private static final class RootNode
    extends ObjectTreeNode {
        private static final long serialVersionUID = 1L;

        RootNode(ISession session) {
            super(session, RootNode.createDbo(session));
        }

        private static final IDatabaseObjectInfo createDbo(ISession session) {
            return new DatabaseObjectInfo(null, null, session.getAlias().getName(), DatabaseObjectType.SESSION, session.getMetaData());
        }
    }
}

