/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview;

import java.awt.Component;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScaleTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;

public class OverviewHolder {
    private DataScaleTable _dataScaleTable;
    private SimpleTable _simpleTable;

    public DataScaleTable getDataScaleTable() {
        return this._dataScaleTable;
    }

    public boolean isEmpty() {
        return null == this._dataScaleTable && null == this._simpleTable;
    }

    public void setOverview(DataScaleTable dataScaleTable) {
        if (null != this._dataScaleTable) {
            dataScaleTable.setParentScaleTable(this._dataScaleTable);
        }
        this._dataScaleTable = dataScaleTable;
        this._simpleTable = null;
    }

    public void setOverview(DataSetViewerTablePanel simpleTable) {
        this._simpleTable = new SimpleTable(simpleTable, this._dataScaleTable);
        this._dataScaleTable = null;
    }

    public void setParent() {
        if (null != this._simpleTable) {
            this._dataScaleTable = this._simpleTable.getParent();
            this._simpleTable = null;
            return;
        }
        if (null != this._dataScaleTable) {
            this._dataScaleTable = this._dataScaleTable.getParentScaleTable();
            this._simpleTable = null;
            return;
        }
    }

    public void setKid() {
        if (null != this._dataScaleTable.getKidScaleTable()) {
            this._dataScaleTable = this._dataScaleTable.getKidScaleTable();
            this._simpleTable = null;
        } else {
            this._simpleTable = new SimpleTable(this._dataScaleTable.getKidSimpleTable(), this._dataScaleTable);
            this._dataScaleTable = null;
        }
    }

    public boolean hasParent() {
        if (null != this._simpleTable) {
            return true;
        }
        if (null != this._dataScaleTable) {
            return null != this._dataScaleTable.getParentScaleTable();
        }
        throw new IllegalStateException("Either _simpleTable or _dataScaleTable must be initialized");
    }

    public boolean hasKid() {
        if (null != this._simpleTable) {
            return false;
        }
        if (null != this._dataScaleTable) {
            return null != this._dataScaleTable.getKidScaleTable() || null != this._dataScaleTable.getKidSimpleTable();
        }
        throw new IllegalStateException("Either _simpleTable or _dataScaleTable must be initialized");
    }

    public Component getComponent() {
        if (null != this._simpleTable) {
            return this._simpleTable.getComponent();
        }
        if (null != this._dataScaleTable) {
            return this._dataScaleTable;
        }
        throw new IllegalStateException("Either _simpleTable or _dataScaleTable must be initialized");
    }

    public boolean canShowInSimpleTable() {
        return null != this._dataScaleTable;
    }

    public boolean isScaleTable() {
        return null != this._dataScaleTable;
    }

    private static class SimpleTable {
        private DataScaleTable _parent;
        private DataSetViewerTablePanel _simpleTable;

        public SimpleTable(DataSetViewerTablePanel simpleTable, DataScaleTable parent) {
            this._simpleTable = simpleTable;
            this._parent = parent;
            this._parent.setKidSimpleTable(this._simpleTable);
        }

        public DataScaleTable getParent() {
            return this._parent;
        }

        public Component getComponent() {
            return this._simpleTable.getComponent();
        }
    }
}

