/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.OverviewDataSet;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.OverviewFrame;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.OverviewHolder;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.OverwiewPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScale;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScaleListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScaleTable;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScaleTableModel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.Interval;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.ScaleFactory;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class OverwiewCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(OverwiewCtrl.class);
    private OverviewHolder _overviewHolder = new OverviewHolder();
    private OverwiewPanel _overwiewPanel;
    private IApplication _app;

    public OverwiewCtrl(ISession session) {
        this._app = session.getApplication();
        this._overwiewPanel = new OverwiewPanel(this._app.getResources());
        this._overwiewPanel.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OverwiewCtrl.this.onNext();
            }
        });
        this._overwiewPanel.btnPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OverwiewCtrl.this.onPrev();
            }
        });
        this._overwiewPanel.btnShowInTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OverwiewCtrl.this.onShowInTable();
            }
        });
        this._overwiewPanel.btnShowInTableWin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OverwiewCtrl.this.onShowInTableWin();
            }
        });
        this._overwiewPanel.btnSaveColumnWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OverwiewCtrl.this.onSaveColumnWidths();
            }
        });
    }

    private void onSaveColumnWidths() {
        this._overviewHolder.getDataScaleTable().saveColumnWidths();
    }

    private void onShowInTableWin() {
        DataSetViewerTablePanel simpleTable = this.createSimpleTable();
        this.openWindowForTable(simpleTable);
    }

    private void openWindowForTable(DataSetViewerTablePanel simpleTable) {
        Window parent = SwingUtilities.windowForComponent(this._overwiewPanel.btnShowInTableWin);
        OverviewFrame overviewFrame = new OverviewFrame(simpleTable, this._app, parent);
        this._app.getMainFrame().addWidget(overviewFrame);
        overviewFrame.setLayer(JLayeredPane.PALETTE_LAYER);
        overviewFrame.setVisible(true);
        DialogWidget.centerWithinDesktop(overviewFrame);
    }

    private void onShowInTable() {
        this._overviewHolder.setOverview(this.createSimpleTable());
        this.initGui();
    }

    private void onShowIntervalInTable(Interval interval) {
        List<Object[]> rows = interval.getResultRows();
        ColumnDisplayDefinition[] columnDisplayDefinitions = this._overviewHolder.getDataScaleTable().getColumnDisplayDefinitions();
        this._overviewHolder.setOverview(this.createSimpleTable(rows, columnDisplayDefinitions));
        this.initGui();
    }

    private void onShowIntervalInTableWin(Interval interval) {
        List<Object[]> rows = interval.getResultRows();
        ColumnDisplayDefinition[] columnDisplayDefinitions = this._overviewHolder.getDataScaleTable().getColumnDisplayDefinitions();
        this.openWindowForTable(this.createSimpleTable(rows, columnDisplayDefinitions));
    }

    private DataSetViewerTablePanel createSimpleTable() {
        List<Object[]> allRows = this._overviewHolder.getDataScaleTable().getAllRows();
        ColumnDisplayDefinition[] columnDisplayDefinitions = this._overviewHolder.getDataScaleTable().getColumnDisplayDefinitions();
        return this.createSimpleTable(allRows, columnDisplayDefinitions);
    }

    private DataSetViewerTablePanel createSimpleTable(List<Object[]> allRows, ColumnDisplayDefinition[] columnDisplayDefinitions) {
        try {
            OverviewDataSet ods = new OverviewDataSet(allRows, columnDisplayDefinitions);
            DataSetViewerTablePanel dsv = new DataSetViewerTablePanel();
            dsv.init(null);
            dsv.show(ods);
            return dsv;
        }
        catch (DataSetException e) {
            throw new RuntimeException(e);
        }
    }

    private void onPrev() {
        this._overviewHolder.setParent();
        this.initGui();
    }

    private void onNext() {
        this._overviewHolder.setKid();
        this.initGui();
    }

    public String getTitle() {
        return s_stringMgr.getString("OverwiewCtrl.title");
    }

    public Component getPanel() {
        return this._overwiewPanel;
    }

    public void init(ResultSetDataSet rsds) {
        if (!this._overviewHolder.isEmpty()) {
            return;
        }
        List<Object[]> rows = rsds.getAllDataForReadOnly();
        DataSetDefinition dataSetDefinition = rsds.getDataSetDefinition();
        ColumnDisplayDefinition[] columnDefinitions = dataSetDefinition.getColumnDefinitions();
        this.initScales(rows, columnDefinitions);
    }

    private void onIntervalSelected(Interval interval, ColumnDisplayDefinition[] columnDefinitions) {
        if (!interval.containsAllRows()) {
            List<Object[]> rows = interval.getResultRows();
            this.initScales(rows, columnDefinitions);
        }
    }

    private void initScales(List<Object[]> rows, final ColumnDisplayDefinition[] columnDefinitions) {
        if (0 == rows.size()) {
            this.initScaleTable(new DataScale[0], rows, columnDefinitions);
            return;
        }
        DataScale[] scales = new DataScale[columnDefinitions.length];
        DataScaleListener dataScaleListener = new DataScaleListener(){

            @Override
            public void intervalSelected(Interval interval) {
                OverwiewCtrl.this.onIntervalSelected(interval, columnDefinitions);
            }

            @Override
            public void showInTableWin(Interval interval) {
                OverwiewCtrl.this.onShowIntervalInTableWin(interval);
            }

            @Override
            public void showInTable(Interval interval) {
                OverwiewCtrl.this.onShowIntervalInTable(interval);
            }
        };
        for (int i = 0; i < columnDefinitions.length; ++i) {
            scales[i] = new ScaleFactory(rows, i, columnDefinitions[i]).createScale(dataScaleListener);
        }
        this.initScaleTable(scales, rows, columnDefinitions);
    }

    private void initScaleTable(DataScale[] scales, List<Object[]> rows, ColumnDisplayDefinition[] columnDefinitions) {
        DataScaleTableModel dataScaleTableModel = new DataScaleTableModel(scales);
        DataScaleTable dataScaleTable = new DataScaleTable(dataScaleTableModel, rows, columnDefinitions);
        DefaultTableColumnModel tcm = new DefaultTableColumnModel();
        dataScaleTable.setColumnModel(tcm);
        for (int i = 0; i < DataScaleTableModel.getColumnNames().length; ++i) {
            TableColumn col = new TableColumn(i);
            col.setHeaderValue(DataScaleTableModel.getColumnNames()[i]);
            if (DataScaleTableModel.COL_NAME_COLUMN.equals(DataScaleTableModel.getColumnNames()[i])) {
                col.setPreferredWidth(dataScaleTableModel.getColumnWidthForColName(DataScaleTableModel.COL_NAME_COLUMN));
            } else if (DataScaleTableModel.COL_NAME_DATA.equals(DataScaleTableModel.getColumnNames()[i])) {
                col.setPreferredWidth(dataScaleTableModel.getColumnWidthForColName(DataScaleTableModel.COL_NAME_DATA));
            }
            tcm.addColumn(col);
        }
        this._overviewHolder.setOverview(dataScaleTable);
        this.initGui();
    }

    private void initGui() {
        this._overwiewPanel.btnPrev.setEnabled(this._overviewHolder.hasParent());
        this._overwiewPanel.btnNext.setEnabled(this._overviewHolder.hasKid());
        this._overwiewPanel.btnShowInTable.setEnabled(this._overviewHolder.canShowInSimpleTable());
        this._overwiewPanel.btnShowInTableWin.setEnabled(this._overviewHolder.canShowInSimpleTable());
        this._overwiewPanel.btnSaveColumnWidth.setEnabled(this._overviewHolder.isScaleTable());
        this._overwiewPanel.scrollPane.setViewportView(this._overviewHolder.getComponent());
    }
}

