/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale;

import java.util.Comparator;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.Calculator;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.IndexedColumn;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.NoIx;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;

public class BooleanIndexedColumn
extends IndexedColumn {
    public BooleanIndexedColumn(List<Object[]> rows, int colIx, ColumnDisplayDefinition colDef) {
        super(rows, colIx, colDef);
        Comparator<Object> comparator = new Comparator<Object>(){

            @Override
            public int compare(Object ix1, Object ix2) {
                if (ix1 instanceof NoIx && ix2 instanceof NoIx) {
                    return BooleanIndexedColumn.this.compareBoolean(((NoIx)ix1).get(), ((NoIx)ix2).get());
                }
                if (ix1 instanceof NoIx) {
                    return BooleanIndexedColumn.this.compareBoolean(((NoIx)ix1).get(), BooleanIndexedColumn.this.getRow((Integer)ix2));
                }
                if (ix2 instanceof NoIx) {
                    return BooleanIndexedColumn.this.compareBoolean(BooleanIndexedColumn.this.getRow((Integer)ix1), ((NoIx)ix2).get());
                }
                return BooleanIndexedColumn.this.compareBoolean(BooleanIndexedColumn.this.getRow((Integer)ix1), BooleanIndexedColumn.this.getRow((Integer)ix2));
            }
        };
        this.sortIx(comparator);
    }

    private int compareBoolean(Object o1, Object o2) {
        Boolean b1 = this.asBoolean(o1);
        Boolean b2 = this.asBoolean(o2);
        if (b1 == null && b2 != null) {
            return -1;
        }
        if (b1 != null && b2 == null) {
            return 1;
        }
        if (b1 == null && b2 == null) {
            return 0;
        }
        return b1.compareTo(b2);
    }

    private Boolean asBoolean(Object o) {
        Boolean b = null;
        if (null != o) {
            b = o instanceof Number ? Boolean.valueOf(0 != ((Number)o).intValue()) : (Boolean)o;
        }
        return b;
    }

    @Override
    public Calculator getCalculator() {
        return new Calculator(){

            public Object getMid(Object min, Object max) {
                return BooleanIndexedColumn.this.onGetMid(min, max);
            }
        };
    }

    private Object onGetMid(Object min, Object max) {
        return this.asBoolean(min) != false && this.asBoolean(max) != false;
    }
}

