/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale;

import java.util.Comparator;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.Calculator;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.IndexedColumn;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.NoIx;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;

public class IntegerIndexedColumn
extends IndexedColumn {
    private IntegerRange _intRange = new IntegerRange();

    public IntegerIndexedColumn(List<Object[]> rows, int colIx, ColumnDisplayDefinition colDef) {
        super(rows, colIx, colDef);
        Comparator<Object> comparator = new Comparator<Object>(){

            @Override
            public int compare(Object ix1, Object ix2) {
                if (ix1 instanceof NoIx && ix2 instanceof NoIx) {
                    return IntegerIndexedColumn.this.compareInteger(((NoIx)ix1).get(), ((NoIx)ix2).get());
                }
                if (ix1 instanceof NoIx) {
                    return IntegerIndexedColumn.this.compareInteger(((NoIx)ix1).get(), IntegerIndexedColumn.this.getRow((Integer)ix2));
                }
                if (ix2 instanceof NoIx) {
                    return IntegerIndexedColumn.this.compareInteger(IntegerIndexedColumn.this.getRow((Integer)ix1), ((NoIx)ix2).get());
                }
                return IntegerIndexedColumn.this.compareInteger(IntegerIndexedColumn.this.getRow((Integer)ix1), IntegerIndexedColumn.this.getRow((Integer)ix2));
            }
        };
        this._intRange.beginInit();
        this.sortIx(comparator);
        this._intRange.endInit();
    }

    private int compareInteger(Object o1, Object o2) {
        Integer i1 = null;
        if (null != o1) {
            i1 = ((Number)o1).intValue();
        }
        Integer i2 = null;
        if (null != o2) {
            i2 = ((Number)o2).intValue();
        }
        this._intRange.init(i1);
        this._intRange.init(i2);
        if (i1 == null && i2 != null) {
            return -1;
        }
        if (i1 != null && i2 == null) {
            return 1;
        }
        if (i1 == null && i2 == null) {
            return 0;
        }
        return i1.compareTo(i2);
    }

    @Override
    public Calculator getCalculator() {
        return new Calculator(){

            public Object getMid(Object min, Object max) {
                return IntegerIndexedColumn.this.onGetMid(min, max);
            }
        };
    }

    private Object onGetMid(Object min, Object max) {
        Integer intMin = null == min ? Integer.valueOf(this._intRange.getMin() - 1) : Integer.valueOf(((Number)min).intValue());
        Integer intMax = null == max ? Integer.valueOf(this._intRange.getMin() - 1) : Integer.valueOf(((Number)max).intValue());
        return intMin + (intMax - intMin) / 2;
    }

    private static class IntegerRange {
        private int _max = 0;
        private int _min = 0;
        private boolean _initializing;
        private boolean _isInit;

        private IntegerRange() {
        }

        public void init(Integer i) {
            if (!this._initializing) {
                return;
            }
            if (null == i) {
                return;
            }
            if (!this._isInit) {
                this._min = i;
                this._max = i;
                this._isInit = true;
            }
            this._min = Math.min(this._min, i);
            this._max = Math.max(this._max, i);
        }

        public int getMin() {
            return this._min;
        }

        void beginInit() {
            this._initializing = true;
        }

        void endInit() {
            this._initializing = false;
        }
    }
}

