/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScale;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.DataScaleListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.IndexedColumn;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.IndexedColumnFactory;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.Interval;
import net.sourceforge.squirrel_sql.client.session.mainpanel.overview.datascale.NoIx;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;

public class ScaleFactory {
    private static final int CALL_DEPTH = 4;
    private IndexedColumn _indexedColumn;

    public ScaleFactory(List<Object[]> rows, int colIx, ColumnDisplayDefinition colDef) {
        this._indexedColumn = IndexedColumnFactory.create(rows, colIx, colDef);
    }

    public DataScale createScale(DataScaleListener dataScaleListener) {
        Object min = this._indexedColumn.getMin();
        Object max = this._indexedColumn.getMax();
        DataScale ret = new DataScale(this._indexedColumn.getColumnName(), dataScaleListener, this._indexedColumn.getColumnIndex());
        if (0 == this._indexedColumn.compareObjects(min, max)) {
            ret.addInterval(new Interval(this._indexedColumn, 0, this._indexedColumn.size() - 1, min, max));
            return ret;
        }
        Object[] borders = this.createBorders(min, max).toArray(new Object[0]);
        this.sortBorders(borders);
        Integer lastIx = null;
        Object lastBorder = min;
        for (Object border : borders) {
            int bsRet = this._indexedColumn.binarySearch(border);
            int ip = 0 > bsRet ? -bsRet - 1 - 1 : this._indexedColumn.getLastIndexOfVal(bsRet);
            if (null == lastIx) {
                ret.addInterval(new Interval(this._indexedColumn, 0, ip, lastBorder, border));
                lastBorder = border;
                lastIx = ip + 1;
                continue;
            }
            if (ip <= lastIx) continue;
            ret.addInterval(new Interval(this._indexedColumn, lastIx, ip, lastBorder, border));
            lastBorder = border;
            lastIx = ip + 1;
        }
        if (this._indexedColumn.size() > lastIx) {
            ret.addInterval(new Interval(this._indexedColumn, lastIx, this._indexedColumn.size() - 1, lastBorder, max));
        }
        return ret;
    }

    private void sortBorders(Object[] borders) {
        int i;
        NoIx[] noIxes = new NoIx[borders.length];
        for (i = 0; i < noIxes.length; ++i) {
            noIxes[i] = new NoIx(borders[i]);
        }
        Arrays.sort(noIxes, this._indexedColumn.getComparator());
        for (i = 0; i < noIxes.length; ++i) {
            borders[i] = noIxes[i].get();
        }
    }

    private HashSet<Object> createBorders(Object min, Object max) {
        HashSet<Object> ret = new HashSet<Object>();
        int[] callDepth = new int[]{0};
        this.divide(min, max, ret, callDepth);
        if (0 == ret.size()) {
            ret.add(min);
        }
        return ret;
    }

    private void divide(Object min, Object max, HashSet<Object> ret, int[] callDepth) {
        callDepth[0] = callDepth[0] + 1;
        if (4 == callDepth[0]) {
            return;
        }
        Object mid = this._indexedColumn.getCalculator().getMid(min, max);
        if (0 != this._indexedColumn.compareObjects(min, mid)) {
            ret.add(mid);
        }
        this.divide(min, mid, ret, new int[]{callDepth[0]});
        this.divide(mid, max, ret, new int[]{callDepth[0]});
        callDepth[0] = callDepth[0] - 1;
    }
}

