/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.properties;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.preferences.INewSessionPropertiesPanel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.properties.ISessionPropertiesPanel;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.gui.IntegerField;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import org.apache.commons.lang.StringUtils;

public class SessionObjectTreePropertiesPanel
implements INewSessionPropertiesPanel,
ISessionPropertiesPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SessionObjectTreePropertiesPanel.class);
    private static boolean _objectTreeRefreshNeeded = false;
    private final IApplication _app;
    private final ObjectTreepropsPanel _myPanel;
    private final JScrollPane _scrolledMyPanel;
    private SessionProperties _props;

    public SessionObjectTreePropertiesPanel(IApplication app) throws IllegalArgumentException {
        if (app == null) {
            throw new IllegalArgumentException("Null IApplication passed");
        }
        this._app = app;
        this._myPanel = new ObjectTreepropsPanel(app);
        this._scrolledMyPanel = new JScrollPane(this._myPanel);
    }

    @Override
    public void initialize(IApplication app) {
        this._props = this._app.getSquirrelPreferences().getSessionProperties();
        this._myPanel.loadData(this._props);
    }

    @Override
    public void initialize(IApplication app, ISession session) throws IllegalArgumentException {
        if (session == null) {
            throw new IllegalArgumentException("Null ISession passed");
        }
        this._props = session.getProperties();
        this._myPanel.loadData(this._props);
    }

    @Override
    public Component getPanelComponent() {
        return this._scrolledMyPanel;
    }

    @Override
    public String getTitle() {
        return ObjectTreepropsPanel.i18n.OBJECT_TREE;
    }

    @Override
    public String getHint() {
        return ObjectTreepropsPanel.i18n.OBJECT_TREE;
    }

    @Override
    public void applyChanges() {
        this._myPanel.applyChanges(this._props);
    }

    public void setObjectTreeRefreshNeeded(boolean objectTreeRefreshNeeded) {
        _objectTreeRefreshNeeded = objectTreeRefreshNeeded;
    }

    public boolean isObjectTreeRefreshNeeded() {
        return _objectTreeRefreshNeeded;
    }

    private static final class ObjectTreepropsPanel
    extends JPanel {
        private IntegerField _contentsNbrRowsToShowField = new IntegerField(5);
        private JCheckBox _contentsLimitRowsChk = new JCheckBox(i18n.LIMIT_ROWS_CONTENTS);
        private JCheckBox _showRowCountChk = new JCheckBox(i18n.SHOW_ROW_COUNT);
        private JTextField _catalogFilterInclude = new JTextField();
        private JTextField _catalogFilterExclude = new JTextField();
        private JTextField _schemaFilterInclude = new JTextField();
        private JTextField _schemaFilterExclude = new JTextField();
        private JTextField _objectFilterInclude = new JTextField();
        private JTextField _objectFilterExclude = new JTextField();
        private JCheckBox _loadSchemasCatalogsChk = new JCheckBox(SessionObjectTreePropertiesPanel.access$000().getString("sessionPropertiesPanel.loadSchemasCatalogs"));
        private final ControlMediator _controlMediator = new ControlMediator();

        ObjectTreepropsPanel(IApplication app) {
            this.createGUI();
        }

        void loadData(SessionProperties props) {
            this._contentsNbrRowsToShowField.setInt(props.getContentsNbrRowsToShow());
            this._contentsLimitRowsChk.setSelected(props.getContentsLimitRows());
            this._showRowCountChk.setSelected(props.getShowRowCount());
            this._loadSchemasCatalogsChk.setSelected(props.getLoadSchemasCatalogs());
            this._catalogFilterInclude.setText(props.getCatalogFilterInclude());
            this._schemaFilterInclude.setText(props.getSchemaFilterInclude());
            this._objectFilterInclude.setText(props.getObjectFilterInclude());
            this._catalogFilterExclude.setText(props.getCatalogFilterExclude());
            this._schemaFilterExclude.setText(props.getSchemaFilterExclude());
            this._objectFilterExclude.setText(props.getObjectFilterExclude());
            this.updateControlStatus();
        }

        void applyChanges(SessionProperties props) {
            props.setContentsNbrRowsToShow(this._contentsNbrRowsToShowField.getInt());
            props.setContentsLimitRows(this._contentsLimitRowsChk.isSelected());
            boolean oldShowRowCount = props.getShowRowCount();
            boolean newShowRowCount = this._showRowCountChk.isSelected();
            props.setShowRowCount(newShowRowCount);
            boolean oldLoadSchemasCatalogs = props.getLoadSchemasCatalogs();
            boolean newLoadSchemasCatalogs = this._loadSchemasCatalogsChk.isSelected();
            props.setLoadSchemasCatalogs(newLoadSchemasCatalogs);
            String oldSchemaFilterInclude = props.getSchemaFilterInclude();
            String oldCatalogFilterInclude = props.getCatalogFilterInclude();
            String oldObjectFilterInclude = props.getObjectFilterInclude();
            String oldSchemaFilterExclude = props.getSchemaFilterInclude();
            String oldCatalogFilterExclude = props.getCatalogFilterInclude();
            String oldObjectFilterExclude = props.getObjectFilterInclude();
            String newSchemaFilterInclude = this._schemaFilterInclude.getText();
            String newCatalogFilterInclude = this._catalogFilterInclude.getText();
            String newObjectFilterInclude = this._objectFilterInclude.getText();
            String newSchemaFilterExclude = this._schemaFilterExclude.getText();
            String newCatalogFilterExclude = this._catalogFilterExclude.getText();
            String newObjectFilterExclude = this._objectFilterExclude.getText();
            props.setCatalogFilterInclude(newCatalogFilterInclude);
            props.setSchemaFilterInclude(newSchemaFilterInclude);
            props.setObjectFilterInclude(newObjectFilterInclude);
            props.setCatalogFilterExclude(newCatalogFilterExclude);
            props.setSchemaFilterExclude(newSchemaFilterExclude);
            props.setObjectFilterExclude(newObjectFilterExclude);
            _objectTreeRefreshNeeded = false;
            if (!(oldLoadSchemasCatalogs == newLoadSchemasCatalogs && oldShowRowCount == newShowRowCount && StringUtils.equals(oldCatalogFilterInclude, newCatalogFilterInclude) && StringUtils.equals(oldSchemaFilterInclude, newSchemaFilterInclude) && StringUtils.equals(oldObjectFilterInclude, newObjectFilterInclude) && StringUtils.equals(oldCatalogFilterExclude, newCatalogFilterExclude) && StringUtils.equals(oldSchemaFilterExclude, newSchemaFilterExclude) && StringUtils.equals(oldObjectFilterExclude, newObjectFilterExclude))) {
                _objectTreeRefreshNeeded = true;
            }
        }

        private void updateControlStatus() {
            this._contentsNbrRowsToShowField.setEnabled(this._contentsLimitRowsChk.isSelected());
        }

        private void createGUI() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(4, 4, 4, 4), 0, 0);
            this.add((Component)this.createObjectTreePanel(), gbc);
            gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(4, 4, 4, 4), 0, 0);
            this.add((Component)this.createFilterPanel(), gbc);
            gbc = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(4, 4, 4, 4), 0, 0);
            this.add((Component)new JPanel(), gbc);
        }

        private JPanel createObjectTreePanel() {
            JPanel pnl = new JPanel(new GridBagLayout());
            pnl.setBorder(BorderFactory.createTitledBorder(i18n.OBJECT_TREE));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.anchor = 10;
            this._contentsLimitRowsChk.addChangeListener(this._controlMediator);
            this._contentsNbrRowsToShowField.setColumns(5);
            gbc.gridwidth = 0;
            gbc.gridx = 0;
            gbc.gridy = 0;
            pnl.add((Component)this._loadSchemasCatalogsChk, gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            pnl.add((Component)this._showRowCountChk, gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 2;
            pnl.add((Component)this._contentsLimitRowsChk, gbc);
            gbc.gridwidth = 1;
            gbc.gridx += 2;
            pnl.add((Component)this._contentsNbrRowsToShowField, gbc);
            ++gbc.gridx;
            gbc.gridwidth = 0;
            pnl.add((Component)new JLabel(s_stringMgr.getString("generalPropertiesPanel.rows")), gbc);
            return pnl;
        }

        private JPanel createFilterPanel() {
            JPanel pnl = new JPanel(new GridBagLayout());
            pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("sessionObjectTreePropetiesPanel.filters")));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.weightx = 1.0;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(4, 4, 4, 4);
            pnl.add((Component)new MultipleLineLabel(s_stringMgr.getString("SessionObjectTreePropertiesPanel.filterNote")), gbc);
            ++gbc.gridy;
            pnl.add((Component)this.createIncludeExcludePanel(), gbc);
            return pnl;
        }

        private JPanel createIncludeExcludePanel() {
            JPanel pnl = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 0, 4), 0, 0);
            pnl.add((Component)new JLabel(s_stringMgr.getString("SessionObjectTreePropertiesPanel.catalogInclude")), gbc);
            gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 0, 4), 0, 0);
            pnl.add((Component)new JLabel(s_stringMgr.getString("SessionObjectTreePropertiesPanel.catalogExclude")), gbc);
            gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(4, 4, 4, 4), 0, 0);
            pnl.add((Component)this._catalogFilterInclude, gbc);
            gbc = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(4, 4, 4, 4), 0, 0);
            pnl.add((Component)this._catalogFilterExclude, gbc);
            gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 0, 4), 0, 0);
            pnl.add((Component)new JLabel(s_stringMgr.getString("SessionObjectTreePropertiesPanel.schemaInclude")), gbc);
            gbc = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 0, 4), 0, 0);
            pnl.add((Component)new JLabel(s_stringMgr.getString("SessionObjectTreePropertiesPanel.schemaExclude")), gbc);
            gbc = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(4, 4, 4, 4), 0, 0);
            pnl.add((Component)this._schemaFilterInclude, gbc);
            gbc = new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(4, 4, 4, 4), 0, 0);
            pnl.add((Component)this._schemaFilterExclude, gbc);
            gbc = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 0, 4), 0, 0);
            pnl.add((Component)new JLabel(s_stringMgr.getString("SessionObjectTreePropertiesPanel.objectInclude")), gbc);
            gbc = new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 0, 4), 0, 0);
            pnl.add((Component)new JLabel(s_stringMgr.getString("SessionObjectTreePropertiesPanel.objectExclude")), gbc);
            gbc = new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 2, new Insets(4, 4, 4, 4), 0, 0);
            pnl.add((Component)this._objectFilterInclude, gbc);
            gbc = new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 18, 2, new Insets(4, 4, 4, 4), 0, 0);
            pnl.add((Component)this._objectFilterExclude, gbc);
            gbc = new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 18, 1, new Insets(4, 4, 4, 4), 0, 0);
            pnl.add((Component)new JPanel(), gbc);
            gbc = new GridBagConstraints(1, 6, 1, 1, 1.0, 1.0, 18, 1, new Insets(4, 4, 4, 4), 0, 0);
            pnl.add((Component)new JPanel(), gbc);
            return pnl;
        }

        private final class ControlMediator
        implements ChangeListener,
        ActionListener {
            private ControlMediator() {
            }

            @Override
            public void stateChanged(ChangeEvent evt) {
                ObjectTreepropsPanel.this.updateControlStatus();
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                ObjectTreepropsPanel.this.updateControlStatus();
            }
        }

        static interface i18n {
            public static final String CATALOG_PREFIX = SessionObjectTreePropertiesPanel.access$000().getString("sessionPropertiesPanel.catalogPrefix");
            public static final String LIMIT_ROWS_CONTENTS = SessionObjectTreePropertiesPanel.access$000().getString("sessionPropertiesPanel.limitRowsContents");
            public static final String SCHEMA_PREFIX = SessionObjectTreePropertiesPanel.access$000().getString("sessionPropertiesPanel.schemaPrefix");
            public static final String SHOW_ROW_COUNT = SessionObjectTreePropertiesPanel.access$000().getString("sessionPropertiesPanel.showRowCount");
            public static final String OBJECT_TREE = SessionObjectTreePropertiesPanel.access$000().getString("sessionPropertiesPanel.objectTree");
        }
    }
}

