/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.update;

import javax.swing.JFrame;
import javax.swing.ProgressMonitor;
import net.sourceforge.squirrel_sql.client.update.UpdateController;
import net.sourceforge.squirrel_sql.client.update.downloader.ArtifactDownloader;
import net.sourceforge.squirrel_sql.client.update.downloader.event.DownloadEventType;
import net.sourceforge.squirrel_sql.client.update.downloader.event.DownloadStatusEvent;
import net.sourceforge.squirrel_sql.client.update.downloader.event.DownloadStatusListener;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DownloadStatusEventHandler
implements DownloadStatusListener {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DownloadStatusEventHandler.class);
    private static final ILogger s_log = LoggerController.createLogger(DownloadStatusEventHandler.class);
    ProgressMonitor progressMonitor = null;
    int currentFile = 0;
    int totalFiles = 0;
    private ArtifactDownloader downloader = null;
    private UpdateController controller = null;

    public DownloadStatusEventHandler(UpdateController controller) {
        this.controller = controller;
    }

    public void setDownloader(ArtifactDownloader downloader) {
        this.downloader = downloader;
    }

    @Override
    public void handleDownloadStatusEvent(DownloadStatusEvent evt) {
        this.logDebug("handleDownloadStatusEvent: processing event: " + evt);
        if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
            this.downloader.stopDownload();
            return;
        }
        if (evt.getType() == DownloadEventType.DOWNLOAD_STARTED) {
            this.totalFiles = evt.getFileCountTotal();
            this.currentFile = 0;
            this.handleDownloadStarted();
        }
        if (evt.getType() == DownloadEventType.DOWNLOAD_FILE_STARTED) {
            this.setNote(i18n.FILE_LABEL + ": " + evt.getFilename());
        }
        if (evt.getType() == DownloadEventType.DOWNLOAD_FILE_COMPLETED) {
            this.setProgress(++this.currentFile);
        }
        if (evt.getType() == DownloadEventType.DOWNLOAD_STOPPED) {
            this.setProgress(this.totalFiles);
        }
        if (evt.getType() == DownloadEventType.DOWNLOAD_COMPLETED) {
            this.controller.showMessage(i18n.CHANGES_RECORDED_TITLE, i18n.CHANGES_RECORDED_MSG);
            this.setProgress(this.totalFiles);
        }
        if (evt.getType() == DownloadEventType.DOWNLOAD_FAILED) {
            this.controller.showErrorMessage(i18n.UPDATE_DOWNLOAD_FAILED_TITLE, i18n.UPDATE_DOWNLOAD_FAILED_MSG);
            this.setProgress(this.totalFiles);
        }
    }

    private void setProgress(final int value) {
        this.logDebug("setProgress: value=", value);
        GUIUtils.processOnSwingEventThread(new Runnable(){

            @Override
            public void run() {
                DownloadStatusEventHandler.this.progressMonitor.setProgress(value);
            }
        });
    }

    private void setNote(final String note) {
        this.logDebug("setNote: value=", note);
        GUIUtils.processOnSwingEventThread(new Runnable(){

            @Override
            public void run() {
                DownloadStatusEventHandler.this.progressMonitor.setNote(note);
            }
        });
    }

    private void handleDownloadStarted() {
        this.logDebug("handleDownloadStarted: launching progress monitor");
        GUIUtils.processOnSwingEventThread(new Runnable(){

            @Override
            public void run() {
                JFrame frame = DownloadStatusEventHandler.this.controller.getMainFrame();
                DownloadStatusEventHandler.this.progressMonitor = new ProgressMonitor(frame, i18n.DOWNLOADING_UPDATES_MSG, i18n.DOWNLOADING_UPDATES_MSG, 0, DownloadStatusEventHandler.this.totalFiles);
                DownloadStatusEventHandler.this.setProgress(0);
            }
        });
    }

    private void logDebug(Object ... msgs) {
        StringBuilder tmp = new StringBuilder();
        for (Object msg : msgs) {
            tmp.append(msg.toString());
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug(tmp.toString());
        }
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private static interface i18n {
        public static final String DOWNLOADING_UPDATES_MSG = DownloadStatusEventHandler.access$000().getString("DownloadStatusEventHandler.downloadingUpdatesMsg");
        public static final String CHANGES_RECORDED_TITLE = DownloadStatusEventHandler.access$000().getString("DownloadStatusEventHandler.changesRecordedTitle");
        public static final String CHANGES_RECORDED_MSG = DownloadStatusEventHandler.access$000().getString("DownloadStatusEventHandler.changesRecordedMsg");
        public static final String UPDATE_DOWNLOAD_FAILED_TITLE = DownloadStatusEventHandler.access$000().getString("DownloadStatusEventHandler.updateDownloadFailedTitle");
        public static final String UPDATE_DOWNLOAD_FAILED_MSG = DownloadStatusEventHandler.access$000().getString("DownloadStatusEventHandler.updateDownloadFailedMsg");
        public static final String FILE_LABEL = DownloadStatusEventHandler.access$000().getString("DownloadStatusEventHandler.fileLabel");
    }
}

