/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.update.async;

import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.preferences.IUpdateSettings;
import net.sourceforge.squirrel_sql.client.update.UpdateUtil;
import net.sourceforge.squirrel_sql.client.update.async.UpdateCheckRunnableCallback;
import net.sourceforge.squirrel_sql.client.update.xmlbeans.ChannelXmlBean;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ReleaseFileUpdateCheckTask
implements Runnable {
    private static final ILogger s_log = LoggerController.createLogger(ReleaseFileUpdateCheckTask.class);
    private UpdateCheckRunnableCallback _callback = null;
    private IUpdateSettings _settings = null;
    private UpdateUtil _util = null;
    private IApplication _app = null;
    private boolean isUpToDate = false;

    public ReleaseFileUpdateCheckTask(UpdateCheckRunnableCallback callback, IUpdateSettings settings, UpdateUtil util, IApplication app) {
        Utilities.checkNull("ReleaseFileUpdateCheckRunnable", "settings", settings, "util", util, "app", app);
        this._callback = callback;
        this._settings = settings;
        this._util = util;
        this._app = app;
    }

    public void start() {
        if (this._app == null) {
            throw new IllegalStateException("_app was null - cannot access the thread pool for asynchronous use");
        }
        this._app.getThreadPool().addTask(this);
    }

    @Override
    public void run() {
        String releaseFilename = null;
        try {
            releaseFilename = this._util.getLocalReleaseFile().getAbsolutePath();
        }
        catch (Exception e) {
            s_log.error("Unexpected exception while attempting to find local release file: " + e.getMessage(), e);
            if (this._callback != null) {
                this._callback.updateCheckFailed(e);
            }
            return;
        }
        ChannelXmlBean installedChannelBean = this._util.getLocalReleaseInfo(releaseFilename);
        ChannelXmlBean currentChannelBean = this.getCurrentChannelXmlBean(installedChannelBean);
        this._settings.setLastUpdateCheckTimeMillis("" + System.currentTimeMillis());
        this._app.getSquirrelPreferences().setUpdateSettings(this._settings);
        if (currentChannelBean == null) {
            s_log.warn("run: currentChannelBean was null - it is inconclusive whether or not the software is current : assuming that it is for now");
            if (this._callback != null) {
                this._callback.updateCheckFailed(null);
            }
        } else {
            this.isUpToDate = currentChannelBean.equals(installedChannelBean);
            if (this._callback != null) {
                this._callback.updateCheckComplete(this.isUpToDate, installedChannelBean, currentChannelBean);
            }
        }
    }

    private ChannelXmlBean getCurrentChannelXmlBean(ChannelXmlBean installedChannelBean) {
        ChannelXmlBean currentChannelBean = null;
        if (this._settings.isRemoteUpdateSite()) {
            String channelName = this.getDesiredChannel(this._settings, installedChannelBean);
            try {
                StringBuilder releasePath = new StringBuilder("/");
                releasePath.append(this._settings.getUpdateServerPath());
                releasePath.append("/");
                releasePath.append(channelName);
                releasePath.append("/");
                currentChannelBean = this._util.downloadCurrentRelease(this._settings.getUpdateServer(), Integer.parseInt(this._settings.getUpdateServerPort()), releasePath.toString(), "release.xml", this._app.getSquirrelPreferences().getProxySettings());
            }
            catch (Exception e) {
                s_log.error("Unexpected exception: " + e.getMessage(), e);
            }
        } else {
            currentChannelBean = this._util.loadUpdateFromFileSystem(this._settings.getFileSystemUpdatePath());
        }
        return currentChannelBean;
    }

    private String getDesiredChannel(IUpdateSettings settings, ChannelXmlBean _installedChannelBean) {
        String desiredChannel = settings.getUpdateServerChannel().toLowerCase();
        String currentChannelName = _installedChannelBean.getName();
        if (!currentChannelName.equals(desiredChannel) && s_log.isInfoEnabled()) {
            s_log.info("getDesiredChannel: User is switching distribution channel from installed channel (" + currentChannelName + ") to new channel (" + desiredChannel + ")");
        }
        return desiredChannel;
    }

    public boolean isUpToDate() {
        return this.isUpToDate;
    }
}

