/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.update.autocheck;

import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.preferences.IUpdateSettings;
import net.sourceforge.squirrel_sql.client.update.UpdateCheckFrequency;
import net.sourceforge.squirrel_sql.client.update.UpdateController;
import net.sourceforge.squirrel_sql.client.update.UpdateControllerFactory;
import net.sourceforge.squirrel_sql.client.update.UpdateControllerFactoryImpl;
import net.sourceforge.squirrel_sql.client.update.UpdateUtil;
import net.sourceforge.squirrel_sql.client.update.UpdateUtilImpl;
import net.sourceforge.squirrel_sql.client.update.async.ReleaseFileUpdateCheckTask;
import net.sourceforge.squirrel_sql.client.update.autocheck.UpdateCheckTimer;
import net.sourceforge.squirrel_sql.client.update.downloader.ArtifactDownloaderFactoryImpl;
import net.sourceforge.squirrel_sql.fw.gui.JOptionPaneService;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactory;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactoryImpl;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class UpdateCheckTimerImpl
implements UpdateCheckTimer {
    private UpdateCheckRunnable runnable = new UpdateCheckRunnable();
    private UpdateControllerFactory updateControllerFactory = new UpdateControllerFactoryImpl();
    private UpdateController updateController = null;
    private IApplication _app = null;
    private IUpdateSettings _updateSettings = null;
    private static final ILogger s_log = LoggerController.createLogger(UpdateCheckTimerImpl.class);
    private UpdateUtil _util = new UpdateUtilImpl();
    private JOptionPaneService _JOptionPaneService = new JOptionPaneService();
    private FileWrapperFactory _fileWrapperFactory = new FileWrapperFactoryImpl();

    public UpdateCheckTimerImpl(IApplication app) {
        this._app = app;
        this._updateSettings = this._app.getSquirrelPreferences().getUpdateSettings();
    }

    @Override
    public void start() {
        if (!this._updateSettings.isEnableAutomaticUpdates()) {
            return;
        }
        this.updateController = this.updateControllerFactory.createUpdateController(this._app, new ArtifactDownloaderFactoryImpl(), this._util, this._JOptionPaneService, this._fileWrapperFactory);
        Thread t = new Thread(this.runnable);
        t.setName("Update Check Timer Thread");
        t.start();
    }

    @Override
    public void stop() {
        if (!this._updateSettings.isEnableAutomaticUpdates()) {
            return;
        }
        this.runnable.stop();
    }

    private class UpdateCheckRunnable
    implements Runnable {
        private boolean stopped = false;
        private boolean firstCheck = true;

        private UpdateCheckRunnable() {
        }

        @Override
        public void run() {
            Utilities.sleep(120000L);
            while (!this.stopped) {
                if (this.firstCheck) {
                    this.firstCheck = false;
                    if (this.isUpdateCheckFrequencyAtStartup() && !this.isUpToDate()) {
                        this.logDebug("run: update check configured for startup and software is not up-to-date");
                        UpdateCheckTimerImpl.this.updateController.promptUserToDownloadAvailableUpdates();
                        return;
                    }
                } else {
                    this.logDebug("run: not the first check; sleeping for an hour.");
                    this.sleepForAnHour();
                }
                if (this.isUpdateCheckFrequencyAtStartup() || !UpdateCheckTimerImpl.this.updateController.isTimeToCheckForUpdates()) continue;
                this.logDebug("run: not configured to check at startup and it's now time to check again.");
                if (this.isUpToDate()) continue;
                this.logDebug("run: software is not up-to-date, so prompting user to download updates.");
                UpdateCheckTimerImpl.this.updateController.promptUserToDownloadAvailableUpdates();
            }
        }

        private void logDebug(String msg) {
            if (s_log.isDebugEnabled()) {
                s_log.debug(msg);
            }
        }

        private boolean isUpToDate() {
            boolean result = true;
            try {
                this.logDebug("isUpToDate: checking to see if software is up-to-date; currentTimeMillis = " + System.currentTimeMillis());
                ReleaseFileUpdateCheckTask task = new ReleaseFileUpdateCheckTask(null, UpdateCheckTimerImpl.this._updateSettings, UpdateCheckTimerImpl.this._util, UpdateCheckTimerImpl.this._app);
                task.run();
                result = task.isUpToDate();
            }
            catch (Exception e) {
                s_log.error("isUpToDate: Unable to determine up-to-date status: " + e.getMessage(), e);
            }
            return result;
        }

        private boolean isUpdateCheckFrequencyAtStartup() {
            String freqStr = UpdateCheckTimerImpl.this._updateSettings.getUpdateCheckFrequency();
            UpdateCheckFrequency updateCheckFrequency = UpdateCheckFrequency.getEnumForString(freqStr);
            return updateCheckFrequency == UpdateCheckFrequency.STARTUP;
        }

        public void stop() {
            this.stopped = true;
        }

        private void sleepForAnHour() {
            Utilities.sleep(3600000L);
        }
    }
}

