/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.update.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import net.sourceforge.squirrel_sql.client.update.gui.ArtifactAction;
import net.sourceforge.squirrel_sql.client.update.gui.ArtifactStatus;
import net.sourceforge.squirrel_sql.client.update.gui.UpdateSummaryTableModel;
import net.sourceforge.squirrel_sql.fw.gui.SortableTable;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class UpdateSummaryTable
extends SortableTable {
    private static final long serialVersionUID = 1L;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(UpdateSummaryTable.class);
    private List<ArtifactStatus> _artifacts = null;
    private boolean _releaseVersionWillChange = false;
    private UpdateSummaryTableModel _model = null;

    public UpdateSummaryTable(List<ArtifactStatus> artifactStatus, UpdateSummaryTableModel model) {
        super(model);
        this._model = model;
        this._artifacts = artifactStatus;
        this.setSelectionMode(1);
        this.getTableHeader().setResizingAllowed(true);
        this.getTableHeader().setReorderingAllowed(true);
        this.setAutoCreateColumnsFromModel(false);
        this.setAutoResizeMode(3);
        DefaultTableColumnModel tcm = new DefaultTableColumnModel();
        JComboBox _actionComboBox = new JComboBox();
        for (int i = 0; i < model.getColumnCount(); ++i) {
            TableColumn col = new TableColumn(i, model.getColumnWidth(i));
            col.setHeaderValue(model.getColumnName(i));
            if (i == 3) {
                col.setCellEditor(new DefaultCellEditor(this.initCbo(_actionComboBox)));
            }
            tcm.addColumn(col);
        }
        this.setColumnModel(tcm);
        this.initPopup();
    }

    public List<ArtifactStatus> getUserRequestedChanges() {
        ArrayList<ArtifactStatus> changes = new ArrayList<ArtifactStatus>();
        for (ArtifactStatus artifactStatus : this._artifacts) {
            if (artifactStatus.getArtifactAction() == ArtifactAction.NONE) continue;
            changes.add(artifactStatus);
        }
        return changes;
    }

    public void setReleaseVersionWillChange(boolean releaseVersionWillChange) {
        Iterator<ArtifactStatus> i = this._artifacts.iterator();
        this._releaseVersionWillChange = releaseVersionWillChange;
        if (releaseVersionWillChange) {
            while (i.hasNext()) {
                ArtifactStatus status = i.next();
                if (!status.isInstalled()) continue;
                status.setArtifactAction(ArtifactAction.INSTALL);
            }
        } else {
            while (i.hasNext()) {
                ArtifactStatus status = i.next();
                if (!status.isCoreArtifact()) continue;
                i.remove();
            }
        }
    }

    public boolean getReleaseVersionWillChange() {
        return this._releaseVersionWillChange;
    }

    private void initPopup() {
        final JPopupMenu popup = new JPopupMenu(i18n.INSTALL_OPTIONS_LABEL);
        JMenuItem pluginItem = new JMenuItem(i18n.ALL_PLUGINS_LABEL);
        pluginItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ArtifactStatus status : UpdateSummaryTable.this._artifacts) {
                    if (!status.isPluginArtifact()) continue;
                    status.setArtifactAction(ArtifactAction.INSTALL);
                }
                UpdateSummaryTable.this._model.fireTableDataChanged();
            }
        });
        JMenuItem translationItem = new JMenuItem(i18n.ALL_TRANSLATIONS_LABEL);
        translationItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ArtifactStatus status : UpdateSummaryTable.this._artifacts) {
                    if (!status.isTranslationArtifact()) continue;
                    status.setArtifactAction(ArtifactAction.INSTALL);
                }
                UpdateSummaryTable.this._model.fireTableDataChanged();
            }
        });
        popup.add(pluginItem);
        popup.add(translationItem);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                if (popup.isPopupTrigger(event)) {
                    popup.show(event.getComponent(), event.getX(), event.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                if (popup.isPopupTrigger(event)) {
                    popup.show(event.getComponent(), event.getX(), event.getY());
                }
            }
        });
    }

    private JComboBox initCbo(JComboBox cbo) {
        cbo.setEditable(false);
        this.setModel(cbo, ArtifactAction.NONE, ArtifactAction.INSTALL, ArtifactAction.REMOVE);
        cbo.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                JComboBox source = (JComboBox)e.getSource();
                UpdateSummaryTable.this.updateDataModel(source);
            }
        });
        return cbo;
    }

    private void updateDataModel(JComboBox source) {
        int row = this.getEditingRow();
        if (row == -1) {
            return;
        }
        ArtifactStatus as = this._artifacts.get(row);
        boolean installed = as.isInstalled();
        if (as.isCoreArtifact()) {
            if (this._releaseVersionWillChange) {
                source.setModel(this.getComboBoxModel(ArtifactAction.INSTALL));
            }
        } else if (this._releaseVersionWillChange) {
            if (installed) {
                this.setModel(source, ArtifactAction.INSTALL, ArtifactAction.REMOVE);
            } else {
                this.setModel(source, ArtifactAction.NONE, ArtifactAction.INSTALL);
            }
        } else if (installed) {
            this.setModel(source, ArtifactAction.NONE, ArtifactAction.REMOVE);
        } else {
            this.setModel(source, ArtifactAction.NONE, ArtifactAction.INSTALL);
        }
    }

    private void setModel(JComboBox box, ArtifactAction ... actions) {
        ComboBoxModel oldModel = box.getModel();
        box.setModel(this.getComboBoxModel(actions));
        if (oldModel.getSize() != actions.length) {
            box.firePropertyChange("itemCount", oldModel.getSize(), actions.length);
        }
    }

    private ComboBoxModel getComboBoxModel(ArtifactAction ... actions) {
        DefaultComboBoxModel<ArtifactAction> result = new DefaultComboBoxModel<ArtifactAction>(actions);
        result.setSelectedItem(actions[0]);
        return result;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private static interface i18n {
        public static final String ALL_TRANSLATIONS_LABEL = UpdateSummaryTable.access$000().getString("UpdateSummaryTable.allTranslationsLabel");
        public static final String ALL_PLUGINS_LABEL = UpdateSummaryTable.access$000().getString("UpdateSummaryTable.allPluginsLabel");
        public static final String INSTALL_OPTIONS_LABEL = UpdateSummaryTable.access$000().getString("UpdateSummaryTable.installOptionsLabel");
    }
}

