/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.update.gui.installer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.update.UpdateUtil;
import net.sourceforge.squirrel_sql.client.update.gui.ArtifactAction;
import net.sourceforge.squirrel_sql.client.update.gui.ArtifactStatus;
import net.sourceforge.squirrel_sql.client.update.gui.installer.ArtifactInstaller;
import net.sourceforge.squirrel_sql.client.update.gui.installer.event.InstallEventType;
import net.sourceforge.squirrel_sql.client.update.gui.installer.event.InstallStatusEvent;
import net.sourceforge.squirrel_sql.client.update.gui.installer.event.InstallStatusEventFactory;
import net.sourceforge.squirrel_sql.client.update.gui.installer.event.InstallStatusListener;
import net.sourceforge.squirrel_sql.client.update.gui.installer.util.InstallFileOperationInfo;
import net.sourceforge.squirrel_sql.client.update.gui.installer.util.InstallFileOperationInfoFactory;
import net.sourceforge.squirrel_sql.client.update.xmlbeans.ChangeListXmlBean;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ArtifactInstallerImpl
implements ArtifactInstaller {
    private static ILogger s_log = LoggerController.createLogger(ArtifactInstallerImpl.class);
    private List<ArtifactStatus> _changeList = null;
    private List<InstallStatusListener> _listeners = new ArrayList<InstallStatusListener>();
    private FileWrapper updateDir = null;
    private FileWrapper downloadsRootDir = null;
    private FileWrapper coreDownloadsDir = null;
    private FileWrapper pluginDownloadsDir = null;
    private FileWrapper i18nDownloadsDir = null;
    private FileWrapper backupRootDir = null;
    private FileWrapper coreBackupDir = null;
    private FileWrapper pluginBackupDir = null;
    private FileWrapper translationBackupDir = null;
    private FileWrapper installRootDir = null;
    private FileWrapper coreInstallDir = null;
    private FileWrapper pluginInstallDir = null;
    private FileWrapper i18nInstallDir = null;
    private FileWrapper changeListFile = null;
    private InstallStatusEventFactory installStatusEventFactory = null;
    private InstallFileOperationInfoFactory installFileOperationInfoFactory = null;
    private UpdateUtil _util = null;

    public void setInstallStatusEventFactory(InstallStatusEventFactory installStatusEventFactory) {
        this.installStatusEventFactory = installStatusEventFactory;
    }

    public void setInstallFileOperationInfoFactory(InstallFileOperationInfoFactory installFileOperationInfoFactory) {
        this.installFileOperationInfoFactory = installFileOperationInfoFactory;
    }

    public void setUpdateUtil(UpdateUtil util) {
        this._util = util;
        this.updateDir = this._util.getSquirrelUpdateDir();
        this.backupRootDir = this._util.checkDir(this.updateDir, "backup");
        this.downloadsRootDir = this._util.checkDir(this.updateDir, "downloads");
        this.coreBackupDir = this._util.checkDir(this.backupRootDir, "core");
        this.pluginBackupDir = this._util.checkDir(this.backupRootDir, "plugin");
        this.translationBackupDir = this._util.checkDir(this.backupRootDir, "i18n");
        this.installRootDir = this._util.getSquirrelHomeDir();
        this.coreInstallDir = this._util.getSquirrelLibraryDir();
        this.pluginInstallDir = this._util.getSquirrelPluginsDir();
        this.i18nInstallDir = this._util.getSquirrelLibraryDir();
        this.coreDownloadsDir = this._util.getCoreDownloadsDir();
        this.pluginDownloadsDir = this._util.getPluginDownloadsDir();
        this.i18nDownloadsDir = this._util.getI18nDownloadsDir();
    }

    @Override
    public void setChangeList(ChangeListXmlBean changeList) throws FileNotFoundException {
        this._changeList = this.initializeChangeList(changeList);
    }

    @Override
    public FileWrapper getChangeListFile() {
        return this.changeListFile;
    }

    @Override
    public void setChangeListFile(FileWrapper changeListFile) {
        this.changeListFile = changeListFile;
    }

    @Override
    public void addListener(InstallStatusListener listener) {
        this._listeners.add(listener);
    }

    @Override
    public boolean backupFiles() throws FileNotFoundException, IOException {
        boolean result = true;
        this.sendBackupStarted(this._changeList.size());
        FileWrapper localReleaseFile = this._util.getLocalReleaseFile();
        this._util.copyFile(localReleaseFile, this._util.getBackupDir());
        for (ArtifactStatus status : this._changeList) {
            String artifactName = status.getName();
            this.sendFileBackupStarted(artifactName);
            if (!status.isInstalled()) {
                if (s_log.isInfoEnabled()) {
                    s_log.info("Skipping backup of artifact (" + status + ") which isn't installed.");
                }
                this.sendFileBackupComplete(artifactName);
                continue;
            }
            if (status.isCoreArtifact()) {
                FileWrapper installDir = this.getCoreArtifactLocation(artifactName, this.installRootDir, this.coreInstallDir);
                FileWrapper coreFile = this._util.getFile(installDir, artifactName);
                FileWrapper backupFile = this._util.getFile(this.coreBackupDir, artifactName);
                this._util.copyFile(coreFile, backupFile);
            }
            if (status.isPluginArtifact()) {
                FileWrapper pluginJarFile;
                FileWrapper pluginBackupFile = this._util.getFile(this.pluginBackupDir, artifactName);
                String pluginDirectory = artifactName.replace(".zip", "");
                String pluginJarFilename = artifactName.replace(".zip", ".jar");
                ArrayList<FileWrapper> filesToZip = new ArrayList<FileWrapper>();
                FileWrapper pluginDirectoryFile = this._util.getFile(this.pluginInstallDir, pluginDirectory);
                if (pluginDirectoryFile.exists()) {
                    filesToZip.add(pluginDirectoryFile);
                }
                if ((pluginJarFile = this._util.getFile(this.pluginInstallDir, pluginJarFilename)).exists()) {
                    filesToZip.add(pluginJarFile);
                }
                if (filesToZip.size() > 0) {
                    this._util.createZipFile(pluginBackupFile, filesToZip.toArray(new FileWrapper[filesToZip.size()]));
                } else {
                    s_log.error("Plugin (" + status.getName() + ") was listed as already installed, but it's " + "files didn't exist and couldn't be backed up: pluginDirectoryFile=" + pluginDirectoryFile.getAbsolutePath() + " pluginJarFile=" + pluginJarFile.getAbsolutePath());
                }
            }
            if (status.isTranslationArtifact()) {
                FileWrapper translationFile = this._util.getFile(this.i18nInstallDir, artifactName);
                FileWrapper backupFile = this._util.getFile(this.translationBackupDir, artifactName);
                if (translationFile.exists()) {
                    this._util.copyFile(translationFile, backupFile);
                }
            }
            this.breathing();
            this.sendFileBackupComplete(artifactName);
        }
        this.sendBackupComplete();
        return result;
    }

    @Override
    public void installFiles() throws IOException {
        ArrayList<FileWrapper> filesToRemove = new ArrayList<FileWrapper>();
        ArrayList<InstallFileOperationInfo> filesToInstall = new ArrayList<InstallFileOperationInfo>();
        for (ArtifactStatus status : this._changeList) {
            ArtifactAction action = status.getArtifactAction();
            FileWrapper installDir = null;
            FileWrapper fileToCopy = null;
            FileWrapper fileToRemove = null;
            String artifactName = status.getName();
            boolean isPlugin = false;
            if (status.isCoreArtifact()) {
                if (action == ArtifactAction.REMOVE) {
                    s_log.error("Skipping core artifact (" + status.getName() + ") that was marked for removal");
                    continue;
                }
                installDir = this.getCoreArtifactLocation(status.getName(), this.installRootDir, this.coreInstallDir);
                fileToCopy = this._util.getFile(this.coreDownloadsDir, artifactName);
                fileToRemove = "doc.zip".equals(status.getName()) ? this._util.getFile(installDir, artifactName.replace(".zip", "")) : this._util.getFile(installDir, artifactName);
                filesToRemove.add(fileToRemove);
            }
            if (status.isPluginArtifact()) {
                isPlugin = true;
                installDir = this.pluginInstallDir;
                if (action != ArtifactAction.REMOVE) {
                    fileToCopy = this._util.getFile(this.pluginDownloadsDir, artifactName);
                }
                String jarFileToRemove = artifactName.replace(".zip", ".jar");
                String pluginDirectoryToRemove = artifactName.replace(".zip", "");
                filesToRemove.add(this._util.getFile(installDir, jarFileToRemove));
                filesToRemove.add(this._util.getFile(installDir, pluginDirectoryToRemove));
            }
            if (status.isTranslationArtifact()) {
                installDir = this.i18nInstallDir;
                if (action != ArtifactAction.REMOVE) {
                    fileToCopy = this._util.getFile(this.i18nDownloadsDir, artifactName);
                }
                fileToRemove = this._util.getFile(installDir, artifactName);
                filesToRemove.add(fileToRemove);
            }
            if (fileToCopy == null) continue;
            InstallFileOperationInfo info = this.installFileOperationInfoFactory.create(fileToCopy, installDir);
            info.setPlugin(isPlugin);
            info.setArtifactName(artifactName);
            filesToInstall.add(info);
        }
        boolean success = this.removeOldFiles(filesToRemove);
        success = success && this.installFiles(filesToInstall);
        success = success && this.backupAndDeleteChangeListFile();
        boolean bl = success = success && this.installNewReleaseXmlFile();
        if (!success) {
            this.restoreFilesFromBackup(filesToInstall);
        }
        this.sendInstallComplete();
    }

    @Override
    public boolean restoreBackupFiles() throws FileNotFoundException, IOException {
        for (ArtifactStatus status : this._changeList) {
            String name = status.getName();
            FileWrapper backupDir = null;
            FileWrapper installDir = null;
            if (status.isCoreArtifact()) {
                backupDir = this.coreBackupDir;
                installDir = this.getCoreArtifactLocation(name, this.installRootDir, this.coreInstallDir);
            }
            if (status.isPluginArtifact()) {
                backupDir = this.pluginBackupDir;
                installDir = this.pluginInstallDir;
            }
            if (status.isTranslationArtifact()) {
                backupDir = this.translationBackupDir;
                installDir = this.coreInstallDir;
            }
            FileWrapper backupJarPath = this._util.getFile(backupDir, name);
            FileWrapper installJarPath = this._util.getFile(installDir, name);
            if (!this._util.deleteFile(installJarPath)) {
                return false;
            }
            this._util.copyFile(backupJarPath, installJarPath);
        }
        if (!this._util.deleteFile(this._util.getLocalReleaseFile())) {
            return false;
        }
        FileWrapper backupReleaseFile = this._util.getFile(this._util.getBackupDir(), "release.xml");
        this._util.copyFile(backupReleaseFile, this.updateDir);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void breathing() {
        if (SwingUtilities.isEventDispatchThread()) {
            if (s_log.isDebugEnabled()) {
                s_log.debug("breathing: ignoring request to sleep the event dispatch thread");
            }
            return;
        }
        ArtifactInstallerImpl artifactInstallerImpl = this;
        synchronized (artifactInstallerImpl) {
            block7: {
                try {
                    this.wait(50L);
                }
                catch (InterruptedException e) {
                    if (!s_log.isInfoEnabled()) break block7;
                    s_log.info("breathing: Interrupted", e);
                }
            }
        }
    }

    private List<ArtifactStatus> initializeChangeList(ChangeListXmlBean changeListBean) {
        this.sendInitChangelistStarted(changeListBean.getChanges().size());
        ArrayList<ArtifactStatus> result = new ArrayList<ArtifactStatus>();
        for (ArtifactStatus status : changeListBean.getChanges()) {
            String artifactName = status.getName();
            this.sendFileInitChangelistStarted(artifactName);
            if (status.isPluginArtifact()) {
                result.add(status);
                this.sendFileInitChangelistComplete(artifactName);
                continue;
            }
            if (status.getArtifactAction() == ArtifactAction.INSTALL) {
                long installedCheckSum;
                long installedSize;
                FileWrapper installedFileLocation = null;
                if (status.isCoreArtifact()) {
                    installedFileLocation = this._util.getFile(this.getCoreArtifactLocation(status.getName(), this.installRootDir, this.coreInstallDir), status.getName());
                }
                if (status.isTranslationArtifact()) {
                    installedFileLocation = this._util.getFile(this.coreInstallDir, status.getName());
                }
                if ((installedSize = installedFileLocation.length()) == status.getSize() && (installedCheckSum = this._util.getCheckSum(installedFileLocation)) == status.getChecksum()) {
                    if (s_log.isDebugEnabled()) {
                        s_log.debug("initializeChangeList: found a core/translation artifact that is not installed: installedSize= " + installedSize + " installedCheckSum=" + installedCheckSum + " statusSize=" + status.getSize() + " statusChecksum=" + status.getChecksum());
                    }
                    this.sendFileInitChangelistComplete(artifactName);
                    continue;
                }
            }
            result.add(status);
            this.sendFileInitChangelistComplete(artifactName);
        }
        this.sendInitChangelistComplete();
        return result;
    }

    private FileWrapper getCoreArtifactLocation(String artifactName, FileWrapper rootDir, FileWrapper coreDir) {
        if ("squirrel-sql.jar".equals(artifactName) || "doc.zip".equals(artifactName)) {
            return rootDir;
        }
        return coreDir;
    }

    private void restoreFilesFromBackup(List<InstallFileOperationInfo> filesToInstall) {
    }

    private boolean backupAndDeleteChangeListFile() {
        boolean result = true;
        if (this.changeListFile != null) {
            try {
                this._util.copyFile(this.changeListFile, this.backupRootDir);
                result = this._util.deleteFile(this.changeListFile);
            }
            catch (IOException e) {
                result = false;
                s_log.error("Unexpected exception: " + e.getMessage(), e);
            }
        } else if (s_log.isInfoEnabled()) {
            s_log.info("moveChangeListFile: Changelist file was null.  Skipping move");
        }
        return result;
    }

    private boolean installNewReleaseXmlFile() {
        boolean result;
        block5: {
            result = true;
            try {
                this._util.deleteFile(this._util.getLocalReleaseFile());
            }
            catch (FileNotFoundException e) {
                if (!s_log.isInfoEnabled()) break block5;
                s_log.info("installNewReleaseXmlFile: release file to be replaced was missing.");
            }
        }
        FileWrapper downloadReleaseFile = this._util.getFile(this.downloadsRootDir, "release.xml");
        try {
            this._util.copyFile(downloadReleaseFile, this.updateDir);
        }
        catch (FileNotFoundException e) {
            result = false;
            s_log.error("installNewReleaseXmlFile: unexpected exception - " + e.getMessage(), e);
        }
        catch (IOException e) {
            result = false;
            s_log.error("installNewReleaseXmlFile: unexpected exception - " + e.getMessage(), e);
        }
        return result;
    }

    private boolean removeOldFiles(List<FileWrapper> filesToRemove) {
        boolean result = true;
        this.sendRemoveStarted(filesToRemove.size());
        for (FileWrapper fileToRemove : filesToRemove) {
            this.sendFileRemoveStarted(fileToRemove.getName());
            result = this.removeOldFile(fileToRemove);
            if (!result) break;
            this.breathing();
            this.sendFileRemoveComplete(fileToRemove.getName());
        }
        this.sendRemoveComplete();
        return result;
    }

    private boolean removeOldFile(FileWrapper fileToRemove) {
        boolean result = true;
        String absolutePath = fileToRemove.getAbsolutePath();
        if (s_log.isDebugEnabled()) {
            s_log.debug("Examining file to remove: " + absolutePath);
        }
        if (fileToRemove.exists()) {
            try {
                if (s_log.isDebugEnabled()) {
                    s_log.debug("Attempting to delete file: " + absolutePath);
                }
                if (!(result = this._util.deleteFile(fileToRemove))) {
                    s_log.error("Delete operation failed for file/directory: " + absolutePath);
                }
            }
            catch (SecurityException e) {
                result = false;
                s_log.error("Unexpected security exception: " + e.getMessage());
            }
        } else if (s_log.isInfoEnabled()) {
            s_log.info("Skipping delete of file doesn't appear to exist: " + absolutePath);
        }
        return result;
    }

    private boolean installFiles(List<InstallFileOperationInfo> filesToInstall) throws IOException {
        this.sendInstallStarted(this._changeList.size());
        this.breathing();
        boolean result = true;
        for (InstallFileOperationInfo info : filesToInstall) {
            try {
                this.sendFileInstallStarted(info.getArtifactName());
                this.installFile(info);
                this.sendFileInstallComplete(info.getArtifactName());
            }
            catch (Exception e) {
                s_log.error("installFiles: unexpected exception: " + e.getMessage(), e);
                result = false;
                break;
            }
            this.breathing();
        }
        return result;
    }

    private void installFile(InstallFileOperationInfo info) throws IOException {
        FileWrapper installDir = info.getInstallDir();
        FileWrapper fileToCopy = info.getFileToInstall();
        if (fileToCopy.getAbsolutePath().endsWith(".zip")) {
            this._util.extractZipFile(fileToCopy, installDir);
        } else {
            this._util.copyFile(fileToCopy, installDir);
        }
    }

    private void sendInitChangelistStarted(int numFilesToBackup) {
        this.logInfo("Changelist initialization started");
        InstallStatusEvent evt = this.installStatusEventFactory.create(InstallEventType.INIT_CHANGELIST_STARTED);
        evt.setNumFilesToUpdate(numFilesToBackup);
        this.sendEvent(evt);
    }

    private void sendFileInitChangelistStarted(String artifactName) {
        this.logInfo("Changelist init started for file: " + artifactName);
        InstallStatusEvent evt = this.installStatusEventFactory.create(InstallEventType.FILE_INIT_CHANGELIST_STARTED);
        evt.setArtifactName(artifactName);
        this.sendEvent(evt);
    }

    private void sendFileInitChangelistComplete(String artifactName) {
        this.logInfo("Changelist init complete for file: " + artifactName);
        InstallStatusEvent evt = this.installStatusEventFactory.create(InstallEventType.FILE_INIT_CHANGELIST_COMPLETE);
        evt.setArtifactName(artifactName);
        this.sendEvent(evt);
    }

    private void sendInitChangelistComplete() {
        this.logInfo("Changelist initialization complete");
        InstallStatusEvent evt = this.installStatusEventFactory.create(InstallEventType.INIT_CHANGELIST_COMPLETE);
        this.sendEvent(evt);
    }

    private void sendBackupStarted(int numFilesToBackup) {
        this.logInfo("Backup started");
        InstallStatusEvent evt = this.installStatusEventFactory.create(InstallEventType.BACKUP_STARTED);
        evt.setNumFilesToUpdate(numFilesToBackup);
        this.sendEvent(evt);
    }

    private void sendFileBackupStarted(String artifactName) {
        this.logInfo("Backup started for file: " + artifactName);
        InstallStatusEvent evt = this.installStatusEventFactory.create(InstallEventType.FILE_BACKUP_STARTED);
        evt.setArtifactName(artifactName);
        this.sendEvent(evt);
    }

    private void sendFileBackupComplete(String artifactName) {
        this.logInfo("Backup complete for file: " + artifactName);
        InstallStatusEvent evt = this.installStatusEventFactory.create(InstallEventType.FILE_BACKUP_COMPLETE);
        evt.setArtifactName(artifactName);
        this.sendEvent(evt);
    }

    private void sendBackupComplete() {
        this.logInfo("Backup complete");
        InstallStatusEvent evt = this.installStatusEventFactory.create(InstallEventType.BACKUP_COMPLETE);
        this.sendEvent(evt);
    }

    private void sendRemoveStarted(int numFilesToRemove) {
        this.logInfo("Remove started");
        InstallStatusEvent evt = this.installStatusEventFactory.create(InstallEventType.REMOVE_STARTED);
        evt.setNumFilesToUpdate(numFilesToRemove);
        this.sendEvent(evt);
    }

    private void sendFileRemoveStarted(String artifactName) {
        this.logInfo("Remove started for file: " + artifactName);
        InstallStatusEvent evt = this.installStatusEventFactory.create(InstallEventType.FILE_REMOVE_STARTED);
        evt.setArtifactName(artifactName);
        this.sendEvent(evt);
    }

    private void sendFileRemoveComplete(String artifactName) {
        this.logInfo("Remove complete for file: " + artifactName);
        InstallStatusEvent evt = this.installStatusEventFactory.create(InstallEventType.FILE_REMOVE_COMPLETE);
        evt.setArtifactName(artifactName);
        this.sendEvent(evt);
    }

    private void sendRemoveComplete() {
        this.logInfo("Remove complete");
        InstallStatusEvent evt = this.installStatusEventFactory.create(InstallEventType.REMOVE_COMPLETE);
        this.sendEvent(evt);
    }

    private void sendInstallStarted(int numFilesToUpdate) {
        this.logInfo("Install started");
        InstallStatusEvent evt = this.installStatusEventFactory.create(InstallEventType.INSTALL_STARTED);
        evt.setNumFilesToUpdate(numFilesToUpdate);
        this.sendEvent(evt);
    }

    private void sendFileInstallStarted(String artifactName) {
        this.logInfo("Install started for file: " + artifactName);
        InstallStatusEvent evt = this.installStatusEventFactory.create(InstallEventType.FILE_INSTALL_STARTED);
        evt.setArtifactName(artifactName);
        this.sendEvent(evt);
    }

    private void sendFileInstallComplete(String artifactName) {
        this.logInfo("Install complete for file: " + artifactName);
        InstallStatusEvent evt = this.installStatusEventFactory.create(InstallEventType.FILE_INSTALL_COMPLETE);
        evt.setArtifactName(artifactName);
        this.sendEvent(evt);
    }

    private void sendInstallComplete() {
        this.logInfo("Install completed");
        InstallStatusEvent evt = this.installStatusEventFactory.create(InstallEventType.INSTALL_COMPLETE);
        this.sendEvent(evt);
    }

    private void sendEvent(InstallStatusEvent evt) {
        for (InstallStatusListener listener : this._listeners) {
            listener.handleInstallStatusEvent(evt);
        }
    }

    private void logInfo(String message) {
        if (s_log.isInfoEnabled()) {
            s_log.info(message);
        }
    }
}

