/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.update.gui.installer;

import net.sourceforge.squirrel_sql.fw.util.IOUtilities;
import net.sourceforge.squirrel_sql.fw.util.ScriptLineFixer;

public class ClasspathFunctionFixer
implements ScriptLineFixer {
    private boolean inFunctionDeclaration = false;
    private boolean scriptWasAlreadyFixed = false;
    private boolean sawOpenCurlyBrace = false;

    @Override
    public String fixLine(String scriptFileName, String line) {
        if (this.scriptWasAlreadyFixed) {
            return line;
        }
        if (!scriptFileName.toLowerCase().endsWith(".sh")) {
            return line;
        }
        if (line.contains("buildCPFromDir()")) {
            this.inFunctionDeclaration = true;
            return line;
        }
        if (this.inFunctionDeclaration) {
            if (line.contains("{")) {
                this.sawOpenCurlyBrace = true;
                return line;
            }
            if (line.contains("CP=\"\"")) {
                this.scriptWasAlreadyFixed = true;
                return line;
            }
            if (this.sawOpenCurlyBrace) {
                this.inFunctionDeclaration = false;
                this.scriptWasAlreadyFixed = true;
                StringBuilder alteredLine = new StringBuilder();
                alteredLine.append("\tCP=\"\"");
                alteredLine.append(IOUtilities.NEW_LINE);
                alteredLine.append(line);
                return alteredLine.toString();
            }
        }
        return line;
    }
}

