/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.update.gui.installer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.update.UpdateUtil;
import net.sourceforge.squirrel_sql.client.update.gui.ArtifactStatus;
import net.sourceforge.squirrel_sql.client.update.gui.installer.ArtifactInstaller;
import net.sourceforge.squirrel_sql.client.update.gui.installer.ArtifactInstallerFactory;
import net.sourceforge.squirrel_sql.client.update.gui.installer.PreLaunchHelper;
import net.sourceforge.squirrel_sql.client.update.gui.installer.ProgressDialogControllerImpl;
import net.sourceforge.squirrel_sql.client.update.gui.installer.event.InstallStatusListener;
import net.sourceforge.squirrel_sql.client.update.gui.installer.event.InstallStatusListenerImpl;
import net.sourceforge.squirrel_sql.client.update.xmlbeans.ChangeListXmlBean;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.IOUtilities;
import net.sourceforge.squirrel_sql.fw.util.ScriptLineFixer;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import org.springframework.beans.factory.annotation.Required;

public class PreLaunchHelperImpl
implements PreLaunchHelper {
    private String INSTALL_UPDATES_MESSAGE;
    private String INSTALL_UPDATES_TITLE;
    private String RESTORE_FROM_BACKUP_TITLE;
    private String RESTORE_FROM_BACKUP_MESSAGE;
    private String RESTORE_FAILED_MESSAGE;
    private String BACKUP_FAILED_MESSAGE;
    private String INSTALL_FAILED_MESSAGE;
    private StringManager s_stringMgr;
    private ILogger s_log = LoggerController.createLogger(PreLaunchHelperImpl.class);
    private String scriptLocation = null;
    private UpdateUtil updateUtil = null;
    private ArtifactInstallerFactory artifactInstallerFactory = null;
    private List<ScriptLineFixer> scriptLineFixers = null;
    private IOUtilities ioutils = null;

    @Required
    public void setUpdateUtil(UpdateUtil util) {
        Utilities.checkNull("setUpdateUtil", "util", util);
        this.updateUtil = util;
    }

    @Required
    public void setArtifactInstallerFactory(ArtifactInstallerFactory artifactInstallerFactory) {
        Utilities.checkNull("setArtifactInstallerFactory", "artifactInstallerFactory", artifactInstallerFactory);
        this.artifactInstallerFactory = artifactInstallerFactory;
    }

    @Required
    public void setScriptLineFixers(List<ScriptLineFixer> scriptLineFixers) {
        Utilities.checkNull("setScriptLineFixers", "scriptLineFixers", scriptLineFixers);
        this.scriptLineFixers = scriptLineFixers;
    }

    @Required
    public void setIoutils(IOUtilities ioutils) {
        Utilities.checkNull("setIoutils", "ioutils", ioutils);
        this.ioutils = ioutils;
    }

    public PreLaunchHelperImpl() throws IOException {
        this.s_stringMgr = StringManagerFactory.getStringManager(PreLaunchHelperImpl.class);
        this.INSTALL_UPDATES_TITLE = this.s_stringMgr.getString("PreLaunchHelperImpl.installUpdatesTitle");
        this.INSTALL_UPDATES_MESSAGE = this.s_stringMgr.getString("PreLaunchHelperImpl.installUpdatesMessage");
        this.RESTORE_FROM_BACKUP_TITLE = this.s_stringMgr.getString("PreLaunchHelperImpl.restoreFromBackupTitle");
        this.RESTORE_FROM_BACKUP_MESSAGE = this.s_stringMgr.getString("PreLaunchHelperImpl.restoreFromBackupMessage");
        this.BACKUP_FAILED_MESSAGE = this.s_stringMgr.getString("PreLaunchHelperImpl.backupFailedMessage");
        this.INSTALL_FAILED_MESSAGE = this.s_stringMgr.getString("PreLaunchHelperImpl.installFailedMessage");
        this.RESTORE_FAILED_MESSAGE = this.s_stringMgr.getString("PreLaunchHelperImpl.restoreFailedMessage");
    }

    @Override
    public void installUpdates(boolean prompt) {
        FileWrapper changeListFile = this.updateUtil.getChangeListFile();
        if (this.hasChangesToBeApplied(changeListFile)) {
            this.logInfo("Pre-launch update app detected a changeListFile to be processed");
            if (prompt) {
                if (this.showConfirmDialog(this.INSTALL_UPDATES_MESSAGE, this.INSTALL_UPDATES_TITLE)) {
                    this.installUpdates(changeListFile);
                } else {
                    this.logInfo("User cancelled update installation");
                }
            } else {
                this.installUpdates(changeListFile);
            }
        }
    }

    @Override
    public void updateLaunchScript() throws IOException {
        List<String> launchScriptLocations = this.getLaunchScriptLocations();
        for (String launchScript : launchScriptLocations) {
            this.logInfo("Applying updates to launch script: " + launchScript);
            List<String> lines = this.ioutils.getLinesFromFile(launchScript, this.scriptLineFixers);
            this.ioutils.writeLinesToFile(launchScript, lines);
        }
    }

    private List<String> getLaunchScriptLocations() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.scriptLocation != null) {
            result.add(this.scriptLocation);
            return result;
        }
        String os = System.getProperty("os.name");
        if (os != null && os.toLowerCase().startsWith("windows")) {
            result.add("squirrel-sql.bat");
            result.add("squirrel-sql.sh");
        } else if (os != null && os.toLowerCase().startsWith("mac")) {
            result.add(this.getMacOSContentsPath() + "/MacOS/squirrel-sql.sh");
        } else {
            result.add("squirrel-sql.sh");
        }
        return result;
    }

    private String getMacOSContentsPath() {
        String userdir = System.getProperty("user.dir");
        String[] parts = userdir.split("Contents");
        return parts[0] + "/Contents";
    }

    @Override
    public void copySplashImage() throws IOException {
        String squirrelHome = System.getProperty("user.dir");
        String jarFilename = squirrelHome + "/update/downloads/core/squirrel-sql.jar";
        String resourceName = "splash.jpg";
        String pathToIconsDir = squirrelHome + "/icons";
        String destinationFile = pathToIconsDir + "/" + resourceName;
        File iconsDir = new File(pathToIconsDir);
        if (!iconsDir.exists()) {
            this.logInfo("Icons directory (" + pathToIconsDir + ") doesn't exist, so attempting to create it.");
            boolean result = iconsDir.mkdir();
            if (!result) {
                this.s_log.error("Failed to create icons directory (" + pathToIconsDir + ")");
            }
        }
        this.logInfo("Copying splash.jpg from jarfile (" + jarFilename + ") to " + destinationFile);
        this.ioutils.copyResourceFromJarFile(jarFilename, resourceName, destinationFile);
    }

    @Override
    public void restoreFromBackup() {
        if (this.showConfirmDialog(this.RESTORE_FROM_BACKUP_MESSAGE, this.RESTORE_FROM_BACKUP_TITLE)) {
            try {
                FileWrapper backupDir = this.updateUtil.getBackupDir();
                FileWrapper changeListFile = this.updateUtil.getFile(backupDir, "changeList.xml");
                ChangeListXmlBean changeList = this.updateUtil.getChangeList(changeListFile);
                ArtifactInstaller installer = this.artifactInstallerFactory.create(changeList, null);
                if (!installer.restoreBackupFiles()) {
                    this.showErrorDialog(this.RESTORE_FAILED_MESSAGE);
                    this.s_log.error("restoreFromBackup: " + this.RESTORE_FAILED_MESSAGE);
                }
            }
            catch (Throwable e) {
                this.s_log.error("Unexpected error while attempting restore from backup: " + e.getMessage(), e);
                this.showErrorDialog(this.RESTORE_FAILED_MESSAGE);
            }
        }
        this.shutdown("Pre-launch update app finished");
    }

    private boolean hasChangesToBeApplied(FileWrapper changeListFile) {
        boolean result = false;
        try {
            if (changeListFile.exists()) {
                ChangeListXmlBean changeListBean = this.updateUtil.getChangeList(changeListFile);
                List<ArtifactStatus> changeList = changeListBean.getChanges();
                int changeListSize = changeList.size();
                this.logInfo("hasChangesToBeApplied: changeListFile (" + changeListSize + ") has " + changeListSize + " changes to be applied");
                if (changeList != null && changeListSize > 0) {
                    result = true;
                } else {
                    this.logInfo("Aborting update: changeList was found with no updates");
                }
            } else {
                this.logInfo("installUpdates: changeList file (" + changeListFile + ") doesn't exist");
            }
        }
        catch (FileNotFoundException e) {
            this.s_log.error("hasChangesToBeApplied: unable to get change list from file (" + changeListFile + "): " + e.getMessage());
        }
        return result;
    }

    private void shutdown(String message) {
        this.logInfo(message);
        LoggerController.shutdown();
        System.exit(0);
    }

    private void installUpdates(final FileWrapper changeList) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ProgressDialogControllerImpl controller = new ProgressDialogControllerImpl();
                    InstallStatusListenerImpl listener = new InstallStatusListenerImpl(controller);
                    ArtifactInstaller installer = PreLaunchHelperImpl.this.artifactInstallerFactory.create(changeList, (InstallStatusListener)listener);
                    if (installer.backupFiles()) {
                        installer.installFiles();
                    } else {
                        PreLaunchHelperImpl.this.showErrorDialog(PreLaunchHelperImpl.this.BACKUP_FAILED_MESSAGE);
                    }
                    controller.hideProgressDialog();
                    PreLaunchHelperImpl.this.shutdown("Pre-launch update app finished");
                }
                catch (Throwable e) {
                    String message = PreLaunchHelperImpl.this.INSTALL_FAILED_MESSAGE + ": " + e.getMessage();
                    PreLaunchHelperImpl.this.s_log.error(message, e);
                    PreLaunchHelperImpl.this.showErrorDialog(message);
                }
            }
        });
        t.setName("Update Installer Thread");
        t.start();
    }

    private boolean showConfirmDialog(String message, String title) {
        int choice = JOptionPane.showConfirmDialog(null, message, title, 0, 3);
        return choice == 0;
    }

    private void showErrorDialog(String message) {
        JOptionPane.showMessageDialog(null, message, "Error", 0);
    }

    private void logInfo(String message) {
        if (this.s_log.isInfoEnabled()) {
            this.s_log.info(message);
        }
    }

    public void setScriptLocation(String scriptLocation) {
        this.scriptLocation = scriptLocation;
    }

    public String getScriptLocation() {
        return this.scriptLocation;
    }
}

