/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.update.gui.installer;

import java.io.File;
import java.io.IOException;
import net.sourceforge.squirrel_sql.client.ApplicationArguments;
import net.sourceforge.squirrel_sql.client.SquirrelLoggerFactory;
import net.sourceforge.squirrel_sql.client.update.gui.installer.PreLaunchHelper;
import net.sourceforge.squirrel_sql.client.update.gui.installer.PreLaunchHelperFactoryImpl;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;

public class PreLaunchUpdateApplication {
    private static PreLaunchHelper helper = null;
    public static final String PROMPT_MODE = "prompt";
    public static final String RESTORE_MODE = "restore";

    public static void main(String[] args) throws IOException {
        ApplicationArguments.initialize(args);
        PreLaunchUpdateApplication.initializeLogger();
        boolean prompt = PreLaunchUpdateApplication.getMode(PROMPT_MODE);
        boolean restore = PreLaunchUpdateApplication.getMode(RESTORE_MODE);
        PreLaunchUpdateApplication.setupHelper();
        if (!restore) {
            helper.installUpdates(prompt);
            helper.updateLaunchScript();
            helper.copySplashImage();
        } else {
            helper.restoreFromBackup();
        }
    }

    private static void setupHelper() {
        PreLaunchHelperFactoryImpl preLaunchHelperFactory = new PreLaunchHelperFactoryImpl();
        helper = preLaunchHelperFactory.createPreLaunchHelper();
    }

    private static boolean getMode(String mode) {
        boolean prompt = false;
        if (Boolean.getBoolean(mode)) {
            prompt = true;
        }
        return prompt;
    }

    private static void initializeLogger() throws IOException {
        String logConfigFileName = ApplicationArguments.getInstance().getLoggingConfigFileName();
        if (logConfigFileName != null) {
            PropertyConfigurator.configure(logConfigFileName);
        } else {
            ApplicationFiles appFiles = new ApplicationFiles();
            String logMessagePattern = "%-4r [%t] %-5p %c %x - %m%n";
            PatternLayout layout = new PatternLayout(logMessagePattern);
            File logsDir = new File(appFiles.getUserSettingsDirectory(), "logs");
            File updateLogFile = new File(logsDir, "updater.log");
            FileAppender appender = new FileAppender((Layout)layout, updateLogFile.getAbsolutePath());
            LoggerController.registerLoggerFactory(new SquirrelLoggerFactory(appender, false));
        }
    }
}

