/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.update.xmlbeans;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.squirrel_sql.client.update.gui.ArtifactAction;
import net.sourceforge.squirrel_sql.client.update.xmlbeans.ChangeListXmlBean;
import net.sourceforge.squirrel_sql.client.update.xmlbeans.ChannelXmlBean;
import net.sourceforge.squirrel_sql.client.update.xmlbeans.EnumPersistenceDelegate;
import net.sourceforge.squirrel_sql.client.update.xmlbeans.UpdateXmlSerializer;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.IOUtilities;
import net.sourceforge.squirrel_sql.fw.util.IOUtilitiesImpl;

public class UpdateXmlSerializerImpl
implements UpdateXmlSerializer {
    private EnumPersistenceDelegate enumDelegate = new EnumPersistenceDelegate();
    private IOUtilities _iou = new IOUtilitiesImpl();

    @Override
    public void write(ChannelXmlBean channelBean, String filename) throws FileNotFoundException {
        XMLEncoder os = this.getXmlEncoder(filename);
        os.writeObject(channelBean);
        os.close();
    }

    @Override
    public void write(ChangeListXmlBean changeBean, String filename) throws FileNotFoundException {
        XMLEncoder os = this.getXmlEncoder(filename);
        os.writeObject(changeBean);
        os.close();
    }

    @Override
    public void write(ChangeListXmlBean changeBean, FileWrapper file) throws FileNotFoundException {
        XMLEncoder os = this.getXmlEncoder(file.getAbsolutePath());
        os.writeObject(changeBean);
        os.close();
    }

    @Override
    public ChannelXmlBean readChannelBean(String filename) throws FileNotFoundException, IOException {
        if (filename == null) {
            throw new IllegalArgumentException("filename cannot be null");
        }
        return this.readChannelBean(new FileInputStream(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelXmlBean readChannelBean(FileWrapper fileWrapper) throws FileNotFoundException, IOException {
        ChannelXmlBean result = null;
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(fileWrapper.getAbsolutePath()));
            result = this.readChannelBean(is);
            this._iou.closeInputStream(is);
        }
        catch (Throwable throwable) {
            this._iou.closeInputStream(is);
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelXmlBean readChannelBean(InputStream is) throws IOException {
        XMLDecoder bis = null;
        Object result = null;
        try {
            bis = new XMLDecoder(new BufferedInputStream(is));
            result = bis.readObject();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return (ChannelXmlBean)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChangeListXmlBean readChangeListBean(FileWrapper file) throws FileNotFoundException {
        XMLDecoder bis = null;
        FileInputStream fis = null;
        Object result = null;
        try {
            fis = new FileInputStream(new File(file.getAbsolutePath()));
            bis = new XMLDecoder(new BufferedInputStream(fis));
            result = bis.readObject();
            this._iou.closeInputStream(fis);
            if (bis != null) {
                bis.close();
            }
        }
        catch (Throwable throwable) {
            this._iou.closeInputStream(fis);
            if (bis != null) {
                bis.close();
            }
            throw throwable;
        }
        return (ChangeListXmlBean)result;
    }

    private XMLEncoder getXmlEncoder(String filename) throws FileNotFoundException {
        XMLEncoder result = null;
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(filename));
        result = new XMLEncoder(os);
        result.setPersistenceDelegate(ArtifactAction.class, this.enumDelegate);
        return result;
    }
}

