/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import net.sourceforge.squirrel_sql.client.ApplicationArguments;

public class ApplicationFiles {
    private String _userSettingsDir;
    private final File _squirrelHomeDir;
    private String _squirrelPluginsDir;
    private String _documentationDir;
    private String _libraryDir;
    private String _updateDir;
    private static boolean needExecutionLogCleanup = true;
    private static boolean needDebugLogCleanup = true;

    public ApplicationFiles() {
        ApplicationArguments args = ApplicationArguments.getInstance();
        String homeDir = args.getSquirrelHomeDirectory();
        this._squirrelHomeDir = new File(homeDir != null ? homeDir : System.getProperty("user.dir"));
        String homeDirPath = this._squirrelHomeDir.getPath() + File.separator;
        this._squirrelPluginsDir = homeDirPath + "plugins";
        this._documentationDir = homeDirPath + "doc";
        this._libraryDir = homeDirPath + "lib";
        this._updateDir = homeDirPath + "update";
        this._userSettingsDir = args.getUserSettingsDirectoryOverride();
        if (this._userSettingsDir == null) {
            this._userSettingsDir = System.getProperty("user.home") + File.separator + ".squirrel-sql";
        }
        try {
            new File(this._userSettingsDir).mkdirs();
        }
        catch (Exception ex) {
            System.out.println("Error creating user settings directory: " + this._userSettingsDir);
            System.out.println(ex.toString());
        }
        try {
            File logsDir = this.getExecutionLogFile().getParentFile();
            logsDir.mkdirs();
        }
        catch (Exception ex) {
            System.out.println("Error creating logs directory");
            System.out.println(ex.toString());
        }
    }

    public File getUserSettingsDirectory() {
        return new File(this._userSettingsDir);
    }

    public File getPluginsDirectory() {
        return new File(this._squirrelPluginsDir);
    }

    public File getLibraryDirectory() {
        return new File(this._libraryDir);
    }

    public File getUpdateDirectory() {
        return new File(this._updateDir);
    }

    public File getDatabaseAliasesFile() {
        return new File(this._userSettingsDir + File.separator + "SQLAliases23.xml");
    }

    public File getDatabaseAliasesTreeStructureFile() {
        return new File(this._userSettingsDir + File.separator + "SQLAliases23_treeStructure.xml");
    }

    public File getDatabaseAliasesFile_before_version_2_3() {
        return new File(this._userSettingsDir + File.separator + "SQLAliases.xml");
    }

    public File getDatabaseDriversFile() {
        return new File(this._userSettingsDir + File.separator + "SQLDrivers.xml");
    }

    public File getUserPreferencesFile() {
        return new File(this._userSettingsDir + File.separator + "prefs.xml");
    }

    public File getCellImportExportSelectionsFile() {
        return new File(this._userSettingsDir + File.separator + "cellImportExport.xml");
    }

    public File getDTPropertiesFile() {
        return new File(this._userSettingsDir + File.separator + "DTproperties.xml");
    }

    public File getEditWhereColsFile() {
        return new File(this._userSettingsDir + File.separator + "editWhereCols.xml");
    }

    public File getExecutionLogFile() {
        String dirPath = this._userSettingsDir + File.separator + "logs";
        String logBaseName = "squirrel-sql.log";
        if (needExecutionLogCleanup) {
            this.deleteOldFiles(dirPath, "squirrel-sql.log");
            needExecutionLogCleanup = false;
        }
        return new File(dirPath + File.separator + "squirrel-sql.log");
    }

    public File getJDBCDebugLogFile() {
        String dirPath = this._userSettingsDir + File.separator + "logs";
        String logBaseName = "jdbcdebug.log";
        if (needDebugLogCleanup) {
            this.deleteOldFiles(dirPath, "jdbcdebug.log");
            needDebugLogCleanup = false;
        }
        return new File(dirPath + File.separator + "jdbcdebug.log");
    }

    public File getUserSQLHistoryFile() {
        return new File(this._userSettingsDir + File.separator + "sql_history.xml");
    }

    public File getSquirrelHomeDir() {
        return this._squirrelHomeDir;
    }

    public File getPluginsUserSettingsDirectory() {
        return new File(this._userSettingsDir + File.separator + "plugins");
    }

    public File getQuickStartGuideFile() {
        return new File(this._documentationDir + File.separator + "quick_start.html");
    }

    public File getFAQFile() {
        return new File(this._documentationDir + File.separator + "faq.html");
    }

    public File getChangeLogFile() {
        return new File(this._documentationDir + File.separator + "changes.txt");
    }

    public File getLicenceFile() {
        return new File(this._documentationDir + File.separator + "licences/squirrel_licence.txt");
    }

    public File getWelcomeFile() {
        return new File(this._documentationDir + File.separator + "welcome.html");
    }

    private void deleteOldFiles(String dirPath, String fileBase) {
        int numberToKeep = 3;
        File dir = new File(dirPath);
        class OldFileNameFilter
        implements FilenameFilter {
            String fBase;

            OldFileNameFilter(String fileBase) {
                this.fBase = fileBase;
            }

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(this.fBase);
            }
        }
        OldFileNameFilter fileFilter = new OldFileNameFilter(fileBase);
        Object[] fileNames = dir.list(fileFilter);
        if (fileNames == null || fileNames.length <= 3) {
            return;
        }
        Arrays.sort(fileNames);
        int startIndex = 0;
        int endIndex = fileNames.length - 3;
        if (((String)fileNames[0]).equals(fileBase)) {
            startIndex = 1;
            ++endIndex;
        }
        for (int i = startIndex; i < endIndex; ++i) {
            File oldFile = new File(dirPath + File.separator + (String)fileNames[i]);
            oldFile.delete();
        }
    }

    public File getSQuirrelJarFile() {
        File ret = new File(this._squirrelHomeDir.getPath() + File.separator + "lib" + File.separator + "squirrel-sql.jar");
        if (!ret.exists()) {
            ret = new File(this._squirrelHomeDir.getPath() + File.separator + "squirrel-sql.jar");
        }
        return ret;
    }

    public File getFwJarFile() {
        return new File(this._squirrelHomeDir.getPath() + File.separator + "lib" + File.separator + "fw.jar");
    }

    public File getUserSpecificWikiConfigurationsFile() {
        return new File(this._userSettingsDir + File.separator + "userSpecificWikiTableConfigurations.xml");
    }
}

