/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.codereformat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.codereformat.CodeReformatorKernel;
import net.sourceforge.squirrel_sql.fw.codereformat.CommentSpec;
import net.sourceforge.squirrel_sql.fw.codereformat.ICodeReformator;
import net.sourceforge.squirrel_sql.fw.codereformat.PieceMarkerSpec;
import net.sourceforge.squirrel_sql.fw.codereformat.StateOfPosition;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class CodeReformator
implements ICodeReformator {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CodeReformator.class);
    private static final String INDENT = "   ";
    private static final int TRY_SPLIT_LINE_LEN = 80;
    private String _statementSeparator;
    private CommentSpec[] _commentSpecs;
    private String _lineSep = StringUtilities.getEolStr();
    private static ILogger s_log = LoggerController.createLogger(CodeReformator.class);

    public CodeReformator(String statementSeparator, CommentSpec[] commentSpecs) {
        this._statementSeparator = statementSeparator;
        this._commentSpecs = commentSpecs;
    }

    @Override
    public String reformat(String in) {
        in = this.flatenWhiteSpaces(in, false);
        PieceMarkerSpec[] markerExcludeComma = this.createPieceMarkerSpecExcludeColon();
        String[] pieces = this.getReformatedPieces(in, markerExcludeComma).toArray(new String[0]);
        pieces = this.doInsertSpecial(pieces);
        StringBuffer ret = new StringBuffer();
        int braketCount = 0;
        for (int i = 0; i < pieces.length; ++i) {
            if (")".equals(pieces[i])) {
                --braketCount;
            }
            ret.append(this.indent(pieces[i], braketCount));
            ret.append(this._lineSep);
            if (!"(".equals(pieces[i])) continue;
            ++braketCount;
        }
        this.validate(in, ret.toString());
        return ret.toString();
    }

    private void validate(String beforeReformat, String afterReformat) {
        String normalizedAfter;
        String normalizedBefore = this.getNormalized(beforeReformat);
        if (!normalizedBefore.equalsIgnoreCase(normalizedAfter = this.getNormalized(afterReformat))) {
            int minLen = Math.min(normalizedAfter.length(), normalizedBefore.length());
            StringBuffer diffPos = new StringBuffer();
            for (int i = 0; i < minLen && Character.toUpperCase(normalizedBefore.charAt(i)) == Character.toUpperCase(normalizedAfter.charAt(i)); ++i) {
                diffPos.append('-');
            }
            diffPos.append('^');
            StringBuilder msg = new StringBuilder(s_stringMgr.getString("editextras.reformatFailed"));
            msg.append(this._lineSep);
            msg.append(normalizedBefore);
            msg.append(this._lineSep);
            msg.append(normalizedAfter);
            msg.append(this._lineSep);
            msg.append(diffPos.toString());
            msg.append(this._lineSep);
            if (s_log.isInfoEnabled()) {
                s_log.info(msg.toString());
            }
            throw new IllegalStateException(msg.toString());
        }
    }

    private String getNormalized(String s) {
        String ret = s.replaceAll("\\(", " ( ");
        ret = ret.replaceAll("\\)", " ) ");
        ret = ret.replaceAll(",", " , ");
        String sep = this._statementSeparator;
        if (sep.equals("|")) {
            sep = "\\|";
        }
        ret = ret.replaceAll(sep, this.concat(" ", sep, " "));
        return this.flatenWhiteSpaces(ret, true).trim();
    }

    private String concat(String ... strings) {
        StringBuilder result = new StringBuilder();
        for (String string : strings) {
            result.append(string);
        }
        return result.toString();
    }

    private List<String> getReformatedPieces(String in, PieceMarkerSpec[] markers) {
        CodeReformatorKernel kernel = new CodeReformatorKernel(this._statementSeparator, markers, this._commentSpecs);
        String[] pieces = kernel.toPieces(in);
        ArrayList<String> piecesBuf = new ArrayList<String>();
        for (int i = 0; i < pieces.length; ++i) {
            if (80 < pieces[i].length()) {
                String[] splitPieces = this.trySplit(pieces[i], 0, 80);
                piecesBuf.addAll(Arrays.asList(splitPieces));
                continue;
            }
            piecesBuf.add(pieces[i]);
        }
        return piecesBuf;
    }

    private String[] doInsertSpecial(String[] pieces) {
        int insertBegin = -1;
        boolean hasValues = false;
        ArrayList<String> ret = new ArrayList<String>();
        ArrayList<String> insertPieces = new ArrayList<String>();
        for (int i = 0; i < pieces.length; ++i) {
            if ("INSERT ".length() <= pieces[i].length() && pieces[i].substring(0, "INSERT ".length()).equalsIgnoreCase("INSERT ")) {
                if (-1 != insertBegin) {
                    return pieces;
                }
                insertBegin = i;
            }
            if (-1 == insertBegin) {
                ret.add(pieces[i]);
            } else {
                insertPieces.add(pieces[i]);
            }
            if (-1 < insertBegin && -1 != pieces[i].toUpperCase().indexOf("VALUES")) {
                hasValues = true;
            }
            if (-1 >= insertBegin || !this._statementSeparator.equalsIgnoreCase(pieces[i])) continue;
            if (hasValues) {
                ret.addAll(this.reformatInsert(insertPieces));
            } else {
                ret.addAll(insertPieces);
            }
            insertBegin = -1;
            hasValues = false;
            insertPieces = new ArrayList();
        }
        if (-1 < insertBegin) {
            if (hasValues) {
                ret.addAll(this.reformatInsert(insertPieces));
            } else {
                ret.addAll(insertPieces);
            }
        }
        return ret.toArray(new String[0]);
    }

    private ArrayList<String> reformatInsert(ArrayList<String> piecesIn) {
        String[] pieces = this.splitAsFarAsPossible(piecesIn.toArray(new String[piecesIn.size()]));
        ArrayList<String> insertList = new ArrayList<String>();
        ArrayList<String> valuesList = new ArrayList<String>();
        ArrayList<String> behindInsert = new ArrayList<String>();
        StringBuffer statementBegin = new StringBuffer();
        int braketCountAbsolute = 0;
        for (int i = 0; i < pieces.length; ++i) {
            String buf;
            if (3 < braketCountAbsolute) {
                behindInsert.add(pieces[i]);
            }
            if ("(".equals(pieces[i]) || ")".equals(pieces[i])) {
                ++braketCountAbsolute;
            }
            if (0 == braketCountAbsolute) {
                statementBegin.append(pieces[i]).append(' ');
            }
            if (1 == braketCountAbsolute && !"(".equals(pieces[i]) && !")".equals(pieces[i])) {
                buf = pieces[i].trim();
                if (buf.endsWith(",")) {
                    buf = buf.substring(0, buf.length() - 1);
                }
                insertList.add(buf);
            }
            if (3 != braketCountAbsolute || "(".equals(pieces[i]) || ")".equals(pieces[i])) continue;
            buf = pieces[i].trim();
            if (buf.endsWith(",")) {
                buf = buf.substring(0, buf.length() - 1);
            }
            valuesList.add(buf);
        }
        ArrayList<String> ret = new ArrayList<String>();
        if (0 == insertList.size()) {
            ret.addAll(piecesIn);
            return ret;
        }
        if (insertList.size() == valuesList.size()) {
            ret.add(statementBegin.toString());
            StringBuffer insert = new StringBuffer();
            StringBuffer values = new StringBuffer();
            String insBuf = (String)insertList.get(0);
            String valsBuf = (String)valuesList.get(0);
            insert.append('(').append(this.adjustLength(insBuf, valsBuf));
            values.append('(').append(this.adjustLength(valsBuf, insBuf));
            for (int i = 1; i < insertList.size(); ++i) {
                insBuf = (String)insertList.get(i);
                valsBuf = (String)valuesList.get(i);
                insert.append(',').append(this.adjustLength(insBuf, valsBuf));
                values.append(',').append(this.adjustLength(valsBuf, insBuf));
            }
            insert.append(") VALUES");
            values.append(')');
            ret.add(insert.toString());
            ret.add(values.toString());
            ret.addAll(behindInsert);
            return ret;
        }
        ret.addAll(piecesIn);
        return ret;
    }

    private String[] splitAsFarAsPossible(String[] pieces) {
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < pieces.length; ++i) {
            ret.addAll(Arrays.asList(this.trySplit(pieces[i], 0, 1)));
        }
        return ret.toArray(new String[ret.size()]);
    }

    private String adjustLength(String s1, String s2) {
        int max = Math.max(s1.length(), s2.length());
        if (s1.length() == max) {
            return s1;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(s1);
        while (sb.length() < max) {
            sb.append(' ');
        }
        return sb.toString();
    }

    private String[] trySplit(String piece, int braketDepth, int trySplitLineLen) {
        CodeReformatorKernel dum;
        String trimmedPiece = piece.trim();
        if (this.hasTopLevelColon(trimmedPiece, dum = new CodeReformatorKernel(this._statementSeparator, new PieceMarkerSpec[0], this._commentSpecs))) {
            PieceMarkerSpec[] pms = this.createPieceMarkerSpecIncludeColon();
            CodeReformatorKernel crk = new CodeReformatorKernel(this._statementSeparator, pms, this._commentSpecs);
            String[] splitPieces1 = crk.toPieces(trimmedPiece);
            if (1 == splitPieces1.length) {
                return splitPieces1;
            }
            ArrayList<String> ret = new ArrayList<String>();
            for (int i = 0; i < splitPieces1.length; ++i) {
                if (trySplitLineLen < splitPieces1[i].length() + braketDepth * INDENT.length()) {
                    String[] splitPieces2 = this.trySplit(splitPieces1[i], braketDepth, trySplitLineLen);
                    for (int j = 0; j < splitPieces2.length; ++j) {
                        ret.add(splitPieces2[j].trim());
                    }
                    continue;
                }
                ret.add(splitPieces1[i].trim());
            }
            return this.purgeEmptyStrings(ret).toArray(new String[0]);
        }
        int[] tlbi = this.getTopLevelBraketIndexes(trimmedPiece, dum);
        if (-1 != tlbi[0] && tlbi[0] < tlbi[1]) {
            PieceMarkerSpec[] pms = this.createPieceMarkerSpecExcludeColon();
            CodeReformatorKernel crk = new CodeReformatorKernel(this._statementSeparator, pms, this._commentSpecs);
            String[] splitPieces1 = crk.toPieces(trimmedPiece.substring(tlbi[0] + 1, tlbi[1]));
            ArrayList<String> buf = new ArrayList<String>();
            buf.add(trimmedPiece.substring(0, tlbi[0]).trim());
            buf.add("(");
            for (int i = 0; i < splitPieces1.length; ++i) {
                buf.add(splitPieces1[i]);
            }
            buf.add(")");
            if (tlbi[1] + 1 < trimmedPiece.length()) {
                buf.add(trimmedPiece.substring(tlbi[1] + 1, trimmedPiece.length()).trim());
            }
            splitPieces1 = buf.toArray(new String[0]);
            ArrayList<String> ret = new ArrayList<String>();
            for (int i = 0; i < splitPieces1.length; ++i) {
                if (trySplitLineLen < splitPieces1[i].length() + braketDepth * INDENT.length()) {
                    String[] splitPieces2 = this.trySplit(splitPieces1[i], braketDepth + 1, trySplitLineLen);
                    for (int j = 0; j < splitPieces2.length; ++j) {
                        ret.add(splitPieces2[j]);
                    }
                    continue;
                }
                ret.add(splitPieces1[i]);
            }
            return this.purgeEmptyStrings(ret).toArray(new String[0]);
        }
        return new String[]{piece};
    }

    private List<String> purgeEmptyStrings(List<String> items) {
        Iterator<String> iter = items.iterator();
        while (iter.hasNext()) {
            String item = iter.next();
            if (item != null && !"".equals(item)) continue;
            iter.remove();
        }
        return items;
    }

    private boolean hasTopLevelColon(String piece, CodeReformatorKernel crk) {
        int ix = piece.indexOf(",");
        StateOfPosition[] stateOfPositions = crk.getStatesOfPosition(piece);
        while (-1 != ix) {
            if (stateOfPositions[ix].isTopLevel) {
                return true;
            }
            if (ix >= piece.length() - 1) break;
            ix = piece.indexOf(",", ix + 1);
        }
        return false;
    }

    private int[] getTopLevelBraketIndexes(String piece, CodeReformatorKernel crk) {
        int[] ret = new int[]{-1, -1};
        StateOfPosition[] stateOfPositions = crk.getStatesOfPosition(piece);
        int bra = piece.indexOf("(");
        while (-1 != bra) {
            crk.getStatesOfPosition(piece);
            if (0 == bra || stateOfPositions[bra - 1].isTopLevel) {
                ret[0] = bra;
                break;
            }
            if (bra >= piece.length() - 1) break;
            bra = piece.indexOf("(", bra + 1);
        }
        if (-1 == ret[0]) {
            return ret;
        }
        int ket = piece.indexOf(")", bra);
        while (-1 != ket) {
            if (ket == piece.length() - 1 || stateOfPositions[ket].isTopLevel) {
                ret[1] = ket;
                break;
            }
            if (ket >= piece.length() - 1) break;
            ket = piece.indexOf(")", ket + 1);
        }
        return ret;
    }

    private String indent(String piece, int callDepth) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < callDepth; ++i) {
            sb.append(INDENT);
        }
        sb.append(piece);
        return sb.toString();
    }

    private String flatenWhiteSpaces(String in, boolean force) {
        if (this.hasCommentEndingWithLineFeed(in) && !force) {
            return in;
        }
        StringBuffer ret = new StringBuffer();
        int aposCount = 0;
        for (int i = 0; i < in.length(); ++i) {
            if ('\'' == in.charAt(i)) {
                ++aposCount;
            }
            boolean dontAppend = false;
            if (0 == aposCount % 2 && Character.isWhitespace(in.charAt(i)) && i + 1 < in.length() && Character.isWhitespace(in.charAt(i + 1))) {
                dontAppend = true;
            }
            if (dontAppend) continue;
            int toAppend = Character.isWhitespace(in.charAt(i)) && 0 == aposCount % 2 ? 32 : in.charAt(i);
            ret.append((char)toAppend);
        }
        return ret.toString();
    }

    boolean hasCommentEndingWithLineFeed(String in) {
        CodeReformatorKernel dum = new CodeReformatorKernel(this._statementSeparator, new PieceMarkerSpec[0], this._commentSpecs);
        StateOfPosition[] sops = dum.getStatesOfPosition(in);
        boolean inComment = false;
        for (int i = 0; i < sops.length; ++i) {
            if (!inComment && -1 < sops[i].commentIndex) {
                if (-1 < this._commentSpecs[sops[i].commentIndex].commentEnd.indexOf(10)) {
                    return true;
                }
                inComment = true;
            }
            if (-1 != sops[i].commentIndex) continue;
            inComment = false;
        }
        return false;
    }

    private PieceMarkerSpec[] createPieceMarkerSpecIncludeColon() {
        PieceMarkerSpec[] buf = this.createPieceMarkerSpecExcludeColon();
        ArrayList<PieceMarkerSpec> ret = new ArrayList<PieceMarkerSpec>();
        ret.addAll(Arrays.asList(buf));
        ret.add(new PieceMarkerSpec(",", 1));
        return ret.toArray(new PieceMarkerSpec[0]);
    }

    private PieceMarkerSpec[] createPieceMarkerSpecExcludeColon() {
        return new PieceMarkerSpec[]{new PieceMarkerSpec("SELECT", 2), new PieceMarkerSpec("UNION", 2), new PieceMarkerSpec("FROM", 0), new PieceMarkerSpec("INNER", 0), new PieceMarkerSpec("LEFT", 0), new PieceMarkerSpec("RIGHT", 0), new PieceMarkerSpec("WHERE", 0), new PieceMarkerSpec("AND", 0), new PieceMarkerSpec("GROUP", 0), new PieceMarkerSpec("ORDER", 0), new PieceMarkerSpec("INSERT", 0), new PieceMarkerSpec("VALUES", 0), new PieceMarkerSpec("UPDATE", 0), new PieceMarkerSpec("DELETE", 0), new PieceMarkerSpec(this._statementSeparator, 2)};
    }
}

