/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.fw.datasetviewer.CellImportExportInfo;
import net.sourceforge.squirrel_sql.fw.datasetviewer.CellImportExportInfoSaver;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.XmlRefomatter;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BinaryDisplayConverter;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextArea;
import net.sourceforge.squirrel_sql.fw.gui.TextPopupMenu;
import net.sourceforge.squirrel_sql.fw.gui.action.BaseAction;
import net.sourceforge.squirrel_sql.fw.util.IOUtilities;
import net.sourceforge.squirrel_sql.fw.util.IOUtilitiesImpl;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class PopupEditableIOPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(PopupEditableIOPanel.class);
    private final JTextArea _ta;
    private final JScrollPane scrollPane;
    private final transient ColumnDisplayDefinition _colDef;
    private transient MouseAdapter _lis;
    private final TextPopupMenu _popupMenu;
    private JTextField fileNameField;
    private JComboBox externalCommandCombo;
    private Object originalValue;
    private JComboBox radixList = null;
    private String previousRadixListItem = null;
    private JCheckBox showAscii = null;
    private boolean previousShowAscii;
    private IOUtilities _iou = new IOUtilitiesImpl();
    private transient BinaryOptionActionListener optionActionListener = new BinaryOptionActionListener();
    private final String TEMP_FILE_FLAG = "<temp file>";
    private final String FILE_REPLACE_FLAG = "%f";

    public PopupEditableIOPanel(ColumnDisplayDefinition colDef, Object value, boolean isEditable) {
        this.originalValue = value;
        this._popupMenu = new TextPopupMenu();
        this._colDef = colDef;
        this._ta = CellComponentFactory.getJTextArea(colDef, value);
        if (isEditable) {
            this._ta.setEditable(true);
            this._ta.setBackground(Color.yellow);
        } else {
            this._ta.setEditable(false);
        }
        this._ta.setLineWrap(true);
        this._ta.setWrapStyleWord(true);
        this.setLayout(new BorderLayout());
        JPanel displayPanel = new JPanel();
        displayPanel.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(this._ta);
        displayPanel.add((Component)this.scrollPane, "Center");
        if (CellComponentFactory.useBinaryEditingPanel(colDef)) {
            String[] radixListData = new String[]{"Hex", "Decimal", "Octal", "Binary"};
            this.radixList = new JComboBox<String>(radixListData);
            this.radixList.addActionListener(this.optionActionListener);
            this.previousRadixListItem = "Hex";
            this.showAscii = new JCheckBox();
            this.previousShowAscii = false;
            this.showAscii.addActionListener(this.optionActionListener);
            JPanel displayControlsPanel = new JPanel();
            displayControlsPanel.add(new JLabel(s_stringMgr.getString("popupeditableIoPanel.numberBase")));
            displayControlsPanel.add(this.radixList);
            displayControlsPanel.add(new JLabel("    "));
            displayControlsPanel.add(this.showAscii);
            displayControlsPanel.add(new JLabel(s_stringMgr.getString("popupeditableIoPanel.showAscii")));
            displayPanel.add((Component)displayControlsPanel, "South");
        }
        this.add((Component)displayPanel, "Center");
        if (CellComponentFactory.canDoFileIO(colDef)) {
            this.add((Component)this.exportImportPanel(isEditable), "South");
        }
        this._popupMenu.add(new LineWrapAction());
        this._popupMenu.add(new WordWrapAction());
        this._popupMenu.add(new XMLReformatAction());
        this._popupMenu.setTextComponent(this._ta);
    }

    private JPanel exportImportPanel(boolean isEditable) {
        JPanel eiPanel = new JPanel();
        eiPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        eiPanel.add((Component)new JLabel(s_stringMgr.getString("popupeditableIoPanel.useFile")), gbc);
        gbc.fill = 2;
        gbc.weightx = 0.5;
        this.fileNameField = new JTextField("<temp file>", 17);
        Dimension preferredSize = this.fileNameField.getPreferredSize();
        this.fileNameField.setMinimumSize(new Dimension(preferredSize.width / 2, preferredSize.height));
        ++gbc.gridx;
        eiPanel.add((Component)this.fileNameField, gbc);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        JButton browseButton = new JButton(s_stringMgr.getString("popupeditableIoPanel.browse"));
        browseButton.setActionCommand("browse");
        browseButton.addActionListener(this);
        ++gbc.gridx;
        eiPanel.add((Component)browseButton, gbc);
        JButton exportButton = new JButton(s_stringMgr.getString("popupeditableIoPanel.export44"));
        exportButton.setActionCommand("export");
        exportButton.addActionListener(this);
        ++gbc.gridx;
        eiPanel.add((Component)exportButton, gbc);
        if (!isEditable) {
            return eiPanel;
        }
        JButton importButton = new JButton(s_stringMgr.getString("popupeditableIoPanel.import44"));
        importButton.setActionCommand("import");
        importButton.addActionListener(this);
        ++gbc.gridx;
        eiPanel.add((Component)importButton, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        eiPanel.add((Component)new JLabel(s_stringMgr.getString("popupeditableIoPanel.withCommand")), gbc);
        ++gbc.gridx;
        this.externalCommandCombo = new JComboBox<String>(CellImportExportInfoSaver.getInstance().getCmdList());
        this.externalCommandCombo.setSelectedIndex(-1);
        this.externalCommandCombo.setEditable(true);
        this.externalCommandCombo.setPreferredSize(this.fileNameField.getPreferredSize());
        this.externalCommandCombo.setMinimumSize(this.fileNameField.getMinimumSize());
        gbc.fill = 2;
        gbc.weightx = 0.5;
        eiPanel.add((Component)this.externalCommandCombo, gbc);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        JButton externalCommandButton = new JButton(s_stringMgr.getString("popupeditableIoPanel.execute34"));
        externalCommandButton.setActionCommand("execute");
        externalCommandButton.addActionListener(this);
        ++gbc.gridx;
        eiPanel.add((Component)externalCommandButton, gbc);
        JButton applyButton = new JButton(s_stringMgr.getString("popupeditableIoPanel.applyFile"));
        applyButton.setActionCommand("apply");
        applyButton.addActionListener(this);
        ++gbc.gridx;
        gbc.gridwidth = 2;
        eiPanel.add((Component)applyButton, gbc);
        gbc.gridwidth = 1;
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        eiPanel.add((Component)new JLabel(s_stringMgr.getString("popupeditableIoPanel.replaceFile", "%f")), gbc);
        CellImportExportInfo info = CellImportExportInfoSaver.getInstance().get(this._colDef.getFullTableColumnName());
        if (info != null) {
            this.fileNameField.setText(info.getFileName());
            this.externalCommandCombo.getEditor().setItem(info.getCommand());
        }
        return eiPanel;
    }

    public Object getObject(StringBuffer messageBuffer) {
        String text = null;
        try {
            text = this.getTextAreaCannonicalForm();
        }
        catch (Exception e) {
            messageBuffer.append("Failed to convert binary text; error was:\n" + e.getMessage());
            return null;
        }
        return CellComponentFactory.validateAndConvertInPopup(this._colDef, this.originalValue, text, messageBuffer);
    }

    @Override
    public void requestFocus() {
        this._ta.requestFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("browse")) {
            int returnVal;
            File f;
            String path;
            JFileChooser chooser = new JFileChooser();
            String filename = this.fileNameField.getText();
            if (filename != null && !"".equals(filename) && (path = (f = new File(filename)).getAbsolutePath()) != null && !"".equals(path)) {
                chooser.setCurrentDirectory(new File(path));
            }
            if ((returnVal = chooser.showOpenDialog(this)) == 0) {
                try {
                    this.fileNameField.setText(chooser.getSelectedFile().getCanonicalPath());
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, s_stringMgr.getString("popupeditableIoPanel.errorGettingPath"), s_stringMgr.getString("popupeditableIoPanel.fileChooserError"), 0);
                }
            }
        } else if (e.getActionCommand().equals("apply")) {
            if (this.fileNameField.getText() != null && this.fileNameField.getText().equals("<temp file>") && (this.externalCommandCombo.getEditor().getItem() == null || ((String)this.externalCommandCombo.getEditor().getItem()).length() == 0)) {
                CellImportExportInfoSaver.remove(this._colDef.getFullTableColumnName());
            } else {
                CellImportExportInfoSaver.getInstance().save(this._colDef.getFullTableColumnName(), this.fileNameField.getText(), (String)this.externalCommandCombo.getEditor().getItem());
            }
        } else if (e.getActionCommand().equals("import")) {
            File file;
            if (this.fileNameField.getText() == null || this.fileNameField.getText().equals("<temp file>")) {
                JOptionPane.showMessageDialog(this, s_stringMgr.getString("popupeditableIoPanel.selectImportDataFile"), s_stringMgr.getString("popupeditableIoPanel.noFile"), 0);
                return;
            }
            if (this.fileNameField.getText() == null) {
                this.fileNameField.setText("");
            }
            if (!((file = new File(this.fileNameField.getText())).exists() && file.isFile() && file.canRead())) {
                String msg = s_stringMgr.getString("popupeditableIoPanel.fileDoesNotExist", this.fileNameField.getText());
                JOptionPane.showMessageDialog(this, msg, s_stringMgr.getString("popupeditableIoPanel.fileError"), 0);
                return;
            }
            this.importData(file);
            CellImportExportInfoSaver.getInstance().save(this._colDef.getFullTableColumnName(), this.fileNameField.getText(), (String)this.externalCommandCombo.getEditor().getItem());
        } else {
            FileOutputStream outStream;
            File file;
            String canonicalFilePathName = this.fileNameField.getText();
            if (this.fileNameField.getText() == null || this.fileNameField.getText().equals("")) {
                JOptionPane.showMessageDialog(this, s_stringMgr.getString("popupeditableIoPanel.noExportFile"), s_stringMgr.getString("popupeditableIoPanel.exportError"), 0);
                return;
            }
            if (this.fileNameField.getText().equals("<temp file>")) {
                try {
                    file = File.createTempFile("squirrel", ".tmp");
                    canonicalFilePathName = file.getCanonicalPath();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, s_stringMgr.getString("popupeditableIoPanel.cannotCreateTempFile", ex.getMessage()), s_stringMgr.getString("popupeditableIoPanel.exportError2"), 0);
                    return;
                }
            }
            file = new File(this.fileNameField.getText());
            try {
                canonicalFilePathName = file.getCanonicalPath();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, s_stringMgr.getString("popupeditableIoPanel.cannotAccessFile", this.fileNameField.getText()), s_stringMgr.getString("popupeditableIoPanel.exportError3"), 0);
                return;
            }
            if (file.exists()) {
                if (!file.isFile()) {
                    JOptionPane.showMessageDialog(this, s_stringMgr.getString("popupeditableIoPanel.notANormalFile"), s_stringMgr.getString("popupeditableIoPanel.exportError4"), 0);
                    return;
                }
                if (!file.canWrite()) {
                    JOptionPane.showMessageDialog(this, s_stringMgr.getString("popupeditableIoPanel.notWriteable"), s_stringMgr.getString("popupeditableIoPanel.exportError5"), 0);
                    return;
                }
                int option = JOptionPane.showConfirmDialog(this, s_stringMgr.getString("popupeditableIoPanel.fileOverwrite", canonicalFilePathName), s_stringMgr.getString("popupeditableIoPanel.overwriteWarning"), 0);
                if (option != 0) {
                    return;
                }
            } else {
                try {
                    if (!file.createNewFile()) {
                        JOptionPane.showMessageDialog(this, s_stringMgr.getString("popupeditableIoPanel.createFileError", canonicalFilePathName), s_stringMgr.getString("popupeditableIoPanel.exportError6"), 0);
                        return;
                    }
                }
                catch (Exception ex) {
                    Object[] args = new Object[]{canonicalFilePathName, ex.getMessage()};
                    JOptionPane.showMessageDialog(this, s_stringMgr.getString("popupeditableIoPanel.cannotOpenFile", args), s_stringMgr.getString("popupeditableIoPanel.exportError7"), 0);
                    return;
                }
            }
            try {
                outStream = new FileOutputStream(file);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, s_stringMgr.getString("popupeditableIoPanel.cannotFindFile", canonicalFilePathName), s_stringMgr.getString("popupeditableIoPanel.exportError8"), 0);
                return;
            }
            String extCmdComboItemStr = null;
            if (this.externalCommandCombo != null && this.externalCommandCombo.getEditor() != null) {
                extCmdComboItemStr = (String)this.externalCommandCombo.getEditor().getItem();
            }
            if (!"<temp file>".equals(this.fileNameField.getText()) || extCmdComboItemStr != null && extCmdComboItemStr.length() > 0) {
                String commandString = extCmdComboItemStr;
                CellImportExportInfoSaver.getInstance().save(this._colDef.getFullTableColumnName(), this.fileNameField.getText(), commandString);
            }
            if (e.getActionCommand().equals("export")) {
                if (this.exportData(outStream, canonicalFilePathName)) {
                    JOptionPane.showMessageDialog(this, s_stringMgr.getString("popupeditableIoPanel.exportedToFile", canonicalFilePathName), s_stringMgr.getString("popupeditableIoPanel.exportSuccess"), 1);
                }
            } else if (e.getActionCommand().equals("execute")) {
                int option;
                int commandResult;
                int index;
                if ((String)this.externalCommandCombo.getEditor().getItem() == null || ((String)this.externalCommandCombo.getEditor().getItem()).length() == 0) {
                    JOptionPane.showMessageDialog(this, s_stringMgr.getString("popupeditableIoPanel.cannotExec"), s_stringMgr.getString("popupeditableIoPanel.executeError"), 0);
                    return;
                }
                String command = (String)this.externalCommandCombo.getEditor().getItem();
                while ((index = command.indexOf("%f")) >= 0) {
                    command = command.substring(0, index) + canonicalFilePathName + command.substring(index + "%f".length());
                }
                if (!this.exportData(outStream, canonicalFilePathName)) {
                    return;
                }
                BufferedReader err = null;
                try {
                    Process cmdProcess = Runtime.getRuntime().exec(command);
                    commandResult = cmdProcess.waitFor();
                    err = new BufferedReader(new InputStreamReader(cmdProcess.getErrorStream()));
                    String errMsg = err.readLine();
                    if (errMsg != null) {
                        throw new IOException("text on error stream from command starting with:\n" + errMsg);
                    }
                    this._iou.closeReader(err);
                }
                catch (Exception ex) {
                    try {
                        Object[] args = new Object[]{command, ex.getMessage()};
                        JOptionPane.showMessageDialog(this, s_stringMgr.getString("popupeditableIoPanel.errWhileExecutin", args), s_stringMgr.getString("popupeditableIoPanel.executeError2"), 0);
                        this._iou.closeReader(err);
                        return;
                    }
                    catch (Throwable throwable) {
                        this._iou.closeReader(err);
                        throw throwable;
                    }
                }
                if (commandResult != 0 && (option = JOptionPane.showConfirmDialog(this, s_stringMgr.getString("popupeditableIoPanel.commandReturnNot0", commandResult), s_stringMgr.getString("popupeditableIoPanel.importWarning"), 0)) != 0) {
                    return;
                }
                this.importData(file);
                file.delete();
            }
        }
    }

    private void importData(File file) {
        FileInputStream inStream;
        String canonicalFilePathName = this.fileNameField.getText();
        try {
            inStream = new FileInputStream(file);
            canonicalFilePathName = file.getCanonicalPath();
        }
        catch (Exception ex) {
            Object[] args = new Object[]{canonicalFilePathName, ex.getMessage()};
            JOptionPane.showMessageDialog(this, s_stringMgr.getString("popupeditableIoPanel.fileOpenError", args), s_stringMgr.getString("popupeditableIoPanel.fileOpenErrorHeader"), 0);
            return;
        }
        try {
            String replacementText = CellComponentFactory.importObject(this._colDef, inStream);
            if (this.radixList != null && (!this.radixList.getSelectedItem().equals("Hex") || this.showAscii.isSelected())) {
                int base = 16;
                if (this.radixList.getSelectedItem().equals("Decimal")) {
                    base = 10;
                } else if (this.radixList.getSelectedItem().equals("Octal")) {
                    base = 8;
                } else if (this.radixList.getSelectedItem().equals("Binary")) {
                    base = 2;
                }
                Byte[] bytes = BinaryDisplayConverter.convertToBytes(replacementText, 16, false);
                replacementText = BinaryDisplayConverter.convertToString(bytes, base, this.showAscii.isSelected());
            }
            ((RestorableJTextArea)this._ta).updateText(replacementText);
        }
        catch (Exception ex) {
            Object[] args = new Object[]{canonicalFilePathName, ex.getMessage()};
            JOptionPane.showMessageDialog(this, s_stringMgr.getString("popupeditableIoPanel.errorReadingFile", args), s_stringMgr.getString("popupeditableIoPanel.importError2"), 0);
            return;
        }
        try {
            inStream.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private boolean exportData(FileOutputStream outStream, String canonicalFilePathName) {
        try {
            CellComponentFactory.exportObject(this._colDef, outStream, this.getTextAreaCannonicalForm());
        }
        catch (Exception ex) {
            Object[] args = new Object[]{canonicalFilePathName, ex.getMessage()};
            JOptionPane.showMessageDialog(this, s_stringMgr.getString("popupeditableIoPanel.errorWritingFile", args), s_stringMgr.getString("popupeditableIoPanel.exportError100"), 0);
            return false;
        }
        return true;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this._lis == null) {
            this._lis = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (evt.isPopupTrigger()) {
                        PopupEditableIOPanel.this._popupMenu.show(evt);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    if (evt.isPopupTrigger()) {
                        PopupEditableIOPanel.this._popupMenu.show(evt);
                    }
                }
            };
            this._ta.addMouseListener(this._lis);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this._lis != null) {
            this._ta.removeMouseListener(this._lis);
            this._lis = null;
        }
    }

    private String getTextAreaCannonicalForm() {
        if (this._ta.getText() == null || this._ta.getText().equals("<null>") || this._ta.getText().length() == 0) {
            return this._ta.getText();
        }
        if (this.radixList == null || this.radixList.getSelectedItem().equals("Hex") && !this.showAscii.isSelected()) {
            return this._ta.getText();
        }
        int base = 16;
        if (this.radixList.getSelectedItem().equals("Decimal")) {
            base = 10;
        } else if (this.radixList.getSelectedItem().equals("Octal")) {
            base = 8;
        } else if (this.radixList.getSelectedItem().equals("Binary")) {
            base = 2;
        }
        Byte[] bytes = BinaryDisplayConverter.convertToBytes(this._ta.getText(), base, this.showAscii.isSelected());
        return BinaryDisplayConverter.convertToString(bytes, 16, false);
    }

    private class XMLReformatAction
    extends BaseAction {
        private static final long serialVersionUID = 1L;

        XMLReformatAction() {
            super(s_stringMgr.getString("popupEditableIoPanel.reformatXml"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (PopupEditableIOPanel.this._ta != null) {
                PopupEditableIOPanel.this._ta.setText(XmlRefomatter.reformatXml(PopupEditableIOPanel.this._ta.getText()));
            }
        }
    }

    private class WordWrapAction
    extends BaseAction {
        private static final long serialVersionUID = 1L;

        WordWrapAction() {
            super(s_stringMgr.getString("popupEditableIoPanel.wrapWord"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (PopupEditableIOPanel.this._ta != null) {
                PopupEditableIOPanel.this._ta.setWrapStyleWord(!PopupEditableIOPanel.this._ta.getWrapStyleWord());
            }
        }
    }

    private class LineWrapAction
    extends BaseAction {
        LineWrapAction() {
            super(s_stringMgr.getString("popupEditableIoPanel.wrapLines"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (PopupEditableIOPanel.this._ta != null) {
                PopupEditableIOPanel.this._ta.setLineWrap(!PopupEditableIOPanel.this._ta.getLineWrap());
            }
        }
    }

    class BinaryOptionActionListener
    implements ActionListener {
        BinaryOptionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int base = 16;
            if (PopupEditableIOPanel.this.previousRadixListItem.equals("Decimal")) {
                base = 10;
            } else if (PopupEditableIOPanel.this.previousRadixListItem.equals("Octal")) {
                base = 8;
            } else if (PopupEditableIOPanel.this.previousRadixListItem.equals("Binary")) {
                base = 2;
            }
            Byte[] bytes = BinaryDisplayConverter.convertToBytes(PopupEditableIOPanel.this._ta.getText(), base, PopupEditableIOPanel.this.previousShowAscii);
            base = 16;
            if (PopupEditableIOPanel.this.radixList.getSelectedItem().equals("Decimal")) {
                base = 10;
            } else if (PopupEditableIOPanel.this.radixList.getSelectedItem().equals("Octal")) {
                base = 8;
            } else if (PopupEditableIOPanel.this.radixList.getSelectedItem().equals("Binary")) {
                base = 2;
            }
            ((RestorableJTextArea)PopupEditableIOPanel.this._ta).updateText(BinaryDisplayConverter.convertToString(bytes, base, PopupEditableIOPanel.this.showAscii.isSelected()));
            PopupEditableIOPanel.this.previousRadixListItem = (String)PopupEditableIOPanel.this.radixList.getSelectedItem();
            PopupEditableIOPanel.this.previousShowAscii = PopupEditableIOPanel.this.showAscii.isSelected();
        }
    }
}

