/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DTProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeBigDecimal;
import net.sourceforge.squirrel_sql.fw.gui.IntegerField;
import net.sourceforge.squirrel_sql.fw.gui.OkJPanel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import org.apache.commons.lang.StringUtils;

public abstract class FloatingPointBase
extends BaseDataTypeComponent {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(FloatingPointBase.class);
    private static boolean propertiesAlreadyLoaded = false;
    protected static boolean useJavaDefaultFormat = false;
    protected static int maximumFractionDigits = 5;

    public static OkJPanel getControlPanel() {
        FloatingPointBase.loadProperties();
        return new FloatingPointOkJPanel();
    }

    public FloatingPointBase() {
        FloatingPointBase.loadProperties();
    }

    private static void loadProperties() {
        if (!propertiesAlreadyLoaded) {
            useJavaDefaultFormat = false;
            String useJavaDefaultFormatString = DTProperties.get(DataTypeBigDecimal.class.getName(), "useJavaDefaultFormat");
            if (useJavaDefaultFormatString != null && useJavaDefaultFormatString.equals("true")) {
                useJavaDefaultFormat = true;
            }
            maximumFractionDigits = 5;
            String maximumFractionDigitsString = DTProperties.get(DataTypeBigDecimal.class.getName(), "maximumFractionDigits");
            if (!StringUtils.isEmpty(maximumFractionDigitsString)) {
                maximumFractionDigits = Integer.valueOf(maximumFractionDigitsString);
            }
        }
    }

    private static class FloatingPointOkJPanel
    extends OkJPanel {
        private static final long serialVersionUID = 3745853322636427759L;
        JRadioButton optUseDefaultFormat = new JRadioButton(FloatingPointBase.access$000().getString("floatingPointBase.useDefaultFormat", new Double(3.14159).toString()));
        JRadioButton optUseLocaleDependendFormat = new JRadioButton(this.createTextForOptUseLocaleDependendFormat(maximumFractionDigits));
        IntegerField maximumFraction = new IntegerField(2);

        public FloatingPointOkJPanel() {
            this.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("floatingPointBase.typeBigDecimal")));
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0);
            this.add((Component)this.optUseLocaleDependendFormat, gbc);
            gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(4, 4, 4, 4), 0, 0);
            this.add((Component)this.maximumFraction, gbc);
            gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 4, 4, 4), 0, 0);
            this.add((Component)this.optUseDefaultFormat, gbc);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.optUseDefaultFormat);
            bg.add(this.optUseLocaleDependendFormat);
            this.optUseLocaleDependendFormat.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (FloatingPointOkJPanel.this.optUseLocaleDependendFormat.isSelected()) {
                        FloatingPointOkJPanel.this.maximumFraction.setEditable(true);
                        FloatingPointOkJPanel.this.maximumFraction.setEnabled(true);
                    }
                }
            });
            this.optUseDefaultFormat.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (FloatingPointOkJPanel.this.optUseDefaultFormat.isSelected()) {
                        FloatingPointOkJPanel.this.maximumFraction.setEditable(false);
                        FloatingPointOkJPanel.this.maximumFraction.setEnabled(false);
                    }
                }
            });
            this.maximumFraction.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    FloatingPointOkJPanel.this.optUseLocaleDependendFormat.setText(FloatingPointOkJPanel.this.createTextForOptUseLocaleDependendFormat(FloatingPointOkJPanel.this.maximumFraction.getInt()));
                    FloatingPointOkJPanel.this.maximumFraction.repaint();
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.optUseLocaleDependendFormat.setSelected(!useJavaDefaultFormat);
            this.optUseDefaultFormat.setSelected(useJavaDefaultFormat);
            this.maximumFraction.setInt(maximumFractionDigits);
        }

        private String createTextForOptUseLocaleDependendFormat(int maxFractionDigits) {
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(maxFractionDigits);
            return s_stringMgr.getString("floatingPointBase.uselocaleDependendFormat", numberFormat.format(new Double(3.14159)));
        }

        @Override
        public void ok() {
            useJavaDefaultFormat = this.optUseDefaultFormat.isSelected();
            DTProperties.put(DataTypeBigDecimal.class.getName(), "useJavaDefaultFormat", Boolean.valueOf(useJavaDefaultFormat).toString());
            maximumFractionDigits = this.maximumFraction.getInt();
            DTProperties.put(DataTypeBigDecimal.class.getName(), "maximumFractionDigits", Integer.valueOf(maximumFractionDigits).toString());
        }
    }
}

