/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.dialects;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.dialects.CommonHibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.CreateScriptPreferences;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.dialects.DialectUtils;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.SqlGenerationPreferences;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.JDBCTypeMapper;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import org.antlr.stringtemplate.StringTemplate;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Oracle9Dialect;

public class OracleDialectExt
extends CommonHibernateDialect
implements HibernateDialect {
    private OracleDialectHelper _dialect = new OracleDialectHelper();

    @Override
    public String getTypeName(int code, int length, int precision, int scale) throws HibernateException {
        return this._dialect.getTypeName(code, length, precision, scale);
    }

    @Override
    public int getJavaTypeForNativeType(String nativeColumnTypeName) {
        if (nativeColumnTypeName.toLowerCase().equals("nvarchar2")) {
            return -9;
        }
        if (nativeColumnTypeName.toLowerCase().equals("nchar")) {
            return -15;
        }
        if (nativeColumnTypeName.toLowerCase().equals("nclob")) {
            return 2011;
        }
        if (nativeColumnTypeName.toLowerCase().startsWith("TIMESTAMP")) {
            return 93;
        }
        return super.getJavaTypeForNativeType(nativeColumnTypeName);
    }

    @Override
    public boolean canPasteTo(IDatabaseObjectInfo info) {
        boolean result = true;
        DatabaseObjectType type = info.getDatabaseObjectType();
        if (type.getName().equalsIgnoreCase("database")) {
            result = false;
        }
        return result;
    }

    @Override
    public int getMaxPrecision(int dataType) {
        if (dataType == 8 || dataType == 6) {
            return 53;
        }
        return 38;
    }

    @Override
    public String getDisplayName() {
        return "Oracle";
    }

    @Override
    public boolean supportsProduct(String databaseProductName, String databaseProductVersion) {
        if (databaseProductName == null) {
            return false;
        }
        return databaseProductName.trim().toLowerCase().startsWith("oracle");
    }

    @Override
    public boolean supportsColumnComment() {
        return true;
    }

    @Override
    public String getColumnCommentAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        return DialectUtils.getColumnCommentAlterSQL(info, qualifier, prefs, this);
    }

    @Override
    public boolean supportsDropColumn() {
        return true;
    }

    @Override
    public String getColumnDropSQL(String tableName, String columnName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuffer result = new StringBuffer();
        result.append("ALTER TABLE ");
        result.append(DialectUtils.shapeQualifiableIdentifier(tableName, qualifier, prefs, this));
        result.append(" DROP COLUMN ");
        result.append(columnName);
        return result.toString();
    }

    @Override
    public List<String> getTableDropSQL(ITableInfo ti, boolean cascadeConstraints, boolean isMaterializedView, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String cascadeClause = "";
        if (!isMaterializedView) {
            cascadeClause = "CASCADE CONSTRAINTS";
        }
        return DialectUtils.getTableDropSQL(ti, true, cascadeConstraints, true, cascadeClause, isMaterializedView, qualifier, prefs, this);
    }

    @Override
    public String[] getAddPrimaryKeySQL(String pkName, TableColumnInfo[] columns, ITableInfo ti, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuffer result = new StringBuffer();
        result.append("ALTER TABLE ");
        result.append(DialectUtils.shapeQualifiableIdentifier(ti.getSimpleName(), qualifier, prefs, this));
        result.append(" ADD CONSTRAINT ");
        result.append(pkName);
        result.append(" PRIMARY KEY (");
        for (int i = 0; i < columns.length; ++i) {
            result.append(columns[i].getColumnName());
            if (i + 1 >= columns.length) continue;
            result.append(", ");
        }
        result.append(")");
        return new String[]{result.toString()};
    }

    @Override
    public String[] getColumnNullableAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuffer result = new StringBuffer();
        result.append("ALTER TABLE ");
        result.append(info.getTableName());
        result.append(" MODIFY ");
        result.append(info.getColumnName());
        if (info.isNullable().equals("YES")) {
            result.append(" NULL");
        } else {
            result.append(" NOT NULL");
        }
        return new String[]{result.toString()};
    }

    @Override
    public boolean supportsRenameColumn() {
        return true;
    }

    @Override
    public String getColumnNameAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("ALTER TABLE $tableName$ RENAME COLUMN $oldColumnName$ to $newColumnName$");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("tableName", from.getTableName(), "oldColumnName", from.getColumnName(), "newColumnName", to.getColumnName());
        return DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs);
    }

    @Override
    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    public List<String> getColumnTypeAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        ArrayList<String> result = new ArrayList<String>();
        if (from.getDataType() == 12 && to.getDataType() == 2005 || from.getDataType() == 2005 && to.getDataType() == 12) {
            TableColumnInfo newInfo = DialectUtils.getRenamedColumn(to, to.getColumnName() + "_2");
            String[] addSQL = this.getAddColumnSQL(newInfo, qualifier, prefs);
            for (int i = 0; i < addSQL.length; ++i) {
                result.add(addSQL[i]);
            }
            StringBuilder updateSQL = new StringBuilder();
            updateSQL.append("update ");
            updateSQL.append(from.getTableName());
            updateSQL.append(" set ");
            updateSQL.append(newInfo.getColumnName());
            updateSQL.append(" = ");
            updateSQL.append(from.getColumnName());
            result.add(updateSQL.toString());
            String dropSQL = this.getColumnDropSQL(from.getTableName(), from.getColumnName(), qualifier, prefs);
            result.add(dropSQL);
            String renameSQL = this.getColumnNameAlterSQL(newInfo, to, qualifier, prefs);
            result.add(renameSQL);
        } else {
            StringBuffer tmp = new StringBuffer();
            tmp.append("ALTER TABLE ");
            tmp.append(from.getTableName());
            tmp.append(" MODIFY (");
            tmp.append(from.getColumnName());
            tmp.append(" ");
            tmp.append(DialectUtils.getTypeName(to, this));
            tmp.append(")");
            result.add(tmp.toString());
        }
        return result;
    }

    @Override
    public boolean supportsAlterColumnNull() {
        return true;
    }

    @Override
    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    public String getColumnDefaultAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuffer result = new StringBuffer();
        result.append("ALTER TABLE ");
        result.append(DialectUtils.shapeQualifiableIdentifier(info.getTableName(), qualifier, prefs, this));
        result.append(" MODIFY ");
        result.append(info.getColumnName());
        result.append(" DEFAULT ");
        if (JDBCTypeMapper.isNumberType(info.getDataType())) {
            result.append(info.getDefaultValue());
        } else {
            result.append("'");
            result.append(info.getDefaultValue());
            result.append("'");
        }
        return result.toString();
    }

    @Override
    public String getDropPrimaryKeySQL(String pkName, String tableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropPrimaryKeySQL(pkName, tableName, false, false, qualifier, prefs, this);
    }

    @Override
    public String getDropForeignKeySQL(String fkName, String tableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropForeignKeySQL(fkName, tableName, qualifier, prefs, this);
    }

    @Override
    public List<String> getCreateTableSQL(List<ITableInfo> tables, ISQLDatabaseMetaData md, CreateScriptPreferences prefs, boolean isJdbcOdbc) throws SQLException {
        prefs.setUpdateRefAction(true);
        prefs.setUpdateAction(3);
        return DialectUtils.getCreateTableSQL(tables, md, this, prefs, isJdbcOdbc);
    }

    @Override
    public DialectType getDialectType() {
        return DialectType.ORACLE;
    }

    @Override
    public String[] getIndexAccessMethodsTypes() {
        return new String[]{"default", "unique", "bitmap"};
    }

    @Override
    public String[] getIndexStorageOptions() {
        return null;
    }

    @Override
    public String[] getAddAutoIncrementSQL(TableColumnInfo column, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String seqName = column.getColumnName() + "_AUTOINC_SEQ";
        String sequenceSql = this.getCreateSequenceSQL(seqName, "1", "1", null, "1", null, false, qualifier, prefs);
        String tableName = column.getTableName();
        String trigName = column.getColumnName() + "_AUTOINC_TRIG";
        String triggerTemplateStr = "CREATE OR REPLACE TRIGGER $triggerName$ \nBEFORE INSERT ON $tableName$ \nFOR EACH ROW \nDECLARE \n    nextid number(8) := 0; \nBEGIN \n    SELECT $sequenceName$.nextval into nextid from dual; \n    :new.$columnName$ := nextid; \nEND; ";
        StringTemplate st = new StringTemplate(triggerTemplateStr);
        st.setAttribute("triggerName", trigName);
        st.setAttribute("tableName", tableName);
        st.setAttribute("sequenceName", seqName);
        st.setAttribute("columnName", column.getColumnName());
        return new String[]{sequenceSql, st.toString()};
    }

    @Override
    public String[] getAddColumnSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        boolean addDefaultClause = true;
        boolean supportsNullQualifier = true;
        boolean addNullClause = true;
        prefs.setQuoteColumnNames(false);
        String addColumnSql = DialectUtils.getAddColumSQL(info, this, addDefaultClause, supportsNullQualifier, addNullClause, qualifier, prefs);
        if (info.getRemarks() != null && !"".equals(info.getRemarks())) {
            return new String[]{addColumnSql, DialectUtils.getColumnCommentAlterSQL(info, qualifier, prefs, this)};
        }
        return new String[]{addColumnSql};
    }

    @Override
    public String[] getAddForeignKeyConstraintSQL(String localTableName, String refTableName, String constraintName, Boolean deferrable, Boolean initiallyDeferred, Boolean matchFull, boolean autoFKIndex, String fkIndexName, Collection<String[]> localRefColumns, String onUpdateAction, String onDeleteAction, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String onUpdateNotSupported = null;
        String onDeleteNoAction = null;
        Boolean matchFullNotSupported = null;
        return DialectUtils.getAddForeignKeyConstraintSQL(localTableName, refTableName, constraintName, deferrable, initiallyDeferred, matchFullNotSupported, autoFKIndex, fkIndexName, localRefColumns, onUpdateNotSupported, onDeleteNoAction, qualifier, prefs, this);
    }

    @Override
    public String[] getAddUniqueConstraintSQL(String tableName, String constraintName, TableColumnInfo[] columns, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        prefs.setQuoteConstraintNames(false);
        prefs.setQuoteColumnNames(false);
        return new String[]{DialectUtils.getAddUniqueConstraintSQL(tableName, constraintName, columns, qualifier, prefs, (HibernateDialect)this)};
    }

    @Override
    public String[] getAlterSequenceSQL(String sequenceName, String increment, String minimum, String maximum, String restart, String cache, boolean cycle, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String cycleClause;
        String[] result = null;
        Boolean cascadeNotSupported = null;
        String string = cycleClause = cycle ? "CYCLE" : "NOCYCLE";
        if (restart != null) {
            String comment = "-- Oracle cannot change the start value of a sequence.";
            String comment2 = "-- Must drop and re-create.";
            String dropSql = DialectUtils.getDropSequenceSQL(sequenceName, cascadeNotSupported, qualifier, prefs, this);
            String createSql = DialectUtils.getCreateSequenceSQL(sequenceName, increment, minimum, maximum, restart, cache, cycleClause, qualifier, prefs, this);
            result = new String[]{comment, comment2, dropSql, createSql};
        } else {
            String restartNotSupported = null;
            String sql = DialectUtils.getAlterSequenceSQL(sequenceName, increment, minimum, maximum, restartNotSupported, cache, cycleClause, qualifier, prefs, this);
            result = new String[]{sql};
        }
        return result;
    }

    @Override
    public String getCreateIndexSQL(String indexName, String tableName, String accessMethod, String[] columns, boolean unique, String tablespace, String constraints, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuilder result = new StringBuilder();
        result.append("CREATE ");
        if (unique && !accessMethod.equalsIgnoreCase("bitmap")) {
            result.append("UNIQUE ");
        }
        if (accessMethod != null && accessMethod.equalsIgnoreCase("bitmap")) {
            result.append(accessMethod);
            result.append(" ");
        }
        result.append("INDEX ");
        result.append(DialectUtils.shapeQualifiableIdentifier(indexName, qualifier, prefs, this));
        result.append(" ON ");
        result.append(DialectUtils.shapeQualifiableIdentifier(tableName, qualifier, prefs, this));
        result.append("(");
        for (String column : columns) {
            result.append(column);
            result.append(",");
        }
        result.setLength(result.length() - 1);
        result.append(")");
        return result.toString();
    }

    @Override
    public String getCreateSequenceSQL(String sequenceName, String increment, String minimum, String maximum, String start, String cache, boolean cycle, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String minValue = minimum;
        String minClause = "MINVALUE";
        if (minValue == null || "".equals(minValue)) {
            minValue = "NOMINVALUE";
            minClause = "";
        }
        String maxValue = maximum;
        String maxClause = "MAXVALUE";
        if (maxValue == null || "".equals(maxValue)) {
            maxValue = "NOMAXVALUE";
            maxClause = "";
        }
        return DialectUtils.getCreateSequenceSQL(sequenceName, increment, minClause, minValue, maxClause, maxValue, start, cache, null, qualifier, prefs, this);
    }

    @Override
    public String getCreateTableSQL(String tableName, List<TableColumnInfo> columns, List<TableColumnInfo> primaryKeys, SqlGenerationPreferences prefs, DatabaseObjectQualifier qualifier) {
        return DialectUtils.getCreateTableSQL(tableName, columns, primaryKeys, prefs, qualifier, this);
    }

    @Override
    public String getCreateViewSQL(String viewName, String definition, String checkOption, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getCreateViewSQL(viewName, definition, checkOption, qualifier, prefs, this);
    }

    @Override
    public String getDropConstraintSQL(String tableName, String constraintName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropConstraintSQL(tableName, constraintName, qualifier, prefs, this);
    }

    @Override
    public String getDropIndexSQL(String tableName, String indexName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        Boolean cascadeNotSupported = null;
        return DialectUtils.getDropIndexSQL(indexName, cascadeNotSupported, qualifier, prefs, this);
    }

    @Override
    public String getDropSequenceSQL(String sequenceName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        Boolean cascadeNotSupported = null;
        return DialectUtils.getDropSequenceSQL(sequenceName, cascadeNotSupported, qualifier, prefs, this);
    }

    @Override
    public String getDropViewSQL(String viewName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        Boolean cascadeNotSupported = null;
        return DialectUtils.getDropViewSQL(viewName, cascadeNotSupported, qualifier, prefs, this);
    }

    @Override
    public String getInsertIntoSQL(String tableName, List<String> columns, String query, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getInsertIntoSQL(tableName, columns, query, qualifier, prefs, this);
    }

    @Override
    public String getRenameTableSQL(String oldTableName, String newTableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getRenameTableSQL(oldTableName, newTableName, qualifier, prefs, this);
    }

    @Override
    public String[] getRenameViewSQL(String oldViewName, String newViewName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return new String[]{DialectUtils.getRenameViewSQL("RENAME", "TO", oldViewName, newViewName, qualifier, prefs, this)};
    }

    @Override
    public String getSequenceInformationSQL(String sequenceName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuilder result = new StringBuilder();
        result.append("SELECT last_number, max_value, min_value, cache_size, increment_by, ");
        result.append("case cycle_flag when 'N' then 0 else 1 end as cycle_flag ");
        result.append("FROM USER_SEQUENCES ");
        result.append("WHERE sequence_name = upper(?)");
        return result.toString();
    }

    @Override
    public boolean supportsAccessMethods() {
        return true;
    }

    @Override
    public boolean supportsAddForeignKeyConstraint() {
        return true;
    }

    @Override
    public boolean supportsAddUniqueConstraint() {
        return true;
    }

    @Override
    public boolean supportsAlterSequence() {
        return true;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    @Override
    public boolean supportsCheckOptionsForViews() {
        return false;
    }

    @Override
    public boolean supportsCreateIndex() {
        return true;
    }

    @Override
    public boolean supportsCreateSequence() {
        return true;
    }

    @Override
    public boolean supportsCreateTable() {
        return true;
    }

    @Override
    public boolean supportsCreateView() {
        return true;
    }

    @Override
    public boolean supportsDropConstraint() {
        return true;
    }

    @Override
    public boolean supportsDropIndex() {
        return true;
    }

    @Override
    public boolean supportsDropSequence() {
        return true;
    }

    @Override
    public boolean supportsDropView() {
        return true;
    }

    @Override
    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsIndexes() {
        return true;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @Override
    public boolean supportsMultipleRowInserts() {
        return false;
    }

    @Override
    public boolean supportsRenameTable() {
        return true;
    }

    @Override
    public boolean supportsRenameView() {
        return true;
    }

    @Override
    public boolean supportsSequence() {
        return true;
    }

    @Override
    public boolean supportsSequenceInformation() {
        return true;
    }

    @Override
    public boolean supportsTablespace() {
        return true;
    }

    @Override
    public boolean supportsUpdate() {
        return true;
    }

    @Override
    public boolean supportsAddColumn() {
        return true;
    }

    @Override
    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public String getViewDefinitionSQL(String viewName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuilder result = new StringBuilder();
        result.append("select  'CREATE OR REPLACE VIEW ' || VIEW_NAME ||' AS ', TEXT ");
        result.append("FROM SYS.ALL_VIEWS ");
        result.append("WHERE OWNER = ");
        result.append("'");
        result.append(qualifier.getSchema());
        result.append("'");
        result.append(" AND VIEW_NAME = ");
        result.append("'");
        result.append(viewName);
        result.append("'");
        return result.toString();
    }

    @Override
    public String getQualifiedIdentifier(String identifier, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return identifier;
    }

    @Override
    public boolean supportsCorrelatedSubQuery() {
        return true;
    }

    private class OracleDialectHelper
    extends Oracle9Dialect {
        public OracleDialectHelper() {
            this.registerColumnType(-5, "number($p)");
            this.registerColumnType(-2, 2000, "raw($l)");
            this.registerColumnType(-2, "blob");
            this.registerColumnType(-7, "smallint");
            this.registerColumnType(2004, "blob");
            this.registerColumnType(16, "smallint");
            this.registerColumnType(1, 2000, "char($l)");
            this.registerColumnType(1, 4000, "varchar2($l)");
            this.registerColumnType(1, "clob");
            this.registerColumnType(2005, "clob");
            this.registerColumnType(2011, "nclob");
            this.registerColumnType(91, "date");
            this.registerColumnType(3, "decimal($p)");
            this.registerColumnType(8, "float($p)");
            this.registerColumnType(6, "float($p)");
            this.registerColumnType(4, "int");
            this.registerColumnType(-16, 2000, "nvarchar2($l)");
            this.registerColumnType(-16, "nclob");
            this.registerColumnType(-4, "blob");
            this.registerColumnType(-1, 4000, "varchar2($l)");
            this.registerColumnType(-1, "clob");
            this.registerColumnType(-15, 2000, "nchar($l)");
            this.registerColumnType(2, "number($p)");
            this.registerColumnType(-9, 2000, "nvarchar2($l)");
            this.registerColumnType(-9, "nclob");
            this.registerColumnType(7, "real");
            this.registerColumnType(5, "smallint");
            this.registerColumnType(92, "date");
            this.registerColumnType(93, "timestamp");
            this.registerColumnType(-6, "smallint");
            this.registerColumnType(-3, "blob");
            this.registerColumnType(12, 4000, "varchar2($l)");
            this.registerColumnType(12, "clob");
            this.registerColumnType(1111, 4000, "varchar2(4000)");
            this.registerColumnType(1111, "clob");
        }
    }
}

