/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.util.ArrayList;
import java.util.TooManyListenersException;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.fw.gui.TreeDnDHandlerCallback;

public class TreeDnDHandler {
    private JTree _tree;
    private TreeDnDHandlerCallback _treeDnDHandlerCallback;

    public TreeDnDHandler(JTree tree, TreeDnDHandlerCallback treeDnDHandlerCallback) {
        this._tree = tree;
        this._treeDnDHandlerCallback = treeDnDHandlerCallback;
        this.initDnD();
    }

    private void initDnD() {
        try {
            this._tree.setDragEnabled(true);
            DropTarget dt = new DropTarget();
            dt.addDropTargetListener(new DropTargetAdapter(){

                @Override
                public void drop(DropTargetDropEvent dtde) {
                    TreeDnDHandler.this.onDrop(dtde);
                }
            });
            this._tree.setDropTarget(dt);
        }
        catch (TooManyListenersException e) {
            throw new RuntimeException(e);
        }
    }

    private void onDrop(DropTargetDropEvent dtde) {
        if (!dtde.isLocalTransfer()) {
            return;
        }
        TreePath targetPath = this._tree.getPathForLocation(dtde.getLocation().x, dtde.getLocation().y);
        TreePath[] toPaste = this._tree.getSelectionPaths();
        if (0 != (3 & dtde.getDropAction())) {
            this.execCut(toPaste, targetPath);
            this._treeDnDHandlerCallback.dndExecuted();
        }
    }

    public void execCut(TreePath[] pathsToPaste, TreePath targetPath) {
        int i;
        DefaultTreeModel dtm = (DefaultTreeModel)this._tree.getModel();
        ArrayList<DefaultMutableTreeNode> cutNodes = new ArrayList<DefaultMutableTreeNode>();
        for (int i2 = 0; i2 < pathsToPaste.length; ++i2) {
            if (pathsToPaste[i2].equals(targetPath)) continue;
            DefaultMutableTreeNode cutNode = (DefaultMutableTreeNode)pathsToPaste[i2].getLastPathComponent();
            cutNodes.add(cutNode);
            dtm.removeNodeFromParent(cutNode);
        }
        if (null == targetPath) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)dtm.getRoot();
            int[] childIndices = new int[cutNodes.size()];
            for (i = 0; i < cutNodes.size(); ++i) {
                childIndices[i] = root.getChildCount();
                root.add((MutableTreeNode)cutNodes.get(i));
            }
            dtm.nodesWereInserted(root, childIndices);
        } else {
            DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)targetPath.getLastPathComponent();
            if (!this._treeDnDHandlerCallback.nodeAcceptsKids(selNode)) {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)selNode.getParent();
                for (i = 0; i < cutNodes.size(); ++i) {
                    parent.insert((MutableTreeNode)cutNodes.get(i), parent.getIndex(selNode) + 1);
                }
                dtm.nodeStructureChanged(parent);
            } else {
                for (int i3 = 0; i3 < cutNodes.size(); ++i3) {
                    selNode.add((MutableTreeNode)cutNodes.get(i3));
                }
                dtm.nodeStructureChanged(selNode);
            }
        }
        TreePath[] newSelPaths = new TreePath[cutNodes.size()];
        for (int i4 = 0; i4 < newSelPaths.length; ++i4) {
            newSelPaths[i4] = new TreePath(((DefaultMutableTreeNode)cutNodes.get(i4)).getPath());
        }
        this._tree.setSelectionPaths(newSelPaths);
    }
}

