/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action;

import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.ClobDescriptor;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.ExportFileContainer;
import net.sourceforge.squirrel_sql.fw.gui.action.TableExportCsvController;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.DataExportCSVWriter;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.DataExportExcelWriter;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.DataExportXMLWriter;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.ExportDataException;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.IExportData;
import net.sourceforge.squirrel_sql.fw.sql.ProgressAbortCallback;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public abstract class AbstractExportCommand {
    static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AbstractExportCommand.class);
    static ILogger s_log = LoggerController.createLogger(AbstractExportCommand.class);
    private ProgressAbortCallback progressController = null;
    private File targetFile;
    private ExportFileContainer fileContainer = ExportFileContainer.getInstance();
    private long writtenRows = -1L;

    protected long writeFile(TableExportCsvController ctrl, IExportData data) {
        File file = null;
        try {
            file = ctrl.getFile();
            if (null != file.getParentFile()) {
                file.getParentFile().mkdirs();
            }
            boolean includeHeaders = ctrl.includeHeaders();
            if (0 == ctrl.getExportFormat()) {
                return new DataExportCSVWriter(file, ctrl, includeHeaders, this.progressController).write(data);
            }
            if (1 == ctrl.getExportFormat()) {
                return new DataExportExcelWriter(file, ctrl, includeHeaders, this.progressController).write(data);
            }
            if (2 == ctrl.getExportFormat()) {
                return new DataExportXMLWriter(file, ctrl, includeHeaders, this.progressController).write(data);
            }
            throw new IllegalStateException("Unknown export format " + ctrl.getExportFormat());
        }
        catch (Exception e) {
            Object[] params = new Object[]{file, e.getMessage()};
            String msg = s_stringMgr.getString("TableExportCsvCommand.failedToWriteFile", params);
            s_log.error(msg, e);
            JOptionPane.showMessageDialog(GUIUtils.getMainFrame(), msg);
            return -1L;
        }
    }

    private void executeCommand(String command) {
        try {
            Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            Object[] params = new Object[]{command, e.getMessage()};
            String msg = s_stringMgr.getString("TableExportCsvCommand.failedToExecuteCommand", params);
            s_log.error(msg, e);
            JOptionPane.showMessageDialog(GUIUtils.getMainFrame(), msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws ExportDataException {
        try {
            TableExportCsvController ctrl;
            boolean fileIsInUse = false;
            do {
                if (!(ctrl = this.createTableExportController()).isOK()) {
                    return;
                }
                if (this.checkMissingData(ctrl.getSeparatorChar())) {
                    int choice = JOptionPane.showConfirmDialog(GUIUtils.getMainFrame(), i18n.missingClobDataMsg);
                    if (choice == 0) {
                        // empty if block
                    }
                    if (choice == 1) {
                        return;
                    }
                    if (choice == 2) {
                        return;
                    }
                }
                this.targetFile = ctrl.getFile();
                if (!this.fileContainer.add(this.targetFile)) {
                    fileIsInUse = true;
                    JOptionPane.showMessageDialog(GUIUtils.getMainFrame(), i18n.ANOTHER_EXPORT_IS_ACTIVE, i18n.TITLE_ANOTHER_EXPORT_IS_ACTIVE, 2);
                    continue;
                }
                fileIsInUse = false;
            } while (fileIsInUse);
            this.progressController = this.createProgressController();
            try {
                this.writtenRows = this.writeFile(ctrl, this.createExportData(ctrl));
            }
            catch (ExportDataException e) {
                s_log.error(i18n.FAILED);
                JOptionPane.showMessageDialog(GUIUtils.getMainFrame(), i18n.FAILED);
                throw e;
            }
            if (this.writtenRows >= 0L) {
                String command = ctrl.getCommand();
                if (null != command) {
                    this.executeCommand(command);
                } else {
                    String msg = s_stringMgr.getString("TableExportCsvCommand.writeFileSuccess", NumberFormat.getIntegerInstance().format(this.writtenRows), ctrl.getFile().getAbsolutePath());
                    if (s_log.isInfoEnabled()) {
                        s_log.info(msg);
                    }
                    JOptionPane.showMessageDialog(GUIUtils.getMainFrame(), msg);
                }
            } else {
                s_log.info(i18n.FAILED);
                JOptionPane.showMessageDialog(GUIUtils.getMainFrame(), i18n.FAILED);
            }
        }
        finally {
            if (this.targetFile != null) {
                this.fileContainer.remove(this.targetFile);
            }
        }
    }

    protected ProgressAbortCallback createProgressController() {
        return null;
    }

    protected TableExportCsvController createTableExportController() {
        return new TableExportCsvController();
    }

    protected abstract boolean checkMissingData(String var1);

    protected abstract IExportData createExportData(TableExportCsvController var1) throws ExportDataException;

    public ProgressAbortCallback getProgressController() {
        return this.progressController;
    }

    public void setProgressController(ProgressAbortCallback progressController) {
        this.progressController = progressController;
    }

    protected void progress(String task) {
        if (this.progressController != null) {
            this.progressController.currentlyLoading(task);
        }
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    public long getWrittenRows() {
        return this.writtenRows;
    }

    static interface i18n {
        public static final String missingClobDataMsg = s_stringMgr.getString("TableExportCsvCommand.missingClobDataMsg", ClobDescriptor.i18n.CLOB_LABEL);
        public static final String FAILED = s_stringMgr.getString("AbstractExportCommand.failed");
        public static final String ANOTHER_EXPORT_IS_ACTIVE = s_stringMgr.getString("AbstractExportCommand.anotherExportIsActive");
        public static final String TITLE_ANOTHER_EXPORT_IS_ACTIVE = s_stringMgr.getString("AbstractExportCommand.anotherExportIsActive.title");
    }
}

