/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.gui.action.AbstractExportCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.ResultSetExportCsvController;
import net.sourceforge.squirrel_sql.fw.gui.action.TableExportCsvController;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.ExportDataException;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.IExportData;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.ResultSetExportData;
import net.sourceforge.squirrel_sql.fw.sql.ProgressAbortCallback;
import net.sourceforge.squirrel_sql.fw.sql.ProgressAbortFactoryCallback;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ResultSetExportCommand
extends AbstractExportCommand {
    static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ResultSetExportCommand.class);
    static ILogger log = LoggerController.createLogger(ResultSetExportCommand.class);
    private ResultSet resultSet;
    private DialectType dialect;
    private String sql;
    private Statement stmt;
    private ProgressAbortFactoryCallback progressControllerFactory;

    public ResultSetExportCommand(Statement stmt, String sql, DialectType dialect, ProgressAbortFactoryCallback progressControllerFactory) {
        this.sql = sql;
        this.stmt = stmt;
        this.dialect = dialect;
        this.progressControllerFactory = progressControllerFactory;
    }

    @Override
    protected boolean checkMissingData(String sepChar) {
        return false;
    }

    @Override
    protected IExportData createExportData(TableExportCsvController ctrl) throws ExportDataException {
        try {
            super.progress("Running the query");
            this.resultSet = this.stmt.executeQuery(this.sql);
            return new ResultSetExportData(this.resultSet, this.dialect);
        }
        catch (SQLException e) {
            log.error(i18n.ERROR_EXECUTE_STATEMENT, e);
            throw new ExportDataException(i18n.ERROR_EXECUTE_STATEMENT, e);
        }
    }

    @Override
    protected TableExportCsvController createTableExportController() {
        return new ResultSetExportCsvController();
    }

    @Override
    protected ProgressAbortCallback createProgressController() {
        return this.progressControllerFactory.create();
    }

    public String getSql() {
        return this.sql;
    }

    static interface i18n {
        public static final String ERROR_EXECUTE_STATEMENT = s_stringMgr.getString("ResultSetExportCommand.errorExecuteStatement");
    }
}

