/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.wikiTable;

import java.io.Serializable;
import net.sourceforge.squirrel_sql.fw.gui.action.wikiTable.GenericWikiTableTransformer;
import net.sourceforge.squirrel_sql.fw.gui.action.wikiTable.IWikiTableConfiguration;
import net.sourceforge.squirrel_sql.fw.gui.action.wikiTable.IWikiTableTransformer;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import org.apache.commons.lang.StringUtils;

public class GenericWikiTableConfigurationBean
implements IWikiTableConfiguration,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(GenericWikiTableConfigurationBean.class);
    private String name;
    private String tableStartTag;
    private String headerStartTag;
    private String headerCell;
    private String headerEndTag;
    private String rowStartTag;
    private String dataCell;
    private String rowEndTag;
    private String tableEndTag;
    private String noWikiTag;
    private boolean enabled = true;
    private boolean initialized = false;

    public GenericWikiTableConfigurationBean() {
        this.setDataCell("%V");
        this.setHeaderCell("%V");
        this.setNoWikiTag("%V");
        this.initialized = true;
    }

    public GenericWikiTableConfigurationBean(String name, String tableStartTag, String headerStartTag, String headerCell, String headerEnd, String rowStartTag, String dataCell, String rowEndTag, String tableEndTag, String noWikiTag) {
        this.setName(name);
        this.setTableStartTag(tableStartTag);
        this.setHeaderStartTag(headerStartTag);
        this.setHeaderCell(headerCell);
        this.setHeaderEndTag(headerEnd);
        this.setRowStartTag(rowStartTag);
        this.setDataCell(dataCell);
        this.setRowEndTag(rowEndTag);
        this.setTableEndTag(tableEndTag);
        this.setNoWikiTag(noWikiTag);
        this.initialized = true;
    }

    public GenericWikiTableConfigurationBean(IWikiTableConfiguration copy) {
        this.setName(copy.getName());
        this.setTableStartTag(copy.getTableStartTag());
        this.setHeaderStartTag(copy.getHeaderStartTag());
        this.setHeaderCell(copy.getHeaderCell());
        this.setHeaderEndTag(copy.getHeaderEndTag());
        this.setRowStartTag(copy.getRowStartTag());
        this.setDataCell(copy.getDataCell());
        this.setRowEndTag(copy.getRowEndTag());
        this.setTableEndTag(copy.getTableEndTag());
        this.setNoWikiTag(copy.getNoWikiTag());
        this.setEnabled(copy.isEnabled());
        this.initialized = true;
    }

    @Override
    public String getTableStartTag() {
        return this.tableStartTag;
    }

    @Override
    public void setTableStartTag(String tableStartTag) {
        this.checkReadOnly();
        this.tableStartTag = tableStartTag;
    }

    @Override
    public String getHeaderStartTag() {
        return this.headerStartTag;
    }

    @Override
    public void setHeaderStartTag(String headerStartTag) {
        this.checkReadOnly();
        this.headerStartTag = headerStartTag;
    }

    @Override
    public String getHeaderCell() {
        return this.headerCell;
    }

    @Override
    public void setHeaderCell(String headerCell) {
        this.checkReadOnly();
        if (!StringUtils.contains(headerCell, "%V")) {
            throw new IllegalArgumentException(s_stringMgr.getString("GenericWikiTableConfigurationBean.headerCellErrorValueVariableMissing"));
        }
        this.headerCell = headerCell;
    }

    @Override
    public String getHeaderEndTag() {
        return this.headerEndTag;
    }

    @Override
    public void setHeaderEndTag(String headerEndTag) {
        this.checkReadOnly();
        this.headerEndTag = headerEndTag;
    }

    @Override
    public String getRowStartTag() {
        return this.rowStartTag;
    }

    @Override
    public void setRowStartTag(String rowStartTag) {
        this.checkReadOnly();
        this.rowStartTag = rowStartTag;
    }

    @Override
    public String getDataCell() {
        return this.dataCell;
    }

    @Override
    public void setDataCell(String dataCell) {
        this.checkReadOnly();
        if (!StringUtils.contains(dataCell, "%V")) {
            throw new IllegalArgumentException(s_stringMgr.getString("GenericWikiTableConfigurationBean.dataCellErrorValueVariableMissing"));
        }
        this.dataCell = dataCell;
    }

    @Override
    public String getRowEndTag() {
        return this.rowEndTag;
    }

    @Override
    public void setRowEndTag(String rowEndTag) {
        this.checkReadOnly();
        this.rowEndTag = rowEndTag;
    }

    @Override
    public String getTableEndTag() {
        return this.tableEndTag;
    }

    @Override
    public void setTableEndTag(String tableEndTag) {
        this.checkReadOnly();
        this.tableEndTag = tableEndTag;
    }

    @Override
    public IWikiTableTransformer createTransformer() {
        return new GenericWikiTableTransformer(this);
    }

    @Override
    public String getNoWikiTag() {
        return this.noWikiTag;
    }

    @Override
    public void setNoWikiTag(String escapeSequence) {
        this.checkReadOnly();
        if (!StringUtils.contains(escapeSequence, "%V")) {
            throw new IllegalArgumentException(s_stringMgr.getString("GenericWikiTableConfigurationBean.noWikiErrorValueVariableMissing"));
        }
        this.noWikiTag = escapeSequence;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.checkReadOnly();
        if (StringUtils.isBlank(name)) {
            throw new IllegalArgumentException(s_stringMgr.getString("GenericWikiTableConfigurationBean.nameIsRequired"));
        }
        this.name = name;
    }

    public String toString() {
        if (StringUtils.isBlank(this.name)) {
            return s_stringMgr.getString("GenericWikiTableConfigurationBean.unnamed");
        }
        return this.name;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public IWikiTableConfiguration clone() {
        return new GenericWikiTableConfigurationBean(this);
    }

    private void checkReadOnly() {
        if (this.initialized && this.isReadOnly()) {
            throw new IllegalArgumentException("A read-only configuration could not be changed!");
        }
    }

    @Override
    public IWikiTableConfiguration copyAsUserSpecific() {
        return new GenericWikiTableConfigurationBean(this);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericWikiTableConfigurationBean other = (GenericWikiTableConfigurationBean)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

