/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.wikiTable;

import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.SquirrelTableCellRenderer;
import net.sourceforge.squirrel_sql.fw.gui.action.wikiTable.IWikiTableConfiguration;
import net.sourceforge.squirrel_sql.fw.gui.action.wikiTable.IWikiTableTransformer;
import org.apache.commons.lang.StringUtils;

public class GenericWikiTableTransformer
implements IWikiTableTransformer {
    public static String NEW_LINE = System.getProperty("line.separator");
    private IWikiTableConfiguration configuration = null;

    public GenericWikiTableTransformer() {
    }

    public GenericWikiTableTransformer(IWikiTableConfiguration configuration) {
        this.setConfiguration(configuration);
    }

    @Override
    public String transform(JTable table) {
        int nbrSelRows = table.getSelectedRowCount();
        int nbrSelCols = table.getSelectedColumnCount();
        int[] selRows = table.getSelectedRows();
        int[] selCols = table.getSelectedColumns();
        if (selRows.length != 0 && selCols.length != 0) {
            StringBuilder buf = new StringBuilder(1024);
            this.appendWithReplacement(buf, this.configuration.getTableStartTag());
            this.appendWithReplacement(buf, this.configuration.getHeaderStartTag());
            for (int colIdx = 0; colIdx < nbrSelCols; ++colIdx) {
                this.appendWithReplacement(buf, this.configuration.getHeaderCell(), table.getColumnName(selCols[colIdx]));
            }
            this.appendWithReplacement(buf, this.configuration.getHeaderEndTag());
            for (int rowIdx = 0; rowIdx < nbrSelRows; ++rowIdx) {
                this.appendWithReplacement(buf, this.configuration.getRowStartTag());
                for (int colIdx = 0; colIdx < nbrSelCols; ++colIdx) {
                    String tmp;
                    TableCellRenderer cellRenderer = table.getCellRenderer(selRows[rowIdx], selCols[colIdx]);
                    Object cellObj = table.getValueAt(selRows[rowIdx], selCols[colIdx]);
                    if (cellRenderer instanceof SquirrelTableCellRenderer) {
                        cellObj = ((SquirrelTableCellRenderer)((Object)cellRenderer)).renderValue(cellObj);
                    }
                    String value = null;
                    value = cellObj == null ? "" : ((tmp = cellObj.toString()).trim().equals("") ? "" : tmp);
                    this.appendWithReplacement(buf, this.configuration.getDataCell(), value);
                }
                this.appendWithReplacement(buf, this.configuration.getRowEndTag());
            }
            this.appendWithReplacement(buf, this.configuration.getTableEndTag());
            return buf.toString();
        }
        return null;
    }

    public void appendWithReplacement(StringBuilder buff, String token) {
        this.appendWithReplacement(buff, token, null);
    }

    public void appendWithReplacement(StringBuilder buff, String token, String value) {
        if (StringUtils.contains(token, "%V") && value == null) {
            value = "";
        } else if (!StringUtils.contains(token, "%V") && value != null) {
            throw new IllegalStateException("there is no place holder for the value, but I should inject a value!");
        }
        if (StringUtils.isNotBlank(token)) {
            if (StringUtils.contains(token, "%V")) {
                value = this.escapeString(value);
            }
            value = this.replacePlaceHolder(token, value);
            buff.append(value);
        }
    }

    private String replacePlaceHolder(String token, String value) {
        if (StringUtils.isNotBlank(token)) {
            String newValue = token.replace("%N", NEW_LINE);
            if (StringUtils.isNotEmpty(value)) {
                newValue = newValue.replace("%V", value);
            }
            return newValue;
        }
        return value;
    }

    protected String escapeString(String valueString) {
        return this.replacePlaceHolder(this.configuration.getNoWikiTag(), valueString);
    }

    public IWikiTableConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(IWikiTableConfiguration configuration) {
        this.configuration = configuration;
    }
}

