/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.wikiTable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.gui.action.wikiTable.IWikiTableConfiguration;
import net.sourceforge.squirrel_sql.fw.gui.action.wikiTable.IWikiTableConfigurationFactory;
import org.apache.commons.lang.StringUtils;

public class WikiTableConfigurationFactory
implements IWikiTableConfigurationFactory {
    private List<IWikiTableConfiguration> buildInConfigurations = null;
    private List<IWikiTableConfiguration> userSpecificConfigurations = null;
    private static IWikiTableConfigurationFactory instance = null;

    WikiTableConfigurationFactory() {
        this.loadConfigurations();
    }

    private void loadConfigurations() {
        this.buildInConfigurations = new ArrayList<IWikiTableConfiguration>();
        this.userSpecificConfigurations = new ArrayList<IWikiTableConfiguration>();
    }

    @Override
    public synchronized List<IWikiTableConfiguration> getConfigurations() {
        ArrayList<IWikiTableConfiguration> result = new ArrayList<IWikiTableConfiguration>();
        result.addAll(this.getBuildInConfigurations());
        result.addAll(this.getUserSpecificConfigurations());
        this.sortByName(result);
        return result;
    }

    private void sortByName(List<IWikiTableConfiguration> list) {
        Collections.sort(list, new Comparator<IWikiTableConfiguration>(){

            @Override
            public int compare(IWikiTableConfiguration o1, IWikiTableConfiguration o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    @Override
    public synchronized List<IWikiTableConfiguration> getUserSpecificConfigurations() {
        ArrayList<IWikiTableConfiguration> result = new ArrayList<IWikiTableConfiguration>();
        for (IWikiTableConfiguration config : this.userSpecificConfigurations) {
            result.add(config.clone());
        }
        this.sortByName(result);
        return result;
    }

    @Override
    public synchronized List<IWikiTableConfiguration> getBuildInConfigurations() {
        ArrayList<IWikiTableConfiguration> result = new ArrayList<IWikiTableConfiguration>();
        for (IWikiTableConfiguration config : this.buildInConfigurations) {
            result.add(config.clone());
        }
        this.sortByName(result);
        return result;
    }

    public static synchronized IWikiTableConfigurationFactory getInstance() {
        if (instance == null) {
            instance = new WikiTableConfigurationFactory();
        }
        return instance;
    }

    @Override
    public synchronized void addBuilInConfiguration(IWikiTableConfiguration additionalBuildInConfig) {
        if (!additionalBuildInConfig.isReadOnly()) {
            throw new IllegalArgumentException("A not read-only configuration cannot be a build-in configuration!");
        }
        if (!this.isNameUnique(additionalBuildInConfig)) {
            throw new IllegalArgumentException("The name of the configuration " + additionalBuildInConfig.getName() + " is not unique!");
        }
        this.buildInConfigurations.add(additionalBuildInConfig.clone());
    }

    @Override
    public synchronized void replaceBuilInConfiguration(List<IWikiTableConfiguration> configurations) {
        this.buildInConfigurations.clear();
        for (IWikiTableConfiguration config : configurations) {
            this.addBuilInConfiguration(config);
        }
    }

    private boolean isNameUnique(IWikiTableConfiguration aConfig) {
        if (!this.isNameUnique(this.buildInConfigurations, aConfig)) {
            return false;
        }
        return this.isNameUnique(this.userSpecificConfigurations, aConfig);
    }

    private boolean isNameUnique(List<IWikiTableConfiguration> avaiableConfigs, IWikiTableConfiguration aConfig) {
        for (IWikiTableConfiguration avaiableConfig : avaiableConfigs) {
            if (!StringUtils.equalsIgnoreCase(avaiableConfig.getName(), aConfig.getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized void replaceUserSpecificConfigurations(List<IWikiTableConfiguration> config) {
        this.userSpecificConfigurations.clear();
        for (IWikiTableConfiguration aConfig : config) {
            this.addUserSpecificConfigurations(aConfig);
        }
    }

    @Override
    public void addUserSpecificConfigurations(IWikiTableConfiguration config) {
        if (config.isReadOnly()) {
            throw new IllegalArgumentException("A read-only configuration cannot be added to the user specific configurations!");
        }
        if (!this.isNameUnique(config)) {
            throw new IllegalArgumentException("The name of the configuration " + config.getName() + " is not unique!");
        }
        this.userSpecificConfigurations.add(config.clone());
    }

    public synchronized void setBuildInConfigurations(List<IWikiTableConfiguration> buildInConfigurations) {
        this.buildInConfigurations = buildInConfigurations;
    }

    public synchronized void setUserSpecificConfigurations(List<IWikiTableConfiguration> userSpecificConfigurations) {
        this.userSpecificConfigurations = userSpecificConfigurations;
    }

    public static List<IWikiTableConfiguration> merge(List<IWikiTableConfiguration> primary, List<IWikiTableConfiguration> secondary) {
        ArrayList<IWikiTableConfiguration> result = new ArrayList<IWikiTableConfiguration>(primary);
        ArrayList<IWikiTableConfiguration> candidates = new ArrayList<IWikiTableConfiguration>(secondary);
        for (IWikiTableConfiguration aPrimary : primary) {
            Iterator it = candidates.iterator();
            while (it.hasNext()) {
                IWikiTableConfiguration aSecondary = (IWikiTableConfiguration)it.next();
                if (!StringUtils.equalsIgnoreCase(aPrimary.getName(), aSecondary.getName())) continue;
                it.remove();
            }
        }
        result.addAll(candidates);
        return result;
    }
}

