/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.debug;

import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import net.sourceforge.squirrel_sql.fw.gui.debug.DebugBorder;
import org.apache.commons.lang.StringUtils;

public class DebugEventListener
implements AWTEventListener {
    public void setEnabled(boolean enable) {
        Toolkit kit = Toolkit.getDefaultToolkit();
        if (enable) {
            kit.addAWTEventListener(this, 48L);
            ToolTipManager.sharedInstance().setDismissDelay(10000);
        } else {
            kit.removeAWTEventListener(this);
        }
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        Object o = event.getSource();
        if (o instanceof JComponent && o != null) {
            JComponent source = (JComponent)o;
            switch (event.getID()) {
                case 506: {
                    this.printDebugInfo(source, event);
                    break;
                }
                case 504: {
                    this.printDebugInfo(source, event);
                    this.setToolTipText(source, event);
                    this.setBorder(source, event);
                    break;
                }
                case 505: {
                    this.printDebugInfo(source, event);
                    this.setBorder(source, event);
                }
            }
        }
    }

    private void setBorder(JComponent source, AWTEvent event) {
        Border border = source.getBorder();
        switch (event.getID()) {
            case 504: {
                if (border == null) break;
                source.setBorder(new DebugBorder(border));
                break;
            }
            case 505: {
                if (border == null || !(border instanceof DebugBorder)) break;
                source.setBorder(((DebugBorder)border).getDelegate());
            }
        }
    }

    private void setToolTipText(JComponent source, AWTEvent event) {
        Container parent = source.getParent();
        String sourceName = source.getName();
        String sourceClassName = source.getClass().toString();
        String parentClassName = parent == null ? null : parent.getClass().toString();
        StringBuilder toolTipText = new StringBuilder(this.getEventMessagePrefix(event));
        if (source instanceof AbstractButton) {
            toolTipText.append("Button with parentClass=");
            toolTipText.append(parentClassName);
        } else if (!StringUtils.isEmpty(sourceName)) {
            toolTipText.append(sourceName);
        } else if (!StringUtils.isEmpty(sourceClassName)) {
            toolTipText.append(sourceClassName);
        }
        source.setToolTipText(toolTipText.toString());
    }

    private void printDebugInfo(JComponent source, AWTEvent event) {
        Container parent = source.getParent();
        String sourceName = source.getName();
        String sourceClassName = source.getClass().toString();
        String parentName = parent == null ? null : parent.getName();
        String parentClassName = parent == null ? null : parent.getClass().toString();
        StringBuilder msg = new StringBuilder(this.getEventMessagePrefix(event));
        msg.append("\n");
        msg.append("\t sourceName:").append(sourceName).append("\n");
        msg.append("\t sourceClassName:").append(sourceClassName).append("\n");
        msg.append("\t parentName:").append(parentName).append("\n");
        msg.append("\t parentClassName:").append(parentClassName);
        System.out.println(msg.toString());
    }

    private String getEventMessagePrefix(AWTEvent event) {
        String result = null;
        switch (event.getID()) {
            case 506: {
                result = "Mouse dragged: ";
                break;
            }
            case 504: {
                result = "Mouse entered: ";
                break;
            }
            case 505: {
                result = "Mouse exited: ";
                break;
            }
            default: {
                result = "Unknown EventType: ";
            }
        }
        return result;
    }
}

